<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php"); 

//Requete print
$date1=$_POST["date1"];
$date2=$_POST["date2"];
$idLd=$_POST["idLd"];

$requeteUser="SELECT * FROM depense 
INNER JOIN users ON users.idUser=depense.idUser
INNER JOIN lignedepense ON lignedepense.idLd=depense.idLd
INNER JOIN t_an ON lignedepense.idA=t_an.idA WHERE depense.idLd='$idLd'
AND dateDep BETWEEN '$date1' AND '$date2' ORDER BY dateDep DESC";
$rowCountRequete = $pdo->query($requeteUser)->rowCount();
if($rowCountRequete===0){
    #Message d'ERREUR
    $msg_erreur = "Il n'y a pas d'informations à renvoyer sur ce rapport";
    header("Location:../Admin/dep.php?erreur=$msg_erreur");
    exit;
}else{
    $res=$pdo->query($requeteUser)->fetch();

    $requeteSomme="SELECT SUM(tarif) AS sommeFac 
    FROM depense 
    INNER JOIN users ON users.idUser=depense.idUser
    INNER JOIN lignedepense ON lignedepense.idLd=depense.idLd
    INNER JOIN t_an ON lignedepense.idA=t_an.idA WHERE depense.idLd='$idLd'
    AND  dateDep  BETWEEN '$date1' AND '$date2'";
    $resSomme=$pdo->query($requeteSomme)->fetch();
    $sommeFacture = $resSomme['sommeFac'];

    $rowMedicament = $pdo->query($requeteUser)->rowCount();
    $numFac = sprintf('%04d', $rowMedicament);

    $image1 = "../uploads/logo.png";
    $pdf=new FPDF();
    $pdf->AddPage();
    $pdf->Image($image1, 5, $pdf->GetY(), 36.78);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,20,"REPUBLIQUE DEMOCRATIQUE DU CONGO",0,0,'C');
    $pdf->Ln(15);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,"MINISTERE DE L'ENSEIGNEMENT PRIMAIRE,",0,0,'C');
    $pdf->Ln(7);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,"SECONDAIRE ET TECHNIQUE",0,0,'C');
    $pdf->Ln(6);
    $pdf->setFont('courier','',15);
    $pdf->cell(0,4,"COMPLEXE SCOLAIRE LA RECONNAISSANCE",0,0,'C');
    $pdf->Ln(10);
    $pdf->SetTextColor(0,0,0);
    $pdf->setFont('courier','B',12);
    $pdf->Cell(130 ,5,"SITUATION DES DEPENSES PAR LIGNE DE DEPANSES",0,0);

    //set font to arial, regular, 12pt
    $pdf->SetFont('Arial','',10);

    $pdf->Cell(59 ,5,'',0,1);//end of line
    $pdf->Ln(5);
    $pdf->Cell(130 ,5,utf8_decode('Nbr Dépenses : ').$numFac,0,0);
    $pdf->Cell(25 ,5,'DATE 1 : ',0,0);
    $pdf->Cell(34 ,5,date('d-m-Y',strtotime($date1))." jusqu'au",0,1);//end of line

    $pdf->Cell(130 ,5,utf8_decode('Ligne des dépenses : ').strtoupper($res['designLd']),0,0);
    $pdf->Cell(25 ,5,'DATE 2 : ',0,0);
    $pdf->Cell(34 ,5,date('d-m-Y',strtotime($date2)),0,1);//end of line

    $pdf->Ln(5);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(10,7,utf8_decode('N°'),1,0,'C');
    $pdf->cell(30,7,'DATE',1,0,'C');
    $pdf->setFont('Arial','B',8);
    $pdf->cell(30,7,'ANNEE_SCOLAIRE',1,0,'C');
    $pdf->setFont('Arial','B',10);
    $pdf->cell(85,7,'MOTIF',1,0,'C');
    $pdf->cell(40,7,'TARIF',1,0,'C');
    $pdf->Ln(7);

    $pdf->setFont('courier','',9);

        $i=1;
        $resultat=$pdo->query($requeteUser);
        if(isset($_POST['date1']) && isset($_POST['date2'])){
            while ($ins=$resultat->fetch()) { 
                $pdf->cell(10,7, $i++,1,0,'C');
                $pdf->cell(30,7, utf8_decode(date('d-m-Y',strtotime($ins['dateDep']))),1);
                $pdf->cell(30,7, utf8_decode($ins['designA']),1);
                $pdf->cell(85,7, utf8_decode(substr($ins['motif'],0,35)),1);
                $pdf->cell(40,7, utf8_decode(number_format($ins['tarif'],2,'.',' ').' $'),1,0,'R');
                $pdf->Ln(7);
            }
        }

    $pdf->setFont('Arial','B',10);
    $pdf->cell(70,7,'',0);
    $pdf->cell(85,7,"TOTAL RAPPORT",1);
    $pdf->cell(40,7,number_format($sommeFacture,2,'.',' ').' $',1,0,'R');
    $pdf->Ln(7);
    $pdf->cell(70,7,'',0);
    $pdf->cell(85,7,"TOTAL LIGNE DE DEPENSES",1);
    $pdf->cell(40,7,number_format($res['tarifLd'],2,'.',' ').' $',1,0,'R');
    $pdf->Ln(7);
    $pdf->cell(70,7,'',0);
    $pdf->cell(85,7,"ECART DES DEPENSES",1);
    $pdf->cell(40,7,number_format($res['tarifLd']-$sommeFacture,2,'.',' ').' $',1,0,'R');
    $pdf->Ln(7);
    $pdf->cell(70,7,'',0);
    $pdf->cell(85,7,"POURCENTAGES ACCUMULES",1);
    $pdf->cell(40,7,round(($sommeFacture / $res['tarifLd']) * 100, 2).' %',1,0,'R');
    $pdf->Ln(7);
    $pdf->setFont('Arial','I',9);
    //Décalage à droite
    $pdf->Cell(125);
    //Numéro de page
    $pdf->Cell(0,10,utf8_decode('Fait à Kananga Le ').date('d-m-Y A h:i:s A').' ',0,0,'C');
    
    $formatname = "rapport-" . date('dmYhis');
    $pdf->Output('../uploads/pdf/' . $formatname . '.pdf', 'F');

    header('Location: ' . $urlopen . $formatname . '.pdf');
    exit;
}
?>

