<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php"); 
date_default_timezone_set('Africa/Lubumbashi');
//Paramettre PRINT
$requeteParamPrint="SELECT * FROM parprintmag WHERE idP";
$resultatPrint=$pdo->query($requeteParamPrint)->fetch();

//Requete print
$requeteUser="SELECT * FROM invest";
$rowCountRequete = $pdo->query($requeteUser)->rowCount();
if($rowCountRequete===0){
    #Message d'ERREUR
    $msg_erreur = "Il n'y a pas d'informations à renvoyer sur ce rapport";
    header("Location:../Stock/investis.php?erreur=$msg_erreur");
    exit;
}else{

    $requeteCoutTotaol="SELECT SUM(paEn) AS coutTotalUn, SUM(stock) AS stockTotal, 
    SUM(paEn*stock) AS coutTotal FROM invest";
    $rowCoutTotaol=$pdo->query($requeteCoutTotaol)->fetch();
    $coutTotaol = $rowCoutTotaol['coutTotalUn'];
    $coutTotal = $rowCoutTotaol['coutTotal'];
    $sommeFacture=$rowCoutTotaol['stockTotal'];

    $image1 = "../uploads/".$resultatPrint['log'];

    $pdf=new FPDF();
    $pdf->AddPage('L');
    $pdf->Image($image1, 5, $pdf->GetY(), 36.78);
    $pdf->setFont('Arial','B',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,20,$resultatPrint['soc'],0,0,'C');
    $pdf->Ln(15);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->setFont('courier','',15);
    $pdf->cell(0,4,$resultatPrint['ad'],0,0,'C');
    $pdf->Ln(7);
    $pdf->SetTextColor(0,0,0);
    $pdf->setFont('courier','',15);
    $pdf->cell(0,4,$resultatPrint['pays'],0,0,'C');
    $pdf->Ln(6);
    $pdf->cell(0,4,'Contact : '.$resultatPrint['con'],0,0,'C');
    $pdf->Ln(6);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,'Email : '.$resultatPrint['em'],0,0,'C');
    $pdf->Ln(10);
    $pdf->SetTextColor(0,0,0);
    $pdf->setFont('courier','B',15);
    $pdf->Cell(130 ,5,"SITUATION D'INVESTISSEMENT",0,0);
    $pdf->Ln(10);
    //set font to arial, regular, 12pt
    $pdf->SetFont('Arial','',10);
    $pdf->Cell(130 ,5,utf8_decode('Nombre des produits : '.$rowCountRequete.' Produits'),0,0);
    $pdf->Cell(25 ,5,'',0,0);
    $pdf->Cell(34 ,5,'',0,1);//end of line

    $pdf->Cell(130 ,5,utf8_decode('Situation Générale'),0,0);
    $pdf->Cell(25 ,5,'',0,0);
    $pdf->Cell(34 ,5,'',0,1);//end of line

    $pdf->SetTextColor(0,0,0); 
    $pdf->setFont('Arial','U',15);
    $pdf->cell(55,8,'',0);
    $pdf->SetX(3);

    $pdf->cell(5,8,'',0);
    $pdf->Ln(5);
    $pdf->setFont('Arial','B',12);
    $pdf->cell(20,7,utf8_decode('N°'),1,0,'C');
    $pdf->cell(55,7,'PRODUIT',1,0,'C');
    $pdf->cell(45,7,'CATEGORIE',1,0,'C');
    $pdf->cell(30,7,'DATE',1,0,'C');
    $pdf->cell(30,7,'PAU EN $',1,0,'C');
    $pdf->cell(35,7,'STOCK',1,0,'C');
    $pdf->cell(65,7,'PRIX TOTAL EN $',1,0,'C');
    $pdf->Ln(7);

    $pdf->setFont('courier','',9);

    $i=1;
    $resultat=$pdo->query($requeteUser);
    while ($ins=$resultat->fetch()) { 
        $pdf->cell(20,7, $i++,1,0,'C');
        $pdf->cell(55,7, utf8_decode(substr($ins['design'],0,23)),1);
        $pdf->cell(45,7, utf8_decode(substr($ins['designCat'],0,22)),1);
        $pdf->cell(30,7, utf8_decode(date('d-m-Y', strtotime($ins['dateOp']))),1,0,'R');
        $pdf->cell(30,7, utf8_decode(number_format($ins['paEn'],2,'.',' ')),1,0,'R');
        $pdf->cell(35,7, utf8_decode($ins['stock']),1,0,'R');
        $pdf->cell(65,7, utf8_decode(number_format($ins['paEn']*$ins['stock'],2,'.',' ')),1,0,'R');
        $pdf->Ln(7);
    }

    $pdf->setFont('courier','B',10);
    $pdf->cell(75,7,'',0);
    $pdf->cell(45,7,'',0);
    $pdf->cell(30,7,'',0);
    $pdf->cell(30,7,'TOTAL INVESTI',1,0);
    $pdf->cell(100,7,number_format($coutTotal,2,'.',' ').' FC',1,0,'R');
    $pdf->Ln(7);

    $pdf->setFont('Arial','I',9);
    //Décalage à droite
    $pdf->Cell(215);
    //Numéro de page
    $pdf->Cell(0,10,utf8_decode('Fait à '.$resultatPrint['vil']).' Le '.date('d-m-Y H:i:s').' ',0,0,'C');
    $pdf->Ln(15);
    
    $formatname = "rapport-" . date('dmYhis');
    $uploadRep = "../uploads/pdfs/";
    $pdf->Output($uploadRep . $formatname . '.pdf', 'F');
    header('Location:' . $uploadRep . $formatname . '.pdf');
    exit;
}
?>

