<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php"); 
date_default_timezone_set('Africa/Lubumbashi');
//Paramettre PRINT
$requeteParamPrint="SELECT * FROM parprintmag WHERE idP";
$resultatPrint=$pdo->query($requeteParamPrint)->fetch();

//Requete print
$date1=$_POST["date1"];
$date2=$_POST["date2"];

$requeteUser="SELECT * FROM magdepense WHERE 
dateDep BETWEEN '$date1' AND '$date2' ORDER BY dateDep DESC";
$rowCountRequete = $pdo->query($requeteUser)->rowCount();
if($rowCountRequete===0){
    #Message d'ERREUR
    $msg_erreur = "Il n'y a pas d'informations à renvoyer sur ce rapport";
    header("Location:../Stock/dep.php?erreur=$msg_erreur");
    exit;
}else{
    $res=$pdo->query($requeteUser)->fetch();

    $requeteSomme="SELECT SUM(tarif) AS sommeFac 
    FROM magdepense WHERE dateDep BETWEEN '$date1' AND '$date2'";
    $resSomme=$pdo->query($requeteSomme)->fetch();
    $sommeFacture = $resSomme['sommeFac'];

    $rowMedicament = $pdo->query($requeteUser)->rowCount();
    $numFac = sprintf('%04d', $rowMedicament);

    $image1 = "../uploads/".$resultatPrint['log'];

    $pdf=new FPDF();
    $pdf->AddPage();
    $pdf->Image($image1, 5, $pdf->GetY(), 36.78);
    $pdf->setFont('Arial','B',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,20,$resultatPrint['soc'],0,0,'C');
    $pdf->Ln(15);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->setFont('courier','',15);
    $pdf->cell(0,4,$resultatPrint['ad'],0,0,'C');
    $pdf->Ln(7);
    $pdf->SetTextColor(0,0,0);
    $pdf->setFont('courier','',15);
    $pdf->cell(0,4,$resultatPrint['pays'],0,0,'C');
    $pdf->Ln(6);
    $pdf->cell(0,4,'Contact : '.$resultatPrint['con'],0,0,'C');
    $pdf->Ln(6);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,'Email : '.$resultatPrint['em'],0,0,'C');
    $pdf->Ln(10);

    $pdf->SetFont('Arial','B',14);

    //Cell(width , height , text , border , end line , [align] )

    $pdf->Cell(130 ,5,'SITUATION DE DEPENSES',0,0);

    //set font to arial, regular, 12pt
    $pdf->SetFont('Arial','',10);

    $pdf->Cell(59 ,5,'',0,1);//end of line

    $pdf->Cell(130 ,5,utf8_decode('Nbr Dépenses : ').$numFac,0,0);
    $pdf->Cell(25 ,5,'DATE 1 : ',0,0);
    $pdf->Cell(34 ,5,date('d-m-Y',strtotime($date1))." jusqu'au",0,1);//end of line

    $pdf->Cell(130 ,5,utf8_decode('Situation Périodique'),0,0);
    $pdf->Cell(25 ,5,'DATE 2 : ',0,0);
    $pdf->Cell(34 ,5,date('d-m-Y',strtotime($date2)),0,1);//end of line

    $pdf->SetTextColor(0,0,0); 
    $pdf->setFont('Arial','U',15);
    $pdf->cell(55,8,'',0);
    $pdf->SetX(3);

    $pdf->cell(5,8,'',0);
    $pdf->Ln(10);
    $pdf->setFont('Arial','B',12);
    $pdf->cell(10,7,utf8_decode('N°'),1,0,'C');
    $pdf->cell(25,7,'DATE',1,0,'C');
    $pdf->cell(100,7,'MOTIF',1,0,'C');
    $pdf->cell(60,7,'TARIF',1,0,'C');
    $pdf->Ln(7);

    $pdf->setFont('courier','',9);

        $i=1;
        $resultat=$pdo->query($requeteUser);
        if(isset($_POST['date1']) && isset($_POST['date2'])){
            while ($ins=$resultat->fetch()) { 
                $pdf->cell(10,7, $i++,1,0,'C');
                $pdf->cell(25,7, utf8_decode(date('d-m-Y',strtotime($ins['dateDep']))),1);
                $pdf->cell(100,7, utf8_decode(substr($ins['motif'],0,50)),1);
                $pdf->cell(60,7, utf8_decode(number_format($ins['tarif'],2,'.',' ').' FC'),1,0,'R');
                $pdf->Ln(7);
            }
        }

    $pdf->setFont('Arial','B',10);
    $pdf->cell(35,7,'',0);
    $pdf->cell(100,7,"TOTAL RAPPORT",1);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(60,7,number_format($sommeFacture,2,'.',' ').' FC',1,0,'R');
    $pdf->Ln(7);
    $pdf->setFont('Arial','I',9);
    //Décalage à droite
    $pdf->Cell(125);
    //Numéro de page
    $pdf->Cell(0,10,utf8_decode('Fait à '.$resultatPrint['vil']).' Le '.date('d-m-Y H:i:s').' ',0,0,'C');
    
    $formatname = "rapport-" . date('dmYhis');
    $uploadRep = "../uploads/pdfs/";
    $pdf->Output($uploadRep . $formatname . '.pdf', 'F');
    header('Location:' . $uploadRep . $formatname . '.pdf');
    exit;
}
?>

