<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php");

if (!isset($_POST['idPR'])) {
    // Ajoutez un script JavaScript pour revenir à la page précédente
    echo "<script>
     setTimeout(function() {
         window.history.back();
     }, 0); // 0 milliseconde
   </script>";
}

class myPDF extends FPDF {
    
    function Table($pdo){
        $idPR = $_POST['idPR'];
        $requser = $pdo->query("SELECT * FROM 
        t_redevable INNER JOIN t_classe ON t_redevable.idC=t_classe.idC 
        INNER JOIN t_an ON t_redevable.idA=t_an.idA 
        INNER JOIN t_option ON t_classe.idO=t_option.idO
        INNER JOIN t_inscrit ON t_redevable.idI = t_inscrit.idI 
        INNER JOIN t_payered ON t_redevable.idR = t_payered.idR 
        INNER JOIN users ON t_payered.idUser = users.idUser 
        WHERE t_payered.idPR='$idPR'");

        while ($userinf = $requser->fetch()) {
            $idI = $userinf['idI'];

            $dejaPayer = $pdo->query("SELECT SUM(montPR) AS dejaPayer FROM 
            t_redevable INNER JOIN t_classe ON t_redevable.idC=t_classe.idC 
            INNER JOIN t_an ON t_redevable.idA=t_an.idA 
            INNER JOIN t_option ON t_classe.idO=t_option.idO
            INNER JOIN t_inscrit ON t_redevable.idI = t_inscrit.idI 
            INNER JOIN t_payered ON t_redevable.idR = t_payered.idR 
            INNER JOIN users ON t_payered.idUser = users.idUser
            WHERE t_inscrit.idI='$idI'")->fetch();
            $montantDejaPaye = $dejaPayer['dejaPayer'];
            $map = $userinf['montR']+$dejaPayer['dejaPayer'];
            $resteAPayer = $map-$montantDejaPaye;

            $this->AddPage();
            
            // En-tête de page
            $this->SetFont('courier', '', 10);
            $this->Cell(90, 0, 'REPUBLIQUE DEMOCRATIQUE DU CONGO', 0, 0, 'C');
            $this->Ln(4);
            $this->Cell(90, 0, "MINISTERE DE L'ENSEIGNEMENT PRIMAIRE", 0, 0, 'C');
            $this->Ln(4);
            $this->Cell(90, 0, "SECONDAIRE ET TECHNIQUE", 0, 0, 'C');
            $this->Ln(4);
            $this->SetFont('courier', 'B', 10);
            $this->Cell(90, 0, 'COMPLEXE SCOLAIRE LA RECONNAISSANCE', 0, 0, 'C');
            $this->Ln(4);
            $this->SetX(1);
            $this->Image('../uploads/logo.png', 1, 7, 15, 15);
            $this->Line(0, 25, 270-50, 25);
            $this->Ln(2);

            // Reste de l'en-tête
            $this->SetFont('Arial', 'B', 12);
            $this->Cell(0, 6, utf8_decode("RECU DE PAIEMENT N° " . sprintf('%06d', $userinf['idPR'])), 0, 1, 'C');
            $this->Ln(4);

            // Informations sur l'étudiant alignées à droite
            $this->SetFont('Helvetica', '', 10);
            $this->Cell(10, 5, 'Nom : ', 0, 0, 'L');
            $this->SetFont('Helvetica', 'B', 10);
            $this->Cell(0, 5, utf8_decode($userinf['nom']), 0, 1, 'L');

            $this->SetFont('Helvetica', '', 10);
            $this->Cell(14, 5, 'Classe : ', 0, 0, 'L');
            $this->SetFont('Helvetica', 'B', 10);
            $this->Cell(0, 5, utf8_decode($userinf['design'].' '.$userinf['designO'].' '.$userinf['ord']), 0, 1, 'L');

            $this->SetFont('Helvetica', '', 10);
            $this->Cell(28, 5, utf8_decode('Année Scolaire : '), 0, 0, 'L');
            $this->SetFont('Helvetica', 'B', 10);
            $this->Cell(0, 5, $userinf['designA'], 0, 1, 'L');

            $this->SetFont('Helvetica', '', 10);
            $this->Cell(10, 5, 'Motif : ', 0, 0, 'L');
            $this->SetFont('Helvetica', 'B', 10);
            $this->Cell(0, 5, utf8_decode("Paiement des redevabilités"), 0, 1, 'L');

            // Montant payé et Reste à payer
            $this->SetFont('Helvetica', '', 10);
            $this->Cell(25, 5, utf8_decode('Montant payé : '), 0, 0, 'L');
            $this->SetFont('Helvetica', 'B', 10);
            $this->Cell(0, 5, $userinf['montPR'] . ' $', 0, 1, 'L');

            $this->SetFont('Helvetica', '', 10);
            $this->Cell(29, 5, utf8_decode('Montant à payer : '), 0, 0, 'L');
            $this->SetFont('Helvetica', 'B', 10);
            $this->Cell(0, 5, ($map) . ' $', 0, 1, 'L');

            $this->SetFont('Helvetica', '', 10);
            $this->Cell(33, 5, utf8_decode('Montant deja payer : '), 0, 0, 'L');
            $this->SetFont('Helvetica', 'B', 10);
            $this->Cell(0, 5, ($montantDejaPaye) . ' $', 0, 1, 'L');

            $this->SetFont('Helvetica', '', 10);
            $this->Cell(26, 5, utf8_decode('Reste à payer : '), 0, 0, 'L');
            $this->SetFont('Helvetica', 'B', 10);
            $this->Cell(0, 5, ($resteAPayer) . ' $', 0, 1, 'L');

            // Pied de page
            $this->Ln(1);
            $this->SetFont('Arial', 'I', 9);
            $this->Cell(0, 3, utf8_decode('Fait à Kananga le ') . date('d-m-Y'), 0, 1, 'R');
            $this->Cell(0, 3, utf8_decode('Imprimé par ') . $userinf['nomUser'], 0, 1, 'R');
        }
    }
}

$formatname = "recuredevable-" . date('dmYhis');
$pdf = new myPDF('p', 'mm', array(100, 107));
$pdf->AliasNbPages();
$pdf->Table($pdo);
$pdf->Output('../uploads/pdf/' . $formatname . '.pdf', 'F');

header('Location: ' . $urlopen . $formatname . '.pdf');
exit;
?>
