<?php
session_start();
require_once('../include/html2pdf/vendor/autoload.php');
require_once("../include/connexiondb.php");

// Requete print

$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$ResultmaxAS = $resPgrh['idAn'];

$idUser = $_SESSION['id'];

//Parcourir la table des frais

$frais=$pdo->query("SELECT");

// Calcul du solde de report
$requeteRecettesReport = "
    SELECT SUM(t_frais.montF) AS totalRecettesReport
    FROM t_frais
    WHERE t_frais.idUser = '$idUser' AND t_frais.dateF BETWEEN '$dateExercice' AND DATE_SUB('$date1', INTERVAL 1 DAY)
";
$resRecettesReport = $pdo->query($requeteRecettesReport)->fetch();
$totalRecettesReport = $resRecettesReport['totalRecettesReport'];

// Repport des autres entrées
$autreEntreRepport = "
    SELECT SUM(e.montantE) AS totEntree 
    FROM autreEntre as e 
    WHERE e.idUser='$idUser' AND e.dateEntre BETWEEN '$dateExercice' AND DATE_SUB('$date1', INTERVAL 1 DAY)
";
$resEntreReport = $pdo->query($autreEntreRepport)->fetch();
$totalEntreReport = $resEntreReport['totEntree'];

$requeteDepensesReport = "
    SELECT SUM(depense.tarif) AS totalDepensesReport
    FROM depense
    WHERE depense.idUser = '$idUser' AND depense.dateDep BETWEEN '$dateExercice' AND DATE_SUB('$date1', INTERVAL 1 DAY)
";

$requetePaiementsMensuelsReport = "
    SELECT SUM(p.montantPaie) AS totalPaiementsMensuelsReport
    FROM paiementmensuel AS p
    WHERE p.idUser = '$idUser' AND p.datePaiement BETWEEN '$dateExercice' AND DATE_SUB('$date1', INTERVAL 1 DAY)
";
$resPaiementsMensuelsReport = $pdo->query($requetePaiementsMensuelsReport)->fetch();
$totalPaiementsMensuelsReport = $resPaiementsMensuelsReport['totalPaiementsMensuelsReport'];


$resDepensesReport = $pdo->query($requeteDepensesReport)->fetch();
$totalDepensesReport = $resDepensesReport['totalDepensesReport'];

// Repport des autres sorties
$requeteSortieReport = "
    SELECT SUM(s.montantSE) AS totSortie
    FROM autreSortie as s
    WHERE s.idUser = '$idUser' AND s.dateSortieE BETWEEN '$dateExercice' AND DATE_SUB('$date1', INTERVAL 1 DAY)
";
$resSortieReport = $pdo->query($requeteSortieReport)->fetch();
$totalSortieReport = $resSortieReport['totSortie'];

$soldeReport = ($totalRecettesReport + $totalEntreReport+ $totalPaiementsMensuelsReport) - ($totalDepensesReport + $totalSortieReport);

// Requête pour les recettes (paiements des élèves) pendant la période sélectionnée
$requeteRecettes = "
    SELECT t_frais.*, t_inscrit.nom, t_classe.design, t_option.designO, t_classe.ord, t_typeFrais.designTF, t_typeFrais.catTF 
    FROM t_frais 
    INNER JOIN t_inscrit ON t_frais.idI = t_inscrit.idI 
    INNER JOIN t_typeFrais ON t_typeFrais.idTF = t_frais.idTF
    INNER JOIN t_classe ON t_classe.idC = t_inscrit.idC
    INNER JOIN t_option ON t_classe.idO = t_option.idO
    WHERE t_frais.idUser = '$idUser' AND t_frais.dateF BETWEEN '$date1' AND '$date2'
";
$rowCountRecettes = $pdo->query($requeteRecettes)->rowCount();

// Requête pour le total des recettes
$requeteTotalRecettes = "
    SELECT SUM(t_frais.montF) AS totalRecettes 
    FROM t_frais 
    WHERE t_frais.idUser = '$idUser' AND t_frais.dateF BETWEEN '$date1' AND '$date2'
";
$resTotalRecettes = $pdo->query($requeteTotalRecettes)->fetch();
$totalRecettes = $resTotalRecettes['totalRecettes'];

// Les autres entrées
$requeteEntree = "
    SELECT * 
    FROM autreEntre as e 
    WHERE e.idUser = '$idUser' AND e.dateEntre BETWEEN '$date1' AND '$date2'
";
$rstotEntre = $pdo->query("
    SELECT SUM(e.montantE) as totEntre 
    FROM autreEntre as e 
    WHERE e.idUser = '$idUser' AND e.dateEntre BETWEEN '$date1' AND '$date2'
")->fetch();
$totEntre = $rstotEntre['totEntre'];

// Requête pour les dépenses pendant la période sélectionnée
$requeteDepenses = "
    SELECT * 
    FROM depense 
    WHERE depense.idUser = '$idUser' AND depense.dateDep BETWEEN '$date1' AND '$date2'
";
$rowCountDepenses = $pdo->query($requeteDepenses)->rowCount();

// Requête pour le total des dépenses
$requeteTotalDepenses = "
    SELECT SUM(depense.tarif) AS totalDepenses 
    FROM depense 
    WHERE depense.idUser = '$idUser' AND depense.dateDep BETWEEN '$date1' AND '$date2'
";
$resTotalDepenses = $pdo->query($requeteTotalDepenses)->fetch();
$totalDepenses = $resTotalDepenses['totalDepenses'];

// Les autres sorties
$requeteSortie = "
    SELECT * 
    FROM autreSortie as s 
    WHERE s.idUser = '$idUser' AND s.dateSortieE BETWEEN '$date1' AND '$date2'
";
$rstotSortie = $pdo->query("
    SELECT SUM(e.montantSE) as totSortie 
    FROM autreSortie as e 
    WHERE e.idUser = '$idUser' AND e.dateSortieE BETWEEN '$date1' AND '$date2'
")->fetch();
$totSortie = $rstotSortie['totSortie'];

$requetePaiementsMensuels = "
    SELECT p.*, e.nom, cl.design, opt.designO, cl.ord, f.designationFrais
    FROM paiementmensuel AS p
    INNER JOIN t_inscrit AS e ON p.idEleve = e.idI
    INNER JOIN t_classe AS cl ON e.idC = cl.idC
    INNER JOIN t_option AS opt ON cl.idO = opt.idO
    INNER JOIN fraismensuel AS f ON p.idFrais = f.idFraisM
    WHERE p.idUser = '$idUser' AND p.datePaiement BETWEEN '$date1' AND '$date2'
";
$rowCountPaiementsMensuels = $pdo->query($requetePaiementsMensuels)->rowCount();

$requeteTotalPaiementsMensuels = "
    SELECT SUM(p.montantPaie) AS totalPaiementsMensuels
    FROM paiementmensuel AS p
    WHERE p.idUser = '$idUser' AND p.datePaiement BETWEEN '$date1' AND '$date2'
";
$resTotalPaiementsMensuels = $pdo->query($requeteTotalPaiementsMensuels)->fetch();
$totalPaiementsMensuels = $resTotalPaiementsMensuels['totalPaiementsMensuels'];




// Calcul du solde final
$soldeFinal = $soldeReport + ($totalRecettes + $totEntre+$totalPaiementsMensuels) - ($totalDepenses + $totSortie);

// HTML pour le rapport
$html = '
<!DOCTYPE html>
<html>
<head>
    <meta charset="UTF-8">
    <title>Résumé de la caisse</title>
    <style>
        body {
            font-family: Arial, sans-serif;
            font-size: 12px;
        }
        h1 {
            font-size: 16px;
            font-weight: bold;
        }
        h2 {
            font-size: 12px;
            font-weight: bold;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            margin-bottom: 10px;
        }
        table, th, td {
            border: 1px solid black;
        }
        th, td {
            padding: 5px;
        }
        img{
            float:left;
        }
        
        .footer {
            font-size: 12px;
            margin-top: 20px;
            text-align: right;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="header">
            <img src="../uploads/logo.png" alt="Logo" width="60" height="70"/>
            <p>REPUBLIQUE DEMOCRATIQUE DU CONGO <br> MINISTERE DE L\'ENSEIGNEMENT PRIMAIRE, SECONDAIRE ET TECHNIQUE <br>COMPLEXE SCOLAIRE LA FONTAINE</p>
            <hr/>
        </div>
        <div class="content">
            <h1 style="text-align:center">RÉSUMÉ DE CAISSE DU '. date('d-m-Y', strtotime($date1)) . ' au '. date('d-m-Y', strtotime($date2)) . '</h1>
            <h2>Solde de report au '. date('d-m-Y', strtotime('-1 day', strtotime($date1))) . ' : ' . number_format($soldeReport, 2, '.', ' ') . ' $</h2>

            <h2>I. RECETTES</h2>
            <table>
                <thead>
                    <tr>
                        <th style="width: 5%">N°</th>
                        <th style="width: 25%">ÉLÈVE / DEPOSITEUR</th>
                        <th style="width: 20%">CLASSE</th>
                        <th style="width: 26%">MOTIF</th>
                        <th style="width: 12%">MONTANT</th>
                        <th style="width: 12%">DATE</th>
                    </tr>
                </thead>
                <tbody>';
                
$resultat = $pdo->query($requeteRecettes);
$i = 1;
while ($ins = $resultat->fetch()) {
    $html .= '
                    <tr>
                        <td style="width: 5%">'. $i++ .'</td>
                        <td style="width: 25%">'. htmlspecialchars($ins['nom']) .'</td>
                        <td style="width: 20%">'. htmlspecialchars($ins['design'] . ' ' . $ins['designO'] . ' ' . $ins['ord']) .'</td>
                        <td style="width: 26%">'. htmlspecialchars($ins['designTF']) .'</td>
                        <td style="width: 12%">'. number_format($ins['montF'], 2, '.', ' ') .' $</td>
                        <td style="width: 12%">'. date('d-m-Y', strtotime($ins['dateF'])) .'</td>
                    </tr>';
}

$html .= '
                </tbody>
            </table>
            <h2 style="background-color:blue;color:white;">Total des recettes: ' . number_format($totalRecettes, 2, '.', ' ') . ' $</h2>
            
            <h2>II. PAIEMENTS MENSUELS</h2>

            <table>
                <thead>
                    <tr>
                        <th style="width: 5%">N°</th>
                        <th style="width: 25%">ÉLÈVE</th>
                        <th style="width: 20%">CLASSE</th>
                        <th style="width: 10%">MOIS</th>
                        <th style="width: 20%">FRAIS</th>
                        <th style="width: 10%">MONTANT</th>
                        <th style="width: 10%">DATE</th>
                    </tr>
                </thead>
                <tbody>';
                $resultatPaiementsMensuels = $pdo->query($requetePaiementsMensuels);
                $i = 1;
                while ($paiement = $resultatPaiementsMensuels->fetch()) {
                    $html .= '
                        <tr>
                            <td style="width: 5%">' . $i++ . '</td>
                            <td style="width: 25%">' . htmlspecialchars($paiement['nom']) . '</td>
                            <td style="width: 20%">' . htmlspecialchars($paiement['design'] . ' ' . $paiement['designO'] . ' ' . $paiement['ord']) . '</td>
                            <td style="width: 10%">' . htmlspecialchars($paiement['moisPaie']) . '</td>
                            <td style="width: 20%">' . htmlspecialchars($paiement['designationFrais']) . '</td>
                            <td style="width: 10%">' . number_format($paiement['montantPaie'], 2, '.', ' ') . ' $</td>
                            <td style="width: 10%">' . date('d-m-Y', strtotime($paiement['datePaiement'])) . '</td>
                        </tr>';
                }

           $html .= ' 
           </tbody>
            </table>
            <h2 style="background-color:blue;color:white;">Total des Paiements mensuels: ' . number_format($totalPaiementsMensuels, 2, '.', ' ') . ' $</h2>
           
           <h2>III. AUTRES ENTRÉES</h2>
            <table>
                <thead>
                    <tr>
                        <th style="width: 5%">N°</th>
                        <th style="width: 25%">MOTIF</th>
                        <th style="width: 20%">DEPOSITEUR</th>
                        <th style="width: 12%">MONTANT</th>
                        <th style="width: 12%">DATE</th>
                    </tr>
                </thead>
                <tbody>';

$resultatEntre = $pdo->query($requeteEntree);
$i = 1;
while ($entre = $resultatEntre->fetch()) {
    $html .= '
                    <tr>
                        <td style="width: 5%">'. $i++ .'</td>
                        <td style="width: 25%">'. htmlspecialchars($entre['motifEntre']) .'</td>
                        <td style="width: 20%">'. htmlspecialchars($entre['source']) .'</td>
                        <td style="width: 12%">'. number_format($entre['montantE'], 2, '.', ' ') .' $</td>
                        <td style="width: 12%">'. date('d-m-Y', strtotime($entre['dateEntre'])) .'</td>
                    </tr>';
}

$html .= '
                </tbody>
            </table>
            <h2 style="background-color:blue;color:white;">Total des autres entrées: ' . number_format($totEntre, 2, '.', ' ') . ' $</h2>

            <h2>IV. DÉPENSES</h2>
            <table>
                <thead>
                    <tr>
                        <th style="width: 5%">N°</th>
                        <th style="width: 25%">MOTIF</th>
                        <th style="width: 20%">BÉNÉFICIAIRE</th>
                        <th style="width: 12%">MONTANT</th>
                        <th style="width: 12%">DATE</th>
                    </tr>
                </thead>
                <tbody>';

$resultatDepenses = $pdo->query($requeteDepenses);
$i = 1;
while ($dep = $resultatDepenses->fetch()) {
    $html .= '
                    <tr>
                        <td style="width: 5%">'. $i++ .'</td>
                        <td style="width: 25%">'. htmlspecialchars($dep['motif']) .'</td>
                        <td style="width: 20%">'. htmlspecialchars($dep['beneficiaire']) .'</td>
                        <td style="width: 12%">'. number_format($dep['tarif'], 2, '.', ' ') .' $</td>
                        <td style="width: 12%">'. date('d-m-Y', strtotime($dep['dateDep'])) .'</td>
                    </tr>';
}

$html .= '
                </tbody>
            </table>
            <h2 style="background-color:blue;color:white;">Total des dépenses: ' . number_format($totalDepenses, 2, '.', ' ') . ' $</h2>

            <h2>V. AUTRES SORTIES</h2>
            <table>
                <thead>
                    <tr>
                        <th style="width: 5%">N°</th>
                        <th style="width: 25%">MOTIF</th>
                        <th style="width: 20%">BÉNÉFICIAIRE</th>
                        <th style="width: 12%">MONTANT</th>
                        <th style="width: 12%">DATE</th>
                    </tr>
                </thead>
                <tbody>';

$resultatSortie = $pdo->query($requeteSortie);
$i = 1;
while ($sortie = $resultatSortie->fetch()) {
    $html .= '
                    <tr>
                        <td style="width: 5%">'. $i++ .'</td>
                        <td style="width: 25%">'. htmlspecialchars($sortie['motifSortieE']) .'</td>
                        <td style="width: 20%">'. htmlspecialchars($sortie['beneficiaireSE']) .'</td>
                        <td style="width: 12%">'. number_format($sortie['montantSE'], 2, '.', ' ') .' $</td>
                        <td style="width: 12%">'. date('d-m-Y', strtotime($sortie['dateSortieE'])) .'</td>
                    </tr>';
}

$html .= '
                </tbody>
            </table>
            <h2 style="background-color:blue;color:white;">Total des autres sorties: ' . number_format($totSortie, 2, '.', ' ') . ' $</h2>
            <hr>
                <h2 >TOTAL DES ENTREES: ' . number_format(($totalRecettes + $totEntre+$totalPaiementsMensuels), 2, '.', ' ') . ' $</h2>
                <h2 >TOTAL DES SORTIES: ' . number_format(($totalDepenses + $totSortie), 2, '.', ' ') . ' $</h2>
            <hr>
            <h2 style="background-color:blue;color:white; padding:20px;">SOLDE FINAL: ' . number_format($soldeFinal, 2, '.', ' ') . ' $</h2>
        </div>
    </div>
    <div class="footer">
        <p>Fait à Kananga, le '. date('d-m-Y') .'</p>
    </div>
</body>
</html>';

// Créer l'objet HTML2PDF
use Spipu\Html2Pdf\Html2Pdf;

// Set the margins: (left, top, right, bottom)
$leftMargin = 10;
$topMargin = 15;
$rightMargin = 10;
$bottomMargin = 15;


// Your HTML content

try {
    //$html2pdf = new Html2Pdf();
     $html2pdf = new Html2Pdf('P', 'A4', 'fr', true, 'UTF-8', array($leftMargin, $topMargin, $rightMargin, $bottomMargin));
    $html2pdf->writeHTML($html);

    // Display the PDF directly in the browser
    $html2pdf->output('rapportCaisse.pdf', 'I'); // 'I' stands for inline display

} catch (Exception $e) {
    echo 'Error: ' . $e->getMessage();
}
   
?>
