<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php"); 

//Requete année
$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$ResultmaxAS = $resPgrh['idAn'];

$requeteUser="SELECT * FROM lignedepense
INNER JOIN t_an ON lignedepense.idA=t_an.idA
WHERE t_an.idA='$ResultmaxAS'
ORDER BY lignedepense.designLd ASC";

$rowCountRequete = $pdo->query($requeteUser)->rowCount();
if($rowCountRequete===0){
    #Message d'ERREUR
    $msg_erreur = "Il n'y a pas d'informations à renvoyer sur ce rapport";
    header("Location:../FIN/ld.php?erreur=$msg_erreur");
    exit;
}else{
    $res=$pdo->query($requeteUser)->fetch();

    $requeteSomme2="SELECT SUM(tarifLd) AS sommeFac2 
    FROM lignedepense INNER JOIN t_an ON lignedepense.idA=t_an.idA 
    WHERE t_an.idA='$ResultmaxAS'";
    $resSomme2=$pdo->query($requeteSomme2)->fetch();
    $sommeFacture2 = $resSomme2['sommeFac2'];

    $requeteSomme="SELECT SUM(tarif) AS sommeFac FROM depense 
    INNER JOIN lignedepense ON lignedepense.idLd=depense.idLd
    INNER JOIN t_an ON lignedepense.idA=t_an.idA 
    WHERE t_an.idA='$ResultmaxAS'";
    $resSomme=$pdo->query($requeteSomme)->fetch();
    $sommeFacture = $resSomme['sommeFac'];

    $rowMedicament = $pdo->query($requeteUser)->rowCount();
    $numFac = sprintf('%04d', $rowMedicament);

    $image1 = "../uploads/logo.png";
    $pdf=new FPDF();
    $pdf->AddPage('L');
    $pdf->Image($image1, 5, $pdf->GetY(), 36.78);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,20,"REPUBLIQUE DEMOCRATIQUE DU CONGO",0,0,'C');
    $pdf->Ln(15);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,"MINISTERE DE L'ENSEIGNEMENT PRIMAIRE,",0,0,'C');
    $pdf->Ln(7);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,"SECONDAIRE ET TECHNIQUE",0,0,'C');
    $pdf->Ln(6);
    $pdf->setFont('courier','',15);
    $pdf->cell(0,4,"COMPLEXE SCOLAIRE LA RECONNAISSANCE",0,0,'C');
    $pdf->Ln(10);
    $pdf->SetTextColor(0,0,0);
    $pdf->setFont('courier','B',12);
    $pdf->Cell(130 ,5,"RAPPORT DE SUIVI BUDGETAIRE",0,0);

    //set font to arial, regular, 12pt
    $pdf->SetFont('Arial','',10);

    $pdf->Cell(59 ,5,'',0,1);//end of line
    $pdf->Ln(5);
    $pdf->Cell(130 ,5,utf8_decode('Ligne des dépenses : ').$numFac,0,0);
    $pdf->Cell(25 ,5,'',0,0);
    $pdf->Cell(34 ,5,'',0,1);//end of line

    $pdf->Cell(130 ,5,utf8_decode('Année Scolaire : ').strtoupper($res['designA']),0,0);
    $pdf->Cell(25 ,5,'',0,0);
    $pdf->Cell(34 ,5,'',0,1);//end of line

    $pdf->Ln(5);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(10,7,utf8_decode('N°'),1,0,'C');
    $pdf->cell(90,7,'LIGNE DE DEPENSES',1,0,'C');
    $pdf->cell(40,7,'MONTANT PREVU',1,0,'C');
    $pdf->cell(40,7,'MONTANT DEPENSE',1,0,'C');
    $pdf->cell(50,7,'ECART REALISE',1,0,'C');
    $pdf->cell(50,7,'POURCENTAGE ACCUMULE',1,0,'C');
    $pdf->Ln(7);

    $pdf->setFont('courier','',9);

        $i=1;
        $resultat=$pdo->query($requeteUser);
            while ($ins=$resultat->fetch()) { 
                $idLd = $ins['idLd'];
                $requeteSuivi="SELECT SUM(tarif) AS depMont FROM depense 
                INNER JOIN users ON users.idUser=depense.idUser
                INNER JOIN lignedepense ON lignedepense.idLd=depense.idLd
                INNER JOIN t_an ON lignedepense.idA=t_an.idA WHERE depense.idLd='$idLd'";
                $rstSuivi = $pdo->query($requeteSuivi)->fetch();

                $pdf->cell(10,7, $i++,1,0,'C');
                $pdf->cell(90,7, utf8_decode($ins['designLd']),1);
                $pdf->cell(40,7, utf8_decode(number_format($ins['tarifLd'],2,'.',' ').' $'),1,0,'R');
                $pdf->cell(40,7, utf8_decode(number_format($rstSuivi['depMont'],2,'.',' ').' $'),1,0,'R');
                $pdf->cell(50,7, utf8_decode(number_format($ins['tarifLd']-$rstSuivi['depMont'],2,'.',' ').' $'),1,0,'R');
                $pdf->cell(50,7, utf8_decode(round(($rstSuivi['depMont'] / $ins['tarifLd']) * 100, 2).' %'),1,0,'R');
                $pdf->Ln(7);
        }

    $pdf->setFont('Arial','',9);
    $pdf->cell(180,7,'',0);
    $pdf->cell(50,7,"PREVISION BUGETAIRE",1);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(50,7,number_format($sommeFacture2,2,'.',' ').' $',1,0,'R');
    $pdf->Ln(7);
    $pdf->cell(180,7,'',0);
    $pdf->setFont('Arial','',9);
    $pdf->cell(50,7,"DEPENSES REALISEES",1);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(50,7,number_format($sommeFacture,2,'.',' ').' $',1,0,'R');
    $pdf->Ln(7);
    $pdf->cell(180,7,'',0);
    $pdf->setFont('Arial','',9);
    $pdf->cell(50,7,"ECART GLOBAL",1);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(50,7,number_format($sommeFacture2-$sommeFacture,2,'.',' ').' $',1,0,'R');
    $pdf->Ln(7);
    $pdf->cell(180,7,'',0);
    $pdf->setFont('Arial','',9);
    $pdf->cell(50,7,"POURCENTAGES ACCUMULES",1);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(50,7,round(($sommeFacture / $sommeFacture2) * 100, 2).' %',1,0,'R');
    $pdf->Ln(7);
    $pdf->setFont('Arial','I',9);
    //Décalage à droite
    $pdf->Cell(217);
    //Numéro de page
    $pdf->Cell(0,10,utf8_decode('Fait à Kananga Le ').date('d-m-Y A h:i:s A').' ',0,0,'C');
    
    $formatname = "rapport-" . date('dmYhis');
    $pdf->Output('../uploads/pdf/' . $formatname . '.pdf', 'F');

    header('Location: ' . $urlopen . $formatname . '.pdf');
    exit;
}
?>

