<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php"); 
date_default_timezone_set('Africa/Lubumbashi');

// Paramettre PRINT
$requeteParamPrint = "SELECT * FROM parprintmag WHERE idP";
$resultatPrint = $pdo->query($requeteParamPrint)->fetch();

// Requete print
$date1 = $_POST["date1"];
$date2 = $_POST["date2"];

$requeteUser = "SELECT * from commande 
    INNER JOIN users ON users.idUser = commande.idUser 
    INNER JOIN client ON client.idClient = commande.idClient
    INNER JOIN detail_commande ON commande.idC = detail_commande.idC
    INNER JOIN medicament ON detail_commande.idM = medicament.idM 
    INNER JOIN categorie ON medicament.idCat = categorie.idCat
    WHERE dateC BETWEEN '$date1' AND '$date2'
    ORDER BY categorie.designCat, medicament.design";
$rowCountRequete = $pdo->query($requeteUser)->rowCount();

if ($rowCountRequete === 0) {
    // Message d'ERREUR
    $msg_erreur = "Il n'y a pas d'informations à renvoyer sur ce rapport";
    header("Location:../Admin/ventes.php?erreur=$msg_erreur");
    exit;
} else {
    $requeteSomme = "SELECT SUM(prixV * qte) AS sommeFac FROM commande 
        INNER JOIN users ON users.idUser = commande.idUser 
        INNER JOIN client ON client.idClient = commande.idClient
        INNER JOIN detail_commande ON commande.idC = detail_commande.idC
        INNER JOIN medicament ON detail_commande.idM = medicament.idM 
        INNER JOIN categorie ON medicament.idCat = categorie.idCat
        WHERE dateC BETWEEN '$date1' AND '$date2'";
    $resSomme = $pdo->query($requeteSomme)->fetch();
    $sommeFacture = $resSomme['sommeFac'];

    $image1 = "../uploads/" . $resultatPrint['log'];

    $pdf = new FPDF();
    $pdf->AddPage();
    $pdf->Image($image1, 5, $pdf->GetY(), 36.78);
    $pdf->setFont('Arial', 'B', 15);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->cell(0, 20, $resultatPrint['soc'], 0, 0, 'C');
    $pdf->Ln(15);
    $pdf->setFont('courier', '', 15);
    $pdf->cell(0, 4, utf8_decode($resultatPrint['ad']), 0, 0, 'C');
    $pdf->Ln(7);
    $pdf->cell(0, 4, $resultatPrint['pays'], 0, 0, 'C');
    $pdf->Ln(6);
    $pdf->cell(0, 4, 'Contact : ' . $resultatPrint['con'], 0, 0, 'C');
    $pdf->Ln(6);
    $pdf->cell(0, 4, 'Email : ' . $resultatPrint['em'], 0, 0, 'C');
    $pdf->Ln(10);
    $pdf->setFont('courier', 'B', 14);
    $pdf->cell(0, 4, 'LISTE DE TOUS LES ARTICLES VENDUS', 0, 0, 'C');
    $pdf->Ln(6);
    $pdf->setFont('courier', 'B', 12);
    $pdf->cell(0, 4, 'ENTRE LE ' . date('d-m-Y', strtotime($date1)) . ' ET LE ' . date('d-m-Y', strtotime($date2)), 0, 0, 'C');
    $pdf->Ln(6);

    $pdf->setFont('Arial', 'U', 15);
    $pdf->cell(55, 8, '', 0);
    $pdf->SetX(3);

    $pdf->cell(5, 8, '', 0);
    $pdf->Ln(5);
    $pdf->setFont('Arial', 'B', 8);
    $pdf->cell(10, 7, utf8_decode('N°'), 1, 0, 'C');
    $pdf->cell(70, 7, 'ARTICLES', 1, 0, 'C');
    $pdf->cell(60, 7, 'CLIENT', 1, 0, 'C');
    $pdf->cell(15, 7, 'QT', 1, 0, 'C');
    $pdf->cell(20, 7, 'PV', 1, 0, 'C');
    $pdf->cell(20, 7, 'PT', 1, 0, 'C');
    $pdf->Ln(7);

    $pdf->setFont('courier', '', 8);

    $i = 1;
    $resultat = $pdo->query($requeteUser);
    $currentCategory = null;
    $subtotal = 0;

    if (isset($_POST['date1']) && isset($_POST['date2'])) {
        while ($ins = $resultat->fetch()) { 
            if ($currentCategory !== $ins['designCat']) {
                // If it's not the first category, print the subtotal for the previous category
                if ($currentCategory !== null) {
                    $pdf->setFont('courier', 'B', 9);
                    $pdf->cell(175, 7, 'Sous Total : ', 1, 0, 'R');
                    $pdf->cell(20, 7, number_format($subtotal, 2, '.', ' '), 1, 0, 'R');
                    $pdf->Ln(7);
                    $subtotal = 0;
                }
                
                // Nouvelle catégorie, affichez un en-tête
                $pdf->SetFillColor(255, 255, 0); // Jaune
                $pdf->setFont('courier', 'B', 10);
                $pdf->cell(195, 6, utf8_decode(strtoupper($ins['designCat'])), 1, 1, 'C', true);
                $pdf->SetFillColor(255, 255, 255);
                $currentCategory = $ins['designCat'];
            }
            $pdf->setFont('courier', 'B', 9);
            
            $pdf->cell(10, 7, $i++, 1, 0, 'L');
            $pdf->cell(70, 7, utf8_decode(substr($ins['design'], 0, 23)), 1, 0, 'L');
            $pdf->cell(60, 7, utf8_decode(substr($ins['nom'], 0, 22)), 1, 0, 'L');
            $pdf->cell(15, 7, utf8_decode(number_format($ins['qte'], 2, '.', ' ')), 1, 0, 'R');
            $pdf->cell(20, 7, utf8_decode(number_format($ins['prixV'], 2, '.', ' ')), 1, 0, 'R');
            $pdf->cell(20, 7, utf8_decode(number_format($ins['prixV'] * $ins['qte'], 2, '.', ' ')), 1, 0, 'R');
            $pdf->Ln(7);
            $subtotal += $ins['prixV'] * $ins['qte'];
        }

        // Print the last category subtotal
        if ($currentCategory !== null) {
            $pdf->setFont('courier', 'B', 9);
            $pdf->cell(175, 7, 'Sous Total : ', 1, 0, 'R');
            $pdf->cell(20, 7, number_format($subtotal, 2, '.', ' '), 1, 0, 'R');
            $pdf->Ln(7);
        }
    }

    $pdf->setFont('courier', 'B', 9);
    $pdf->cell(130, 7, '', 0);
    $pdf->cell(30, 7, 'TOTAL', 1);
    $pdf->cell(35, 7, number_format($sommeFacture, 2, '.', ' ') . ' FC', 1, 0, 'R');
    $pdf->Ln(7);

    $pdf->setFont('Arial', 'I', 9);
    // Décalage à droite
    $pdf->Cell(125);
    // Numéro de page
    $pdf->Cell(0, 10, utf8_decode('Fait à ' . $resultatPrint['vil']) . ' Le ' . date('d-m-Y H:i:s') . ' ', 0, 0, 'C');
    $pdf->Ln(15);

    

    $formatname = "rapport-" . date('dmYhis');
    $uploadRep = "../uploads/pdfs/";
    $pdf->Output($uploadRep . $formatname . '.pdf', 'F');
    header('Location:' . $uploadRep . $formatname . '.pdf');
    exit;
}
?>
