<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php");
require_once("../include/fonctionPrint.php");

//Requete print
$idC = $_SESSION['idC'];
$perConcern=$_SESSION['perConcern'];
//Periode
$aff = "";
if ($perConcern == "P1") {
    $aff = "Première Période";
} elseif ($perConcern == "P2") {
    $aff = "Deuxième Période";
} elseif ($perConcern == "P3") {
    $aff = "Troisième Période";
} elseif ($perConcern == "P4") {
    $aff = "Quatrième Période";
} elseif ($perConcern == "P5") {
    $aff = "Cinquième Période";
} elseif ($perConcern == "P6") {
    $aff = "Sixième Période";
}elseif ($perConcern == "S1") {
    $aff = "Premier Trimestre";
}elseif ($perConcern == "S2") {
    $aff = "Deuxième Trimestre";
}elseif ($perConcern == "S3") {
    $aff = "Troisième Trimestre";
} elseif ($perConcern == "Fin") {
    $aff = "Fin d'année";
} else {
    $aff = "Période non reconnue";
}
//Requetes pour les info de base
$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$ResultmaxAS = $resPgrh['idAn'];

$requestMaxAs = "SELECT * FROM t_an WHERE idA='$ResultmaxAS'";
$setMaxAs = $pdo->query($requestMaxAs)->fetch();
$annee = $setMaxAs['idA'];
$desan = $setMaxAs['designA'];

$rqt = "SELECT *
FROM t_classe INNER JOIN t_option ON t_classe.idO = t_option.idO
WHERE t_classe.idC = '$idC'";
$setClasse = $pdo->query($rqt)->fetch();
$classeEl = $setClasse['design'] . ' ' . $setClasse['designO'] . ' ' . $setClasse['ord'];

$requeteInscrit = "SELECT * FROM t_inscrit
WHERE idC = '$idC' AND idA = '$annee'";
$stmIns = $pdo->query($requeteInscrit);

$requeteTotIns = "SELECT COUNT(*) AS countIns FROM t_inscrit
WHERE idC = '$idC' AND idA = '$annee'";
$resultatTotIns = $pdo->query($requeteTotIns)->fetch();
$totIns = $resultatTotIns['countIns'];

//Garcons
$reqGarcons = "SELECT COUNT(*) AS countIns FROM t_inscrit
               WHERE idC = '$idC' AND idA = '$annee' AND (sexe = 'Masculin' OR sexe = 'M')";
$resGarcons = $pdo->query($reqGarcons)->fetch();
$totInsGarcons = $resGarcons['countIns'];

//Fille
$reqFille = "SELECT COUNT(*) AS countIns FROM t_inscrit
WHERE idC = '$idC' AND idA = '$annee' AND (sexe = 'Feminin' OR sexe = 'F')";
$resFille = $pdo->query($reqFille)->fetch();
$totInsFille = $resFille['countIns'];

$requeteClasse = "SELECT * FROM t_classe WHERE idC = '$idC'";
$resultatClasse = $pdo->query($requeteClasse)->fetch();
$sectionClasse = $resultatClasse['sec'];

$i = 1;

//Design BN
$image1 = "../uploads/logo.png";

$pdf = new FPDF();
$pdf->AddPage();
$pdf->Image($image1, 5, $pdf->GetY(), 36.78);
$pdf->setFont('courier', '', 15);
$pdf->SetTextColor(0, 0, 0);
$pdf->cell(0, 20, "REPUBLIQUE DEMOCRATIQUE DU CONGO", 0, 0, 'C');
$pdf->Ln(15);
$pdf->setFont('courier', '', 15);
$pdf->SetTextColor(0, 0, 0);
$pdf->cell(0, 4, "MINISTERE DE L'ENSEIGNEMENT PRIMAIRE,", 0, 0, 'C');
$pdf->Ln(7);
$pdf->SetTextColor(0, 0, 0);
$pdf->cell(0, 4, "SECONDAIRE ET TECHNIQUE", 0, 0, 'C');
$pdf->Ln(6);
$pdf->setFont('courier', '', 15);
$pdf->cell(0, 4, "COMPLEXE SCOLAIRE LA RECONNAISSANCE", 0, 0, 'C');
$pdf->Ln(10);
$pdf->SetTextColor(0, 0, 0);
$pdf->setFont('courier', 'B', 15);
$pdf->Cell(0, 5, 'PROCES VERBAL DE DELIBERATION ', 0, 0, 'L');
$pdf->SetFont('Arial', '', 10);
$pdf->Ln(5);
$pdf->Cell(130, 5, utf8_decode('Nombre des élèves : ' . $totIns), 0, 0);
$pdf->Ln(5);
$pdf->Cell(130, 5, utf8_decode('Nombre des garçons : ' . $totInsGarcons), 0, 0);
$pdf->Ln(5);
$pdf->Cell(130, 5, utf8_decode('Nombre des filles : ' . $totInsFille), 0, 0);
$pdf->Ln(5);
$pdf->Cell(130, 5, utf8_decode('Période : ' . mb_strtoupper($aff, 'UTF-8')), 0, 0);
$pdf->Ln(5);
$pdf->Cell(130, 5, utf8_decode('Classe : ' . mb_strtoupper($classeEl, 'UTF-8')), 0, 0);
$pdf->Ln(5);
$pdf->Cell(130, 5, utf8_decode('Année scolaire : ' . $desan), 0, 0);
$pdf->Ln(7);
$pdf->setFont('Arial','B',10);
$pdf->cell(10,5,utf8_decode('N°'),1,0,'C');
$pdf->cell(90,5,'ELEVE',1,0,'C');
$pdf->cell(35,5,'MATRICULE',1,0,'C');
$pdf->cell(15,5,'SEXE',1,0,'C');
$pdf->cell(23,5,'%',1,0,'C');
$pdf->cell(23,5,'PLACE',1,0,'C');
$pdf->Ln(5);

if ($sectionClasse == 'Maternelle') {
    $pdf->setFont('Helvetica','',10);
    while ($ins = $stmIns->fetch()){
        //Pourcentage
        $idI = $ins['idI'];
        if ($perConcern == "P1") {
            $totalCote = getTotCotePerMat($pdo,$idI,$annee,$perConcern);
            $totalMaxPer = getTotCoteMaxMat($pdo,$idI,$annee);
            $pourc = $totalCote==NULL ? '' : round(($totalCote / $totalMaxPer) * 100, 2);
            $place = $totalCote==NULL ? '' : getPlaceEleveMatPer($pdo, $idI, $annee, 'P1', $idC);
        } elseif ($perConcern == "P2") {
            $totalCote = getTotCotePerMat($pdo,$idI,$annee,$perConcern);
            $totalMaxPer = getTotCoteMaxMat($pdo,$idI,$annee);
            $pourc = $totalCote==NULL ? '' : round(($totalCote / $totalMaxPer) * 100, 2);
            $place = $totalCote==NULL ? '' : getPlaceEleveMatPer($pdo, $idI, $annee, 'P2', $idC);
        } elseif ($perConcern == "P3") {
            $totalCote = getTotCotePerMat($pdo,$idI,$annee,$perConcern);
            $totalMaxPer = getTotCoteMaxMat($pdo,$idI,$annee);
            $pourc = $totalCote==NULL ? '' : round(($totalCote / $totalMaxPer) * 100, 2);
            $place = $totalCote==NULL ? '' : getPlaceEleveMatPer($pdo, $idI, $annee, 'P3', $idC);
        }elseif ($perConcern == "Fin") {
            $totalCote1 = getTotCotePerMat($pdo,$idI,$annee,'P1');
            $totalCote2 = getTotCotePerMat($pdo,$idI,$annee,'P2');
            $totalCote3 = getTotCotePerMat($pdo,$idI,$annee,'P3');
            $totalMaxPer = getTotCoteMaxMat($pdo,$idI,$annee);
            $pourc = $totalCote1==NULL || $totalCote2==NULL || $totalCote3==NULL ? '' : round((($totalCote1+$totalCote2+$totalCote3)/($totalMaxPer*3)) * 100, 2);
            $place = $totalCote1==NULL || $totalCote2==NULL || $totalCote3==NULL ? '' : getPlaceEleveMatFin($pdo, $idI, $annee, $idC);
        }

        $pdf->cell(10,5,$i++,1,0,'C');
        $pdf->cell(90,5,utf8_decode($ins['nom']),1,0,'L');
        $pdf->cell(35,5,utf8_decode($ins['numMat']),1,0,'C');
        $pdf->cell(15,5,utf8_decode(strtoupper(substr($ins['sexe'], 0, 1))),1,0,'C');
        $pdf->cell(23,5,utf8_decode($pourc),1,0,'C');
        $pdf->cell(23,5,utf8_decode(($place === 1) ? "1er/" .$totIns : (($place > 1) ? $place . "è/" .$totIns : "")),1,0,'C');
        $pdf->Ln(5);
    }
} elseif ($sectionClasse == 'Primaire') {
    $pdf->setFont('Helvetica','',10);
    while ($ins = $stmIns->fetch()){
        //Pourcentage
        $idI = $ins['idI'];
        if ($perConcern == "P1") {
            $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
            $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
            $pourc = $totalCote==NULL ? '' : round(($totalCote / $totalMaxPer) * 100, 2);
            $place = $totalCote==NULL ? '' : getPlaceElevePriPer($pdo, $idI, $annee, 'P1', $idC);
        } elseif ($perConcern == "P2") {
            $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
            $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
            $pourc = $totalCote==NULL ? '' : round(($totalCote / $totalMaxPer) * 100, 2);
            $place = $totalCote==NULL ? '' : getPlaceElevePriPer($pdo, $idI, $annee, 'P2', $idC);
        } elseif ($perConcern == "P3") {
            $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
            $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
            $pourc = $totalCote==NULL ? '' : round(($totalCote / $totalMaxPer) * 100, 2);
            $place = $totalCote==NULL ? '' : getPlaceElevePriPer($pdo, $idI, $annee, 'P3', $idC);
        }elseif ($perConcern == "P4") {
            $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
            $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
            $pourc = $totalCote==NULL ? '' : round(($totalCote / $totalMaxPer) * 100, 2);
            $place = $totalCote==NULL ? '' : getPlaceElevePriPer($pdo, $idI, $annee, 'P4', $idC);
        }elseif ($perConcern == "P5") {
            $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
            $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
            $pourc = $totalCote==NULL ? '' : round(($totalCote / $totalMaxPer) * 100, 2);
            $place = $totalCote==NULL ? '' : getPlaceElevePriPer($pdo, $idI, $annee, 'P5', $idC);
        }elseif ($perConcern == "P6") {
            $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
            $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
            $pourc = $totalCote==NULL ? '' : round(($totalCote / $totalMaxPer) * 100, 2);
            $place = $totalCote==NULL ? '' : getPlaceElevePriPer($pdo, $idI, $annee, 'P6', $idC);
        }elseif ($perConcern == "S1") {
            $totalCote1 = getTotCotePerPri($pdo,$idI,$annee,'P1');
            $totalCote2 = getTotCotePerPri($pdo,$idI,$annee,'P2');
            $totalCote3 = getTotCotePerPri($pdo,$idI,$annee,'Ex1');
            $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
            $totalMaxEx = getTotExMaxPri($pdo,$idI,$annee);
            $pourc = $totalCote1 == NULL || $totalCote2 == NULL || $totalCote3 == NULL ? '' : round((($totalCote3+$totalCote2+$totalCote1)/($totalMaxPer*2+$totalMaxEx)) * 100, 2);
            $place = $totalCote1 == NULL || $totalCote2 == NULL || $totalCote3 == NULL ? '' : getPlaceElevePriTrim1($pdo, $idI, $annee, $idC);
        }elseif ($perConcern == "S2") {
            $totalCote1 = getTotCotePerPri($pdo,$idI,$annee,'P3');
            $totalCote2 = getTotCotePerPri($pdo,$idI,$annee,'P4');
            $totalCote3 = getTotCotePerPri($pdo,$idI,$annee,'Ex2');
            $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
            $totalMaxEx = getTotExMaxPri($pdo,$idI,$annee);
            $pourc = $totalCote1 == NULL || $totalCote2 == NULL || $totalCote3 == NULL ? '' : round((($totalCote3+$totalCote2+$totalCote1)/($totalMaxPer*2+$totalMaxEx)) * 100, 2);
            $place = $totalCote1 == NULL || $totalCote2 == NULL || $totalCote3 == NULL ? '' : getPlaceElevePriTrim2($pdo, $idI, $annee, $idC);
        }elseif ($perConcern == "S3") {
            $totalCote1 = getTotCotePerPri($pdo,$idI,$annee,'P5');
            $totalCote2 = getTotCotePerPri($pdo,$idI,$annee,'P6');
            $totalCote3 = getTotCotePerPri($pdo,$idI,$annee,'Ex3');
            $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
            $totalMaxEx = getTotExMaxPri($pdo,$idI,$annee);
            $pourc = $totalCote1 == NULL || $totalCote2 == NULL || $totalCote3 == NULL ? '' : round((($totalCote3+$totalCote2+$totalCote1)/($totalMaxPer*2+$totalMaxEx)) * 100, 2);
            $place = $totalCote1 == NULL || $totalCote2 == NULL || $totalCote3 == NULL ? '' : getPlaceElevePriTrim3($pdo, $idI, $annee, $idC);
        }elseif ($perConcern == "Fin") {
            $totalCote1 = getTotCotePerPri($pdo,$idI,$annee,'P1');
            $totalCote2 = getTotCotePerPri($pdo,$idI,$annee,'P2');
            $totalCote3 = getTotCotePerPri($pdo,$idI,$annee,'Ex1');
            $totalCote4 = getTotCotePerPri($pdo,$idI,$annee,'P3');
            $totalCote5 = getTotCotePerPri($pdo,$idI,$annee,'P4');
            $totalCote6 = getTotCotePerPri($pdo,$idI,$annee,'Ex2');
            $totalCote7 = getTotCotePerPri($pdo,$idI,$annee,'P5');
            $totalCote8 = getTotCotePerPri($pdo,$idI,$annee,'P6');
            $totalCote9 = getTotCotePerPri($pdo,$idI,$annee,'Ex3');
            $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
            $totalMaxEx = getTotExMaxPri($pdo,$idI,$annee);
            $pourc = $totalCote1==NULL || $totalCote2==NULL || $totalCote3==NULL || $totalCote4==NULL || $totalCote5==NULL || $totalCote6==NULL || $totalCote7==NULL || $totalCote8==NULL || $totalCote9==NULL ? '' : round((($totalCote1+$totalCote2+$totalCote3+$totalCote4+$totalCote5+$totalCote6+$totalCote7+$totalCote8+$totalCote9)/(($totalMaxPer*2+$totalMaxEx)*3)) * 100, 2);
            $place = $totalCote1==NULL || $totalCote2==NULL || $totalCote3==NULL || $totalCote4==NULL || $totalCote5==NULL || $totalCote6==NULL || $totalCote7==NULL || $totalCote8==NULL || $totalCote9==NULL ? '' : getPlaceElevePriFin($pdo, $idI, $annee, $idC);
        }

        $pdf->cell(10,5,$i++,1,0,'C');
        $pdf->cell(90,5,utf8_decode($ins['nom']),1,0,'L');
        $pdf->cell(35,5,utf8_decode($ins['numMat']),1,0,'C');
        $pdf->cell(15,5,utf8_decode(strtoupper(substr($ins['sexe'], 0, 1))),1,0,'C');
        $pdf->cell(23,5,utf8_decode($pourc),1,0,'C');
        $pdf->cell(23,5,utf8_decode(($place === 1) ? "1er/" .$totIns : (($place > 1) ? $place . "è/" .$totIns : "")),1,0,'C');
        $pdf->Ln(5);
    }
} elseif ($sectionClasse == 'Secondaire') {
    $pdf->setFont('Helvetica','',10);
    while ($ins = $stmIns->fetch()){
        //Pourcentage
        $idI = $ins['idI'];
        if ($perConcern == "P1") {
            $totalCote = getTotCotePerSec($pdo,$idI,$annee,$perConcern);
            $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
            $pourc = $totalCote==NULL ? '' : round(($totalCote / $totalMaxPer) * 100, 2);
            $place = $totalCote==NULL ? '' : getPlaceEleveSecPer($pdo, $idI, $annee, 'P1', $idC);
        } elseif ($perConcern == "P2") {
            $totalCote = getTotCotePerSec($pdo,$idI,$annee,$perConcern);
            $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
            $pourc = $totalCote==NULL ? '' : round(($totalCote / $totalMaxPer) * 100, 2);
            $place = $totalCote==NULL ? '' : getPlaceEleveSecPer($pdo, $idI, $annee, 'P2', $idC);
        } elseif ($perConcern == "P3") {
            $totalCote = getTotCotePerSec($pdo,$idI,$annee,$perConcern);
            $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
            $pourc = $totalCote==NULL ? '' : round(($totalCote / $totalMaxPer) * 100, 2);
            $place = $totalCote==NULL ? '' : getPlaceEleveSecPer($pdo, $idI, $annee, 'P3', $idC);
        }elseif ($perConcern == "P4") {
            $totalCote = getTotCotePerSec($pdo,$idI,$annee,$perConcern);
            $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
            $pourc = $totalCote==NULL ? '' : round(($totalCote / $totalMaxPer) * 100, 2);
            $place = $totalCote==NULL ? '' : getPlaceEleveSecPer($pdo, $idI, $annee, 'P4', $idC);
        }elseif ($perConcern == "S1") {
            $totalCote1 = getTotCotePerSec($pdo,$idI,$annee,'P1');
            $totalCote2 = getTotCotePerSec($pdo,$idI,$annee,'P2');
            $totalCote3 = getTotCotePerSec($pdo,$idI,$annee,'Ex1');
            $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
            $totalMaxEx = getTotExMaxSec($pdo,$idI,$annee);
            $pourc = $totalCote1 == NULL || $totalCote2 == NULL || $totalCote3 == NULL ? '' : round((($totalCote3+$totalCote2+$totalCote1)/($totalMaxPer*2+$totalMaxEx)) * 100, 2);
            $place = $totalCote1 == NULL || $totalCote2 == NULL || $totalCote3 == NULL ? '' : getPlaceEleveSecTrim1($pdo, $idI, $annee, $idC);
        }elseif ($perConcern == "S2") {
            $totalCote1 = getTotCotePerSec($pdo,$idI,$annee,'P3');
            $totalCote2 = getTotCotePerSec($pdo,$idI,$annee,'P4');
            $totalCote3 = getTotCotePerSec($pdo,$idI,$annee,'Ex2');
            $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
            $totalMaxEx = getTotExMaxSec($pdo,$idI,$annee);
            $pourc = $totalCote1 == NULL || $totalCote2 == NULL || $totalCote3 == NULL ? '' : round((($totalCote3+$totalCote2+$totalCote1)/($totalMaxPer*2+$totalMaxEx)) * 100, 2);
            $place = $totalCote1 == NULL || $totalCote2 == NULL || $totalCote3 == NULL ? '' : getPlaceEleveSecTrim2($pdo, $idI, $annee, $idC);
        }elseif ($perConcern == "Fin") {
            $totalCote1 = getTotCotePerSec($pdo,$idI,$annee,'P1');
            $totalCote2 = getTotCotePerSec($pdo,$idI,$annee,'P2');
            $totalCote3 = getTotCotePerSec($pdo,$idI,$annee,'Ex1');
            $totalCote4 = getTotCotePerSec($pdo,$idI,$annee,'P3');
            $totalCote5 = getTotCotePerSec($pdo,$idI,$annee,'P4');
            $totalCote6 = getTotCotePerSec($pdo,$idI,$annee,'Ex2');
            $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
            $totalMaxEx = getTotExMaxSec($pdo,$idI,$annee);
            $pourc = $totalCote1==NULL || $totalCote2==NULL || $totalCote3==NULL || $totalCote4==NULL || $totalCote5==NULL || $totalCote6==NULL ? '' : round((($totalCote1+$totalCote2+$totalCote3+$totalCote4+$totalCote5+$totalCote6)/(($totalMaxPer*2+$totalMaxEx)*2)) * 100, 2);
            $place = $totalCote1==NULL || $totalCote2==NULL || $totalCote3==NULL || $totalCote4==NULL || $totalCote5==NULL || $totalCote6==NULL ? '' : getPlaceEleveSecFin($pdo, $idI, $annee, $idC);
        }

        $pdf->cell(10,5,$i++,1,0,'C');
        $pdf->cell(90,5,utf8_decode($ins['nom']),1,0,'L');
        $pdf->cell(35,5,utf8_decode($ins['numMat']),1,0,'C');
        $pdf->cell(15,5,utf8_decode(strtoupper(substr($ins['sexe'], 0, 1))),1,0,'C');
        $pdf->cell(23,5,utf8_decode($pourc),1,0,'C');
        $pdf->cell(23,5,utf8_decode(($place === 1) ? "1er/" .$totIns : (($place > 1) ? $place . "è/" .$totIns : "")),1,0,'C');
        $pdf->Ln(5);
    }
} else {
    $pdf->cell(192, 5, utf8_decode("IL Y A UNE ERREUR"), 1, 0, 'C');
    $pdf->Ln(5);
}

//Footer
$pdf->setFont('Arial', 'I', 9);
$pdf->Cell(0, 10, utf8_decode('Sceau et Signature'), 0, 0, 'L');
$pdf->Cell(0, 10, utf8_decode(' Fait à Kananga Le ' . date('d-m-Y A h:i:s A')), 0, 0, 'R');

$formatname = "preuvedelib-" . date('dmYhis');
$pdf->Output('../uploads/pdf/' . $formatname . '.pdf', 'F');

header('Location: ' . $urlopen . $formatname . '.pdf');
exit;
