<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php"); 
require_once("../include/fonctionPrint.php"); 

//Requete print
$idI=$_SESSION['idI'];
$idC=$_SESSION['idC'];
$perConcern=$_SESSION['perConcern'];
//Affichage Des périodes
$aff = "";
if ($perConcern == "P1") {
    $aff = "Première Période";
} elseif ($perConcern == "P2") {
    $aff = "Deuxième Période";
} elseif ($perConcern == "P3") {
    $aff = "Troisième Période";
} elseif ($perConcern == "P4") {
    $aff = "Quatrième Période";
} elseif ($perConcern == "P5") {
    $aff = "Cinquième Période";
} elseif ($perConcern == "P6") {
    $aff = "Sixième Période";
} else {
    $aff = "Période non reconnue";
}

//Requetes pour les info de base
$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$ResultmaxAS = $resPgrh['idAn'];

$requestMaxAs="SELECT * FROM t_an WHERE idA='$ResultmaxAS'";
$setMaxAs=$pdo->query($requestMaxAs)->fetch();
$annee = $setMaxAs['idA'];
$desan = $setMaxAs['designA'];

$rqt="SELECT *
FROM t_classe INNER JOIN t_option ON t_classe.idO = t_option.idO
WHERE t_classe.idC = '$idC'";
$setClasse=$pdo->query($rqt)->fetch();
$classeEl = $setClasse['design'].' '.$setClasse['designO'].' '.$setClasse['ord'];

$requeteInscrit="SELECT * FROM t_inscrit WHERE idI = '$idI'";
$resultatInscrit=$pdo->query($requeteInscrit)->fetch();
$eleve = $resultatInscrit['nom'];

$requeteClasse="SELECT * FROM t_classe WHERE idC = '$idC'";
$resultatClasse=$pdo->query($requeteClasse)->fetch();
$sectionClasse = $resultatClasse['sec'];

$requeteTotIns="SELECT COUNT(*) AS countIns FROM t_inscrit WHERE idC = '$idC'";
$resultatTotIns=$pdo->query($requeteTotIns)->fetch();
$totIns = $resultatTotIns['countIns'];

//Design BN
$image1 = "../uploads/logo.png";
$pdf=new FPDF();
$pdf->AddPage();
$pdf->Image($image1, 20, 3, 20, 20);
$pdf->setFont('courier','',15);
$pdf->cell(0,4,"COMPLEXE SCOLAIRE LA RECONNAISSANCE",0,0,'C');
$pdf->Ln(10);
$pdf->SetTextColor(0,0,0);
$pdf->setFont('courier','B',13);
$pdf->Cell(0 ,5,'BULLETIN DE NOTES',0,0,'C');
$pdf->SetFont('Arial','',10);
$pdf->Ln(5);
$pdf->Cell(130 ,5,utf8_decode('Elève : '.strtoupper($eleve)),0,0);
$pdf->Cell(130 ,5,utf8_decode('Cycle : '.$sectionClasse),0,0);
$pdf->Ln(5);
$pdf->Cell(130 ,5,utf8_decode('Classe : '.$classeEl),0,0);
$pdf->Cell(130 ,5,utf8_decode('Année scolaire : '.$desan),0,0);
$pdf->Ln(5);
$pdf->Cell(130 ,5,utf8_decode('Période : '.$aff),0,0);
$pdf->Cell(130 ,5,utf8_decode('Date de livraison : Le '.date('d-m-Y')),0,0);
$pdf->Ln(6);
$pdf->setFont('Arial','B',10);
$pdf->cell(12,5,utf8_decode('N°'),1,0,'C');
$pdf->cell(120,5,'COURS',1,0,'C');
$pdf->cell(60,5,'COTES',1,0,'C');
$pdf->Ln(5);

if($sectionClasse=='Maternelle'){
    $i = 1;
    //Cotes request
    $reqCote = "SELECT * FROM t_cote_mat INNER JOIN t_inscrit ON 
    t_inscrit.idI = t_cote_mat.idI INNER JOIN t_cours ON
    t_cours.idCours = t_cote_mat.idCours WHERE t_inscrit.idI = '$idI'";
    $stmCote=$pdo->query($reqCote);
    //Conduites request
    $reqCond = "SELECT * FROM t_cond_mat INNER JOIN t_inscrit ON 
    t_inscrit.idI = t_cond_mat.idI INNER JOIN t_classe ON
    t_classe.idC = t_cond_mat.idC INNER JOIN t_an ON
    t_an.idA = t_cond_mat.idA WHERE t_inscrit.idI = '$idI'
    AND t_an.idA='$annee' AND t_classe.idC='$idC'";
    $stmCond=$pdo->query($reqCond)->fetch();

    //Affichage cotes
    while ($cotes=$stmCote->fetch()) { 
        $pdf->setFont('courier','',10);
        $pdf->cell(12,5, $i++,1,0,'C');
        $pdf->cell(120,5, utf8_decode($cotes['designCours']),1);
        if ($perConcern == "P1") {
            $pdf->cell(30,5, ($cotes['coteP1']==NULL) ? '' : $cotes['coteP1'],1,0,'R');
            $pdf->setFont('courier','B',10);
            $pdf->cell(30,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        } elseif ($perConcern == "P2") {
            $pdf->setFont('courier','',10);
            $pdf->cell(30,5, ($cotes['coteP2']==NULL) ? '' : $cotes['coteP2'],1,0,'R');
            $pdf->setFont('courier','B',10);
            $pdf->cell(30,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        } elseif ($perConcern == "P3") {
            $pdf->setFont('courier','',10);
            $pdf->cell(30,5, ($cotes['coteP3']==NULL) ? '' : $cotes['coteP3'],1,0,'R');
            $pdf->setFont('courier','B',10);
            $pdf->cell(30,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        }
        $pdf->Ln(5);
    }
    $pdf->setFont('Arial','',9);
    $pdf->cell(132,5,'TOTAL',1);
    if ($perConcern == "P1") {
        $totalCote = getTotCotePerMat($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxMat($pdo,$idI,$annee);
        $pdf->cell(30,5,$totalCote,1,0,'R');
        $pdf->setFont('Arial','B',9);
        $pdf->cell(30,5,$totalMaxPer,1,0,'R');
    } elseif ($perConcern == "P2") {
        $totalCote = getTotCotePerMat($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxMat($pdo,$idI,$annee);
        $pdf->setFont('Arial','',9);
        $pdf->cell(30,5,$totalCote,1,0,'R');
        $pdf->setFont('Arial','B',9);
        $pdf->cell(30,5,$totalMaxPer,1,0,'R');
    } elseif ($perConcern == "P3") {
        $totalCote = getTotCotePerMat($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxMat($pdo,$idI,$annee);
        $pdf->setFont('Arial','',9);
        $pdf->cell(30,5,$totalCote,1,0,'R');
        $pdf->setFont('Arial','B',9);
        $pdf->cell(30,5,$totalMaxPer,1,0,'R');
    }
    $pdf->Ln(5);
    $pdf->setFont('Arial','',9);
    $pdf->cell(132,5,'POURCENTAGE ',1);
    $pdf->setFont('Arial','B',10);
    if ($perConcern == "P1") {
        $totalCote = getTotCotePerMat($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxMat($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : round(($totalCote / $totalMaxPer) * 100, 2).' %',1,0,'R');
    } elseif ($perConcern == "P2") {
        $totalCote = getTotCotePerMat($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxMat($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : round(($totalCote / $totalMaxPer) * 100, 2).' %',1,0,'R');
    } elseif ($perConcern == "P3") {
        $totalCote = getTotCotePerMat($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxMat($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : round(($totalCote / $totalMaxPer) * 100, 2).' %',1,0,'R');
    }
    $pdf->Ln(5);

    //Place pour periode
    $placePer1 = getPlaceEleveMatPer($pdo, $idI, $annee, 'P1', $idC);
    $placePer2 = getPlaceEleveMatPer($pdo, $idI, $annee, 'P2', $idC);
    $placePer3 = getPlaceEleveMatPer($pdo, $idI, $annee, 'P3', $idC);
    $pdf->setFont('Arial','',9);
    $pdf->cell(132,5,'PLACE ',1); 
    $pdf->setFont('Arial','B',10);
    if ($perConcern == "P1") {
        $pdf->cell(60,5,($placePer1 === 1) ? "1er/".$totIns : (($placePer1 > 1) ? $placePer1 . utf8_decode("è/").$totIns : ""),1,0,'R');
    } elseif ($perConcern == "P2") {
        $pdf->cell(60,5,($placePer2 === 1) ? "1er/".$totIns : (($placePer2 > 1) ? $placePer2 . utf8_decode("è/").$totIns : ""),1,0,'R');
    } elseif ($perConcern == "P3") {
        $pdf->cell(60,5,($placePer3 === 1) ? "1er/".$totIns : (($placePer3 > 1) ? $placePer3 . utf8_decode("è/").$totIns : ""),1,0,'R');
    }
    $pdf->Ln(5);

    $pdf->setFont('Arial','',9);
    $pdf->cell(132,5,'APPLICATION ',1);
    $pdf->setFont('Arial','B',10);
    if ($perConcern == "P1") {
        $totalCote = getTotCotePerMat($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxMat($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : calculateGrade(round(($totalCote / $totalMaxPer) * 100, 2)),1,0,'R');
    } elseif ($perConcern == "P2") {
        $totalCote = getTotCotePerMat($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxMat($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : calculateGrade(round(($totalCote / $totalMaxPer) * 100, 2)),1,0,'R');
    } elseif ($perConcern == "P3") {
        $totalCote = getTotCotePerMat($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxMat($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : calculateGrade(round(($totalCote / $totalMaxPer) * 100, 2)),1,0,'R');
    }
    $pdf->Ln(5);
    $pdf->setFont('Arial','',9);
    $pdf->cell(132,5,'CONDUITE ',1);
    $pdf->setFont('Arial','B',10);
    if ($perConcern == "P1") {
        $pdf->cell(60,5, ($stmCond['P1']==NULL) ? '' : $stmCond['P1'],1,0,'R');
    } elseif ($perConcern == "P2") {
        $pdf->cell(60,5, ($stmCond['P2']==NULL) ? '' : $stmCond['P2'],1,0,'R');
    } elseif ($perConcern == "P3") {
        $pdf->cell(60,5, ($stmCond['P3']==NULL) ? '' : $stmCond['P3'],1,0,'R');
    }
    $pdf->Ln(5);
}elseif($sectionClasse=='Primaire'){
    $i = 1;
    //Cotes request
    $reqCote = "SELECT * FROM t_cote_pri INNER JOIN t_inscrit ON 
    t_inscrit.idI = t_cote_pri.idI INNER JOIN t_cours ON
    t_cours.idCours = t_cote_pri.idCours WHERE t_inscrit.idI = '$idI'";
    $stmCote=$pdo->query($reqCote);
    //Conduites request
    $reqCond = "SELECT * FROM t_cond_pri INNER JOIN t_inscrit ON 
    t_inscrit.idI = t_cond_pri.idI INNER JOIN t_classe ON
    t_classe.idC = t_cond_pri.idC INNER JOIN t_an ON
    t_an.idA = t_cond_pri.idA WHERE t_inscrit.idI = '$idI'
    AND t_an.idA='$annee' AND t_classe.idC='$idC'";
    $stmCond=$pdo->query($reqCond)->fetch();

    //Affichage cotes
    while ($cotes=$stmCote->fetch()) { 
        $pdf->setFont('courier','',10);
        $pdf->cell(12,5, $i++,1,0,'C');
        $pdf->cell(120,5, utf8_decode($cotes['designCours']),1);
        if ($perConcern == "P1") {
            $pdf->cell(30,5, ($cotes['coteP1']==NULL) ? '' : $cotes['coteP1'],1,0,'R');
            $pdf->setFont('courier','B',10);
            $pdf->cell(30,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        } elseif ($perConcern == "P2") {
            $pdf->setFont('courier','',10);
            $pdf->cell(30,5, ($cotes['coteP2']==NULL) ? '' : $cotes['coteP2'],1,0,'R');
            $pdf->setFont('courier','B',10);
            $pdf->cell(30,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        } elseif ($perConcern == "P3") {
            $pdf->setFont('courier','',10);
            $pdf->cell(30,5, ($cotes['coteP3']==NULL) ? '' : $cotes['coteP3'],1,0,'R');
            $pdf->setFont('courier','B',10);
            $pdf->cell(30,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        } elseif ($perConcern == "P4") {
            $pdf->setFont('courier','',10);
            $pdf->cell(30,5, ($cotes['coteP4']==NULL) ? '' : $cotes['coteP4'],1,0,'R');
            $pdf->setFont('courier','B',10);
            $pdf->cell(30,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        }elseif ($perConcern == "P5") {
            $pdf->setFont('courier','',10);
            $pdf->cell(30,5, ($cotes['coteP5']==NULL) ? '' : $cotes['coteP5'],1,0,'R');
            $pdf->setFont('courier','B',10);
            $pdf->cell(30,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        } elseif ($perConcern == "P6") {
            $pdf->setFont('courier','',10);
            $pdf->cell(30,5, ($cotes['coteP6']==NULL) ? '' : $cotes['coteP6'],1,0,'R');
            $pdf->setFont('courier','B',10);
            $pdf->cell(30,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        }
        $pdf->Ln(5);
    }
    $pdf->setFont('Arial','',9);
    $pdf->cell(132,5,'TOTAUX',1);
    if ($perConcern == "P1") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->cell(30,5,$totalCote,1,0,'R');
        $pdf->setFont('Arial','B',10);
        $pdf->cell(30,5,$totalMaxPer,1,0,'R');
    } elseif ($perConcern == "P2") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->setFont('Arial','',10);
        $pdf->cell(30,5,$totalCote,1,0,'R');
        $pdf->setFont('Arial','B',10);
        $pdf->cell(30,5,$totalMaxPer,1,0,'R');
    } elseif ($perConcern == "P3") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->setFont('Arial','',10);
        $pdf->cell(30,5,$totalCote,1,0,'R');
        $pdf->setFont('Arial','B',10);
        $pdf->cell(30,5,$totalMaxPer,1,0,'R');
    } elseif ($perConcern == "P4") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->setFont('Arial','',10);
        $pdf->cell(30,5,$totalCote,1,0,'R');
        $pdf->setFont('Arial','B',10);
        $pdf->cell(30,5,$totalMaxPer,1,0,'R');
    }elseif ($perConcern == "P5") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->setFont('Arial','',10);
        $pdf->cell(30,5,$totalCote,1,0,'R');
        $pdf->setFont('Arial','B',10);
        $pdf->cell(30,5,$totalMaxPer,1,0,'R');
    } elseif ($perConcern == "P6") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->setFont('Arial','',10);
        $pdf->cell(30,5,$totalCote,1,0,'R');
        $pdf->setFont('Arial','B',10);
        $pdf->cell(30,5,$totalMaxPer,1,0,'R');
    }
    $pdf->Ln(5);
    $pdf->setFont('Arial','',9);
    $pdf->cell(132,5,'POURCENTAGE ',1);
    $pdf->setFont('Arial','B',10);
    if ($perConcern == "P1") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : round(($totalCote / $totalMaxPer) * 100, 2).' %',1,0,'R');
    } elseif ($perConcern == "P2") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : round(($totalCote / $totalMaxPer) * 100, 2).' %',1,0,'R');
    } elseif ($perConcern == "P3") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : round(($totalCote / $totalMaxPer) * 100, 2).' %',1,0,'R');
    } elseif ($perConcern == "P4") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : round(($totalCote / $totalMaxPer) * 100, 2).' %',1,0,'R');
    }elseif ($perConcern == "P5") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : round(($totalCote / $totalMaxPer) * 100, 2).' %',1,0,'R');
    } elseif ($perConcern == "P6") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : round(($totalCote / $totalMaxPer) * 100, 2).' %',1,0,'R');
    }
    $pdf->Ln(5);

    //Place pour periode
    $placePer1 = getPlaceElevePriPer($pdo, $idI, $annee, 'P1', $idC);
    $placePer2 = getPlaceElevePriPer($pdo, $idI, $annee, 'P2', $idC);
    $placePer3 = getPlaceElevePriPer($pdo, $idI, $annee, 'P3', $idC);
    $placePer4 = getPlaceElevePriPer($pdo, $idI, $annee, 'P4', $idC);
    $placePer5 = getPlaceElevePriPer($pdo, $idI, $annee, 'P5', $idC);
    $placePer6 = getPlaceElevePriPer($pdo, $idI, $annee, 'P6', $idC);
    $pdf->setFont('Arial','',9);
    $pdf->cell(132,5,'PLACE ',1);
    $pdf->setFont('Arial','B',10);
    if ($perConcern == "P1") {
        $pdf->cell(60,5,($placePer1 === 1) ? "1er/".$totIns : (($placePer1 > 1) ? $placePer1 . utf8_decode("è/").$totIns : ""),1,0,'R');
    } elseif ($perConcern == "P2") {
        $pdf->cell(60,5,($placePer2 === 1) ? "1er/".$totIns : (($placePer2 > 1) ? $placePer2 . utf8_decode("è/").$totIns : ""),1,0,'R');
    } elseif ($perConcern == "P3") {
        $pdf->cell(60,5,($placePer3 === 1) ? "1er/".$totIns : (($placePer3 > 1) ? $placePer3 . utf8_decode("è/").$totIns : ""),1,0,'R');
    }elseif ($perConcern == "P4") {
        $pdf->cell(60,5,($placePer4 === 1) ? "1er/".$totIns : (($placePer4 > 1) ? $placePer4 . utf8_decode("è/").$totIns : ""),1,0,'R');
    } elseif ($perConcern == "P5") {
        $pdf->cell(60,5,($placePer5 === 1) ? "1er/".$totIns : (($placePer5 > 1) ? $placePer5 . utf8_decode("è/").$totIns : ""),1,0,'R');
    } elseif ($perConcern == "P6") {
        $pdf->cell(60,5,($placePer6 === 1) ? "1er/".$totIns : (($placePer6 > 1) ? $placePer6 . utf8_decode("è/").$totIns : ""),1,0,'R');
    }
    $pdf->Ln(5);

    $pdf->setFont('Arial','',9);
    $pdf->cell(132,5,'APPLICATION ',1);
    $pdf->setFont('Arial','B',10);
    if ($perConcern == "P1") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : calculateGrade(round(($totalCote / $totalMaxPer) * 100, 2)),1,0,'R');
    } elseif ($perConcern == "P2") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : calculateGrade(round(($totalCote / $totalMaxPer) * 100, 2)),1,0,'R');
    } elseif ($perConcern == "P3") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : calculateGrade(round(($totalCote / $totalMaxPer) * 100, 2)),1,0,'R');
    } elseif ($perConcern == "P4") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $totalRatioPer = round(($totalCote / $totalMaxPer) * 100, 2);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : $totalRatioPer.' %',1,0,'R');
    }elseif ($perConcern == "P5") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : calculateGrade(round(($totalCote / $totalMaxPer) * 100, 2)),1,0,'R');
    } elseif ($perConcern == "P6") {
        $totalCote = getTotCotePerPri($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxPri($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : calculateGrade(round(($totalCote / $totalMaxPer) * 100, 2)),1,0,'R');
    }
    $pdf->Ln(5);
    $pdf->setFont('Arial','',9);
    $pdf->cell(132,5,'CONDUITE ',1);
    $pdf->setFont('Arial','B',10);
    if ($perConcern == "P1") {
        $pdf->cell(60,5, ($stmCond['P1']==NULL) ? '' : $stmCond['P1'],1,0,'R');
    } elseif ($perConcern == "P2") {
        $pdf->cell(60,5, ($stmCond['P2']==NULL) ? '' : $stmCond['P2'],1,0,'R');
    } elseif ($perConcern == "P3") {
        $pdf->cell(60,5, ($stmCond['P3']==NULL) ? '' : $stmCond['P3'],1,0,'R');
    } elseif ($perConcern == "P4") {
        $pdf->cell(60,5, ($stmCond['P4']==NULL) ? '' : $stmCond['P4'],1,0,'R');
    }elseif ($perConcern == "P5") {
        $pdf->cell(60,5, ($stmCond['P5']==NULL) ? '' : $stmCond['P5'],1,0,'R');
    } elseif ($perConcern == "P6") {
        $pdf->cell(60,5, ($stmCond['P6']==NULL) ? '' : $stmCond['P6'],1,0,'R');
    }
    $pdf->Ln(5);
}elseif($sectionClasse=='Secondaire'){
    $i = 1;
    //Cotes request
    $reqCote = "SELECT * FROM t_cote_sec INNER JOIN t_inscrit ON 
    t_inscrit.idI = t_cote_sec.idI INNER JOIN t_cours ON
    t_cours.idCours = t_cote_sec.idCours WHERE t_inscrit.idI = '$idI'";
    $stmCote=$pdo->query($reqCote);
    //Conduites request
    $reqCond = "SELECT * FROM t_cond_sec INNER JOIN t_inscrit ON 
    t_inscrit.idI = t_cond_sec.idI INNER JOIN t_classe ON
    t_classe.idC = t_cond_sec.idC INNER JOIN t_an ON
    t_an.idA = t_cond_sec.idA WHERE t_inscrit.idI = '$idI'
    AND t_an.idA='$annee' AND t_classe.idC='$idC'";
    $stmCond=$pdo->query($reqCond)->fetch();

    //Affichage cotes
    while ($cotes=$stmCote->fetch()) { 
        $pdf->setFont('courier','',10);
        $pdf->cell(12,5, $i++,1,0,'C');
        $pdf->cell(120,5, utf8_decode($cotes['designCours']),1);
        if ($perConcern == "P1") {
            $pdf->cell(30,5, ($cotes['coteP1']==NULL) ? '' : $cotes['coteP1'],1,0,'R');
            $pdf->setFont('courier','B',10);
            $pdf->cell(30,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        } elseif ($perConcern == "P2") {
            $pdf->setFont('courier','',10);
            $pdf->cell(30,5, ($cotes['coteP2']==NULL) ? '' : $cotes['coteP2'],1,0,'R');
            $pdf->setFont('courier','B',10);
            $pdf->cell(30,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        } elseif ($perConcern == "P3") {
            $pdf->setFont('courier','',10);
            $pdf->cell(30,5, ($cotes['coteP3']==NULL) ? '' : $cotes['coteP3'],1,0,'R');
            $pdf->setFont('courier','B',10);
            $pdf->cell(30,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        } elseif ($perConcern == "P4") {
            $pdf->setFont('courier','',10);
            $pdf->cell(30,5, ($cotes['coteP4']==NULL) ? '' : $cotes['coteP4'],1,0,'R');
            $pdf->setFont('courier','B',10);
            $pdf->cell(30,5, ($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'R');
        }
        $pdf->Ln(5);
    }
    $pdf->setFont('Arial','',9);
    $pdf->cell(132,5,'TOTAL',1);
    if ($perConcern == "P1") {
        $totalCote = getTotCotePerSec($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
        $pdf->cell(30,5,$totalCote,1,0,'R');
        $pdf->setFont('Arial','B',10);
        $pdf->cell(30,5,$totalMaxPer,1,0,'R');
    } elseif ($perConcern == "P2") {
        $totalCote = getTotCotePerSec($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
        $pdf->setFont('Arial','',10);
        $pdf->cell(30,5,$totalCote,1,0,'R');
        $pdf->setFont('Arial','B',10);
        $pdf->cell(30,5,$totalMaxPer,1,0,'R');
    } elseif ($perConcern == "P3") {
        $totalCote = getTotCotePerSec($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
        $pdf->setFont('Arial','',10);
        $pdf->cell(30,5,$totalCote,1,0,'R');
        $pdf->setFont('Arial','B',10);
        $pdf->cell(30,5,$totalMaxPer,1,0,'R');
    } elseif ($perConcern == "P4") {
        $totalCote = getTotCotePerSec($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
        $pdf->setFont('Arial','',10);
        $pdf->cell(30,5,$totalCote,1,0,'R');
        $pdf->setFont('Arial','B',10);
        $pdf->cell(30,5,$totalMaxPer,1,0,'R');
    }
    $pdf->Ln(5);
    $pdf->setFont('Arial','',9);
    $pdf->cell(132,5,'POURCENTAGE ',1);
    $pdf->setFont('Arial','B',10);
    if ($perConcern == "P1") {
        $totalCote = getTotCotePerSec($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : round(($totalCote / $totalMaxPer) * 100, 2).' %',1,0,'R');
    } elseif ($perConcern == "P2") {
        $totalCote = getTotCotePerSec($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : round(($totalCote / $totalMaxPer) * 100, 2).' %',1,0,'R');
    } elseif ($perConcern == "P3") {
        $totalCote = getTotCotePerSec($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : round(($totalCote / $totalMaxPer) * 100, 2).' %',1,0,'R');
    } elseif ($perConcern == "P4") {
        $totalCote = getTotCotePerSec($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : round(($totalCote / $totalMaxPer) * 100, 2).' %',1,0,'R');
    }
    $pdf->Ln(5);

    //Place pour periode
    $placePer1 = getPlaceEleveSecPer($pdo, $idI, $annee, 'P1', $idC);
    $placePer2 = getPlaceEleveSecPer($pdo, $idI, $annee, 'P2', $idC);
    $placePer3 = getPlaceEleveSecPer($pdo, $idI, $annee, 'P3', $idC);
    $placePer4 = getPlaceEleveSecPer($pdo, $idI, $annee, 'P4', $idC);
    $pdf->setFont('Arial','',9);
    $pdf->cell(132,5,'PLACE ',1);
    $pdf->setFont('Arial','B',10);
    if ($perConcern == "P1") {
        $pdf->cell(60,5,($placePer1 === 1) ? "1er/".$totIns : (($placePer1 > 1) ? $placePer1 . utf8_decode("è/").$totIns : ""),1,0,'R');
    } elseif ($perConcern == "P2") {
        $pdf->cell(60,5,($placePer2 === 1) ? "1er/".$totIns : (($placePer2 > 1) ? $placePer2 . utf8_decode("è/").$totIns : ""),1,0,'R');
    } elseif ($perConcern == "P3") {
        $pdf->cell(60,5,($placePer3 === 1) ? "1er/".$totIns : (($placePer3 > 1) ? $placePer3 . utf8_decode("è/").$totIns : ""),1,0,'R');
    }elseif ($perConcern == "P4") {
        $pdf->cell(60,5,($placePer4 === 1) ? "1er/".$totIns : (($placePer4 > 1) ? $placePer4 . utf8_decode("è/").$totIns : ""),1,0,'R');
    }
    $pdf->Ln(5);

    $pdf->setFont('Arial','',9);
    $pdf->cell(132,5,'APPLICATION ',1);
    $pdf->setFont('Arial','B',10);
    if ($perConcern == "P1") {
        $totalCote = getTotCotePerSec($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : calculateGrade(round(($totalCote / $totalMaxPer) * 100, 2)),1,0,'R');
    } elseif ($perConcern == "P2") {
        $totalCote = getTotCotePerSec($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : calculateGrade(round(($totalCote / $totalMaxPer) * 100, 2)),1,0,'R');
    } elseif ($perConcern == "P3") {
        $totalCote = getTotCotePerSec($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : calculateGrade(round(($totalCote / $totalMaxPer) * 100, 2)),1,0,'R');
    } elseif ($perConcern == "P4") {
        $totalCote = getTotCotePerSec($pdo,$idI,$annee,$perConcern);
        $totalMaxPer = getTotCoteMaxSec($pdo,$idI,$annee);
        $pdf->cell(60,5,($totalCote==NULL) ? '' : calculateGrade(round(($totalCote / $totalMaxPer) * 100, 2)),1,0,'R');
    }
    $pdf->Ln(5);
    $pdf->setFont('Arial','',9);
    $pdf->cell(132,5,'CONDUITE ',1);
    $pdf->setFont('Arial','B',10);
    if ($perConcern == "P1") {
        $pdf->cell(60,5, ($stmCond['P1']==NULL) ? '' : $stmCond['P1'],1,0,'R');
    } elseif ($perConcern == "P2") {
        $pdf->cell(60,5, ($stmCond['P2']==NULL) ? '' : $stmCond['P2'],1,0,'R');
    } elseif ($perConcern == "P3") {
        $pdf->cell(60,5, ($stmCond['P3']==NULL) ? '' : $stmCond['P3'],1,0,'R');
    } elseif ($perConcern == "P4") {
        $pdf->cell(60,5, ($stmCond['P4']==NULL) ? '' : $stmCond['P4'],1,0,'R');
    }
    $pdf->Ln(5);
}else{
    $pdf->cell(192,5,utf8_decode("IL Y A UNE ERREUR"),1,0,'C');
    $pdf->Ln(5);
}

//Footer
$pdf->setFont('Arial','I',9);
$pdf->Cell(0,10,utf8_decode('Sceau et Signature'),0,0,'L');
$pdf->Cell(0,10,utf8_decode(' Fait à Kananga Le '.date('d-m-Y A h:i:s A')),0,0,'R');

$formatname = "bulletin-" . date('dmYhis');
$pdf->Output('../uploads/pdf/' . $formatname . '.pdf', 'F');

header('Location: ' . $urlopen . $formatname . '.pdf');
exit;

?>

