<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php"); 
require_once("../include/fonctionPrint.php"); 

//Requete print
$idI=$_SESSION['idI'];
$idC=$_SESSION['idC'];
$perConcern=$_SESSION['perConcern'];
//Affichage Des périodes
$aff = "";
if ($perConcern == "Fin") {
    $aff = "Fin d'année";
} else {
    $aff = "Période non reconnue";
}

//Requetes pour les info de base
$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$ResultmaxAS = $resPgrh['idAn'];

$requestMaxAs="SELECT * FROM t_an WHERE idA='$ResultmaxAS'";
$setMaxAs=$pdo->query($requestMaxAs)->fetch();
$annee = $setMaxAs['idA'];
$desan = $setMaxAs['designA'];

$rqt="SELECT *
FROM t_classe INNER JOIN t_option ON t_classe.idO = t_option.idO
WHERE t_classe.idC = '$idC'";
$setClasse=$pdo->query($rqt)->fetch();
$classeEl = $setClasse['design'].' '.$setClasse['designO'].' '.$setClasse['ord'];

$requeteInscrit="SELECT * FROM t_inscrit WHERE idI = '$idI'";
$resultatInscrit=$pdo->query($requeteInscrit)->fetch();
$eleve = $resultatInscrit['nom'];

$requeteTotIns="SELECT COUNT(*) AS countIns FROM t_inscrit WHERE idC = '$idC'";
$resultatTotIns=$pdo->query($requeteTotIns)->fetch();
$totIns = $resultatTotIns['countIns'];

$requeteClasse="SELECT * FROM t_classe WHERE idC = '$idC'";
$resultatClasse=$pdo->query($requeteClasse)->fetch();
$sectionClasse = $resultatClasse['sec'];

//Design BN
$image1 = "../uploads/logo.png";
$pdf=new FPDF();
$pdf->AddPage();
$pdf->Image($image1, 20, 3, 20, 20);
$pdf->setFont('courier','',15);
$pdf->cell(0,4,"COMPLEXE SCOLAIRE LA RECONNAISSANCE",0,0,'C');
$pdf->Ln(10);
$pdf->SetTextColor(0,0,0);
$pdf->setFont('courier','B',13);
$pdf->Cell(0 ,5,'BULLETIN DE NOTES',0,0,'C');
$pdf->SetFont('Arial','',10);
$pdf->Ln(5);
$pdf->Cell(130 ,5,utf8_decode('Elève : '.strtoupper($eleve)),0,0);
$pdf->Cell(130 ,5,utf8_decode('Cycle : '.$sectionClasse),0,0);
$pdf->Ln(5);
$pdf->Cell(130 ,5,utf8_decode('Classe : '.$classeEl),0,0);
$pdf->Cell(130 ,5,utf8_decode('Année scolaire : '.$desan),0,0);
$pdf->Ln(5);
$pdf->Cell(130 ,5,utf8_decode('Période : '.$aff),0,0);
$pdf->Cell(130 ,5,utf8_decode('Date de livraison : Le '.date('d-m-Y')),0,0);
$pdf->Ln(6);

if($sectionClasse=='Maternelle'){
    // Définir l'en-tête du tableau
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(40,10,utf8_decode("BRANCHES"),1,0,'C');//-10
    $pdf->Setx(50);
    $pdf->cell(40,5,utf8_decode("PREMIER TRIMESTRE"),1,0,'C');
    $pdf->cell(40,5,utf8_decode("DEUXIEME TRIMESTRE"),1,0,'C');
    $pdf->cell(40,5,utf8_decode("TROISIEME TRIMESTRE"),1,0,'C');
    $pdf->cell(30,10,utf8_decode("TOT GEN"),1,0,'C');//-15
    $pdf->Setx(200);
    $pdf->Ln(5);
    $pdf->Setx(50);
    $pdf->setFont('Helvetica','',7);
    $pdf->cell(20,5,utf8_decode("POINTS OBT."),1,0,'C');
    $pdf->cell(20,5,utf8_decode("MAX"),1,0,'C');
    $pdf->Setx(90);
    $pdf->cell(20,5,utf8_decode("POINTS OBT."),1,0,'C');
    $pdf->cell(20,5,utf8_decode("MAX"),1,0,'C');
    $pdf->Setx(130);
    $pdf->cell(20,5,utf8_decode("POINTS OBT."),1,0,'C');
    $pdf->cell(20,5,utf8_decode("MAX"),1,0,'C');
    $pdf->Ln(5);

    // Regrouper les cours par sous-catégorie
    $sqlSubCat = "SELECT DISTINCT tsc.idSC, tsc.designSousCat 
               FROM t_sous_categ tsc 
               INNER JOIN t_cours tc ON tsc.idSC = tc.idSC
               INNER JOIN t_cote_mat tcm ON tc.idCours = tcm.idCours
               WHERE tcm.idI = '$idI'
               ORDER BY tsc.idSC";
    $stmSubCat = $pdo->query($sqlSubCat);
    
    //Conduites request
    $reqCond = "SELECT * FROM t_cond_mat INNER JOIN t_inscrit ON 
    t_inscrit.idI = t_cond_mat.idI INNER JOIN t_classe ON
    t_classe.idC = t_cond_mat.idC INNER JOIN t_an ON
    t_an.idA = t_cond_mat.idA WHERE t_inscrit.idI = '$idI'
    AND t_an.idA='$annee' AND t_classe.idC='$idC'";
    $stmCond=$pdo->query($reqCond)->fetch();
    
    $totalGeneralP1 = 0;
    $totalGeneralP2 = 0;
    $totalGeneralP3 = 0;
    $totalGeneralMax = 0;
    
    while ($subCat = $stmSubCat->fetch()) {
        $idSC = $subCat['idSC'];
        $designSousCat = $subCat['designSousCat'];
        
        // Sous-catégorie titre
        $pdf->setFont('Helvetica','B',9);
        $pdf->SetFillColor(200, 220, 255);
        $pdf->cell(190,6,utf8_decode($designSousCat),1,0,'L',true);
        $pdf->Ln(6);
        
        // Requête pour récupérer les cours de cette sous-catégorie
        $reqCote = "SELECT tc.*, tcm.* FROM t_cours tc 
                   INNER JOIN t_cote_mat tcm ON tc.idCours = tcm.idCours 
                   WHERE tcm.idI = '$idI' AND tc.idSC = '$idSC'";
        $stmCote = $pdo->query($reqCote);
        
        $totalSousCatP1 = 0;
        $totalSousCatP2 = 0;
        $totalSousCatP3 = 0;
        $totalSousCatMax = 0;
        
        while ($cotes = $stmCote->fetch()) { 
            $pdf->setFont('Helvetica','',8);
            $pdf->cell(40,5,utf8_decode($cotes['designCours']),1,0,'L');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(20,5,($cotes['coteP1']==NULL) ? '' : $cotes['coteP1'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(20,5,($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(20,5,($cotes['coteP2']==NULL) ? '' : $cotes['coteP2'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(20,5,($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(20,5,($cotes['coteP3']==NULL) ? '' : $cotes['coteP3'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(20,5,($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(15,5,($cotes['coteP1'] == NULL || $cotes['coteP2'] == NULL || $cotes['coteP3'] == NULL) ? '' : ($cotes['coteP1'] + $cotes['coteP2'] + $cotes['coteP3']),1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(15,5,($cotes['maxPer'] == NULL) ? '' : ($cotes['maxPer'] * 3),1,0,'C');
            $pdf->Ln(5);
            
            // Cumul des totaux pour cette sous-catégorie
            $totalSousCatP1 += ($cotes['coteP1'] == NULL) ? 0 : $cotes['coteP1'];
            $totalSousCatP2 += ($cotes['coteP2'] == NULL) ? 0 : $cotes['coteP2'];
            $totalSousCatP3 += ($cotes['coteP3'] == NULL) ? 0 : $cotes['coteP3'];
            $totalSousCatMax += ($cotes['maxPer'] == NULL) ? 0 : $cotes['maxPer'];
        }
        
        // Affichage des sous-totaux par sous-catégorie
        $pdf->setFont('Helvetica','B',8);
        $pdf->SetFillColor(240, 240, 240);
        $pdf->cell(40,5,'SOUS-TOTAL '.utf8_decode($designSousCat),1,0,'L',true);
        $pdf->cell(20,5,$totalSousCatP1,1,0,'C',true);
        $pdf->cell(20,5,$totalSousCatMax,1,0,'C',true);
        $pdf->cell(20,5,$totalSousCatP2,1,0,'C',true);
        $pdf->cell(20,5,$totalSousCatMax,1,0,'C',true);
        $pdf->cell(20,5,$totalSousCatP3,1,0,'C',true);
        $pdf->cell(20,5,$totalSousCatMax,1,0,'C',true);
        $pdf->cell(15,5,($totalSousCatP1 + $totalSousCatP2 + $totalSousCatP3),1,0,'C',true);
        $pdf->cell(15,5,($totalSousCatMax * 3),1,0,'C',true);
        $pdf->Ln(5);
        
        // Cumul des totaux généraux
        $totalGeneralP1 += $totalSousCatP1;
        $totalGeneralP2 += $totalSousCatP2;
        $totalGeneralP3 += $totalSousCatP3;
        $totalGeneralMax += $totalSousCatMax;
    }
    
    // Affichage des totaux généraux
    $pdf->setFont('Helvetica','B',9);
    $pdf->SetFillColor(220, 220, 220);
    $pdf->cell(40,5,'TOTAUX GENERAUX',1,0,'L',true);
    $pdf->cell(20,5,$totalGeneralP1,1,0,'C',true);
    $pdf->cell(20,5,$totalGeneralMax,1,0,'C',true);
    $pdf->cell(20,5,$totalGeneralP2,1,0,'C',true);
    $pdf->cell(20,5,$totalGeneralMax,1,0,'C',true);
    $pdf->cell(20,5,$totalGeneralP3,1,0,'C',true);
    $pdf->cell(20,5,$totalGeneralMax,1,0,'C',true);
    $pdf->cell(15,5,($totalGeneralP1 + $totalGeneralP2 + $totalGeneralP3),1,0,'C',true);
    $pdf->cell(15,5,($totalGeneralMax * 3),1,0,'C',true);
    $pdf->Ln(5);
    
    // Pourcentages globaux
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(40,5,'POURCENTAGE ',1);
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(40,5,($totalGeneralP1==0) ? '' : round(($totalGeneralP1 / $totalGeneralMax) * 100, 2).' %',1,0,'C');
    $pdf->cell(40,5,($totalGeneralP2==0) ? '' : round(($totalGeneralP2 / $totalGeneralMax) * 100, 2).' %',1,0,'C');
    $pdf->cell(40,5,($totalGeneralP3==0) ? '' : round(($totalGeneralP3 / $totalGeneralMax) * 100, 2).' %',1,0,'C');
    $pdf->cell(30,5,round((($totalGeneralP1+$totalGeneralP2+$totalGeneralP3)/($totalGeneralMax*3)) * 100, 2).' %',1,0,'C');
    $pdf->Ln(5);

    // Place pour periode
    $placePer1 = getPlaceEleveMatPer($pdo, $idI, $annee, 'P1', $idC);
    $placePer2 = getPlaceEleveMatPer($pdo, $idI, $annee, 'P2', $idC);
    $placePer3 = getPlaceEleveMatPer($pdo, $idI, $annee, 'P3', $idC);
    $placePer4 = getPlaceEleveMatFin($pdo, $idI, $annee, $idC);
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(40,5,'PLACE ',1);
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(40,5,($placePer1 === 1) ? "1er/".$totIns : (($placePer1 > 1) ? $placePer1 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(40,5,($placePer2 === 1) ? "1er/".$totIns : (($placePer2 > 1) ? $placePer2 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(40,5,($placePer3 === 1) ? "1er/".$totIns : (($placePer3 > 1) ? $placePer3 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(30,5,($placePer4 === 1) ? "1er/".$totIns : (($placePer4 > 1) ? $placePer4 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->Ln(5);

    // Application
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(40,5,'APPLICATION ',1);
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(40,5,($totalGeneralP1==0) ? '' : calculateGrade(round(($totalGeneralP1 / $totalGeneralMax) * 100, 2)),1,0,'C');
    $pdf->cell(40,5,($totalGeneralP2==0) ? '' : calculateGrade(round(($totalGeneralP2 / $totalGeneralMax) * 100, 2)),1,0,'C');
    $pdf->cell(40,5,($totalGeneralP3==0) ? '' : calculateGrade(round(($totalGeneralP3 / $totalGeneralMax) * 100, 2)),1,0,'C');
    $pdf->cell(30,5,calculateGrade(round((($totalGeneralP1+$totalGeneralP2+$totalGeneralP3)/($totalGeneralMax*3)) * 100, 2)),1,0,'C');
    $pdf->Ln(5);

    // Conduite
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(40,5,'CONDUITE ',1);
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(40,5,($stmCond['P1']==NULL) ? '' : $stmCond['P1'],1,0,'C');
    $pdf->cell(40,5,($stmCond['P2']==NULL) ? '' : $stmCond['P2'],1,0,'C');
    $pdf->cell(40,5,($stmCond['P3']==NULL) ? '' : $stmCond['P3'],1,0,'C');
    $pdf->cell(30,5,'',1,0,'C',true);
    $pdf->Ln(5);

}elseif($sectionClasse=='Primaire'){
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(30,15,utf8_decode("BRANCHES"),1,0,'C');
    $pdf->Setx(40);
    $pdf->cell(50,5,utf8_decode("PREMIER SEMESTRE"),1,0,'C');
    $pdf->cell(50,5,utf8_decode("DEUXIEME SEMESTRE"),1,0,'C');
    $pdf->cell(50,5,utf8_decode("TROISIEME SEMESTRE"),1,0,'C');
    $pdf->cell(15,15,utf8_decode("TOT GEN"),1,0,'C');
    $pdf->Setx(200);
    $pdf->Ln(5);
    $pdf->Setx(40);
    $pdf->cell(30,5,utf8_decode("TRAV.JOUR"),1,0,'C');
    $pdf->cell(10,10,utf8_decode("EXAM"),1,0,'C');
    $pdf->cell(10,10,utf8_decode("TOT"),1,0,'C');
    $pdf->cell(30,5,utf8_decode("TRAV.JOUR"),1,0,'C');
    $pdf->cell(10,10,utf8_decode("EXAM"),1,0,'C');
    $pdf->cell(10,10,utf8_decode("TOT"),1,0,'C');
    $pdf->cell(30,5,utf8_decode("TRAV.JOUR"),1,0,'C');
    $pdf->cell(10,10,utf8_decode("EXAM"),1,0,'C');
    $pdf->cell(10,10,utf8_decode("TOT"),1,0,'C');
    $pdf->Setx(164);
    $pdf->Ln(5);
    $pdf->Setx(40);
    $pdf->cell(15,5,utf8_decode("1èP"),1,0,'C');
    $pdf->cell(15,5,utf8_decode("2èP"),1,0,'C');
    $pdf->Setx(90);
    $pdf->cell(15,5,utf8_decode("3èP"),1,0,'C');
    $pdf->cell(15,5,utf8_decode("4èP"),1,0,'C');
    $pdf->Setx(140);
    $pdf->cell(15,5,utf8_decode("5èP"),1,0,'C');
    $pdf->cell(15,5,utf8_decode("6èP"),1,0,'C');
    $pdf->Ln(5);

    // Regrouper les cours par sous-catégorie
    $sqlSubCat = "SELECT DISTINCT tsc.idSC, tsc.designSousCat 
               FROM t_sous_categ tsc 
               INNER JOIN t_cours tc ON tsc.idSC = tc.idSC
               INNER JOIN t_cote_pri tcm ON tc.idCours = tcm.idCours
               WHERE tcm.idI = '$idI'
               ORDER BY tsc.idSC";
    $stmSubCat = $pdo->query($sqlSubCat);
    
    //Conduites request
    $reqCond = "SELECT * FROM t_cond_pri INNER JOIN t_inscrit ON 
    t_inscrit.idI = t_cond_pri.idI INNER JOIN t_classe ON
    t_classe.idC = t_cond_pri.idC INNER JOIN t_an ON
    t_an.idA = t_cond_pri.idA WHERE t_inscrit.idI = '$idI'
    AND t_an.idA='$annee' AND t_classe.idC='$idC'";
    $stmCond=$pdo->query($reqCond)->fetch();
    
    $totalGeneralP1 = 0;
    $totalGeneralP2 = 0;
    $totalGeneralEx1 = 0;
    $totalGeneralP3 = 0;
    $totalGeneralP4 = 0;
    $totalGeneralEx2 = 0;
    $totalGeneralP5 = 0;
    $totalGeneralP6 = 0;
    $totalGeneralEx3 = 0;
    $totalGeneralMaxP = 0;
    $totalGeneralMaxEx = 0;
    
    while ($subCat = $stmSubCat->fetch()) {
        $idSC = $subCat['idSC'];
        $designSousCat = $subCat['designSousCat'];
        
        // Sous-catégorie titre
        $pdf->setFont('Helvetica','B',9);
        $pdf->SetFillColor(200, 220, 255);
        $pdf->cell(205,6,utf8_decode($designSousCat),1,0,'L',true);
        $pdf->Ln(6);
        
        // Requête pour récupérer les cours de cette sous-catégorie
        $reqCote = "SELECT tc.*, tcm.* FROM t_cours tc 
                   INNER JOIN t_cote_pri tcm ON tc.idCours = tcm.idCours 
                   WHERE tcm.idI = '$idI' AND tc.idSC = '$idSC'";
        $stmCote = $pdo->query($reqCote);
        
        $totalSousCatP1 = 0;
        $totalSousCatP2 = 0;
        $totalSousCatEx1 = 0;
        $totalSousCatP3 = 0;
        $totalSousCatP4 = 0;
        $totalSousCatEx2 = 0;
        $totalSousCatP5 = 0;
        $totalSousCatP6 = 0;
        $totalSousCatEx3 = 0;
        $totalSousCatMaxP = 0;
        $totalSousCatMaxEx = 0;
        
        while ($cotes = $stmCote->fetch()) {
            $pdf->setFont('Helvetica','',6);
            $pdf->cell(30,5,utf8_decode($cotes['designCours']),1,0,'L');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(7.5,5,($cotes['coteP1']==NULL) ? '' : $cotes['coteP1'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(7.5,5,($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(7.5,5,($cotes['coteP2']==NULL) ? '' : $cotes['coteP2'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(7.5,5,($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(5,5,($cotes['coteEx1']==NULL) ? '' : $cotes['coteEx1'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(5,5,($cotes['maxEx']==NULL) ? '' : $cotes['maxEx'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(5,5,($cotes['coteEx1'] == NULL || $cotes['coteP1'] == NULL || $cotes['coteP2'] == NULL) ? '' : ($cotes['coteP1'] + $cotes['coteP2'] + $cotes['coteEx1']),1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(5,5,($cotes['maxEx']==NULL || $cotes['maxPer'] == NULL) ? '' : ($cotes['maxPer'] * 2 + $cotes['maxEx']),1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(7.5,5,($cotes['coteP3']==NULL) ? '' : $cotes['coteP3'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(7.5,5,($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(7.5,5,($cotes['coteP4']==NULL) ? '' : $cotes['coteP4'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(7.5,5,($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(5,5,($cotes['coteEx2']==NULL) ? '' : $cotes['coteEx2'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(5,5,($cotes['maxEx']==NULL) ? '' : $cotes['maxEx'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(5,5,($cotes['coteEx2'] == NULL || $cotes['coteP3'] == NULL || $cotes['coteP4'] == NULL) ? '' : ($cotes['coteP3'] + $cotes['coteP4'] + $cotes['coteEx2']),1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(5,5,($cotes['maxEx']==NULL || $cotes['maxPer'] == NULL) ? '' : ($cotes['maxPer'] * 2 + $cotes['maxEx']),1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(7.5,5,($cotes['coteP5']==NULL) ? '' : $cotes['coteP5'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(7.5,5,($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(7.5,5,($cotes['coteP6']==NULL) ? '' : $cotes['coteP6'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(7.5,5,($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(5,5,($cotes['coteEx3']==NULL) ? '' : $cotes['coteEx3'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(5,5,($cotes['maxEx']==NULL) ? '' : $cotes['maxEx'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(5,5,($cotes['coteEx3'] == NULL || $cotes['coteP5'] == NULL || $cotes['coteP6'] == NULL) ? '' : ($cotes['coteP5'] + $cotes['coteP6'] + $cotes['coteEx3']),1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(5,5,($cotes['maxEx']==NULL || $cotes['maxPer'] == NULL) ? '' : ($cotes['maxPer'] * 2 + $cotes['maxEx']),1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(7.5,5,($cotes['coteP1'] + $cotes['coteP2'] + $cotes['coteEx1'] + $cotes['coteP3'] + $cotes['coteP4'] + $cotes['coteEx2'] + $cotes['coteP5'] + $cotes['coteP6'] + $cotes['coteEx3']),1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(7.5,5,(($cotes['maxPer'] * 2 + $cotes['maxEx'])*3),1,0,'C');
            $pdf->Ln(5);
            
            // Cumul des totaux pour cette sous-catégorie
            $totalSousCatP1 += ($cotes['coteP1'] == NULL) ? 0 : $cotes['coteP1'];
            $totalSousCatP2 += ($cotes['coteP2'] == NULL) ? 0 : $cotes['coteP2'];
            $totalSousCatEx1 += ($cotes['coteEx1'] == NULL) ? 0 : $cotes['coteEx1'];
            $totalSousCatP3 += ($cotes['coteP3'] == NULL) ? 0 : $cotes['coteP3'];
            $totalSousCatP4 += ($cotes['coteP4'] == NULL) ? 0 : $cotes['coteP4'];
            $totalSousCatEx2 += ($cotes['coteEx2'] == NULL) ? 0 : $cotes['coteEx2'];
            $totalSousCatP5 += ($cotes['coteP5'] == NULL) ? 0 : $cotes['coteP5'];
            $totalSousCatP6 += ($cotes['coteP6'] == NULL) ? 0 : $cotes['coteP6'];
            $totalSousCatEx3 += ($cotes['coteEx3'] == NULL) ? 0 : $cotes['coteEx3'];
            $totalSousCatMaxP += ($cotes['maxPer'] == NULL) ? 0 : $cotes['maxPer'];
            $totalSousCatMaxEx += ($cotes['maxEx'] == NULL) ? 0 : $cotes['maxEx'];
        }
        
        // Affichage des sous-totaux par sous-catégorie
        $pdf->setFont('Helvetica','B',7);
        $pdf->SetFillColor(240, 240, 240);
        $pdf->cell(30,5,'SOUS-TOTAL '.utf8_decode($designSousCat),1,0,'L',true);
        $pdf->cell(7.5,5,$totalSousCatP1,1,0,'C',true);
        $pdf->cell(7.5,5,$totalSousCatMaxP,1,0,'C',true);
        $pdf->cell(7.5,5,$totalSousCatP2,1,0,'C',true);
        $pdf->cell(7.5,5,$totalSousCatMaxP,1,0,'C',true);
        $pdf->cell(5,5,$totalSousCatEx1,1,0,'C',true);
        $pdf->cell(5,5,$totalSousCatMaxEx,1,0,'C',true);
        $pdf->cell(5,5,($totalSousCatP1 + $totalSousCatP2 + $totalSousCatEx1),1,0,'C',true);
        $pdf->cell(5,5,($totalSousCatMaxP*2 + $totalSousCatMaxEx),1,0,'C',true);
        $pdf->cell(7.5,5,$totalSousCatP3,1,0,'C',true);
        $pdf->cell(7.5,5,$totalSousCatMaxP,1,0,'C',true);
        $pdf->cell(7.5,5,$totalSousCatP4,1,0,'C',true);
        $pdf->cell(7.5,5,$totalSousCatMaxP,1,0,'C',true);
        $pdf->cell(5,5,$totalSousCatEx2,1,0,'C',true);
        $pdf->cell(5,5,$totalSousCatMaxEx,1,0,'C',true);
        $pdf->cell(5,5,($totalSousCatP3 + $totalSousCatP4 + $totalSousCatEx2),1,0,'C',true);
        $pdf->cell(5,5,($totalSousCatMaxP*2 + $totalSousCatMaxEx),1,0,'C',true);
        $pdf->cell(7.5,5,$totalSousCatP5,1,0,'C',true);
        $pdf->cell(7.5,5,$totalSousCatMaxP,1,0,'C',true);
        $pdf->cell(7.5,5,$totalSousCatP6,1,0,'C',true);
        $pdf->cell(7.5,5,$totalSousCatMaxP,1,0,'C',true);
        $pdf->cell(5,5,$totalSousCatEx3,1,0,'C',true);
        $pdf->cell(5,5,$totalSousCatMaxEx,1,0,'C',true);
        $pdf->cell(5,5,($totalSousCatP5 + $totalSousCatP6 + $totalSousCatEx3),1,0,'C',true);
        $pdf->cell(5,5,($totalSousCatMaxP*2 + $totalSousCatMaxEx),1,0,'C',true);
        $pdf->cell(7.5,5,($totalSousCatP1 + $totalSousCatP2 + $totalSousCatEx1 + $totalSousCatP3 + $totalSousCatP4 + $totalSousCatEx2 + $totalSousCatP5 + $totalSousCatP6 + $totalSousCatEx3),1,0,'C',true);
        $pdf->cell(7.5,5,(($totalSousCatMaxP*2 + $totalSousCatMaxEx)*3),1,0,'C',true);
        $pdf->Ln(5);
        
        // Cumul des totaux généraux
        $totalGeneralP1 += $totalSousCatP1;
        $totalGeneralP2 += $totalSousCatP2;
        $totalGeneralEx1 += $totalSousCatEx1;
        $totalGeneralP3 += $totalSousCatP3;
        $totalGeneralP4 += $totalSousCatP4;
        $totalGeneralEx2 += $totalSousCatEx2;
        $totalGeneralP5 += $totalSousCatP5;
        $totalGeneralP6 += $totalSousCatP6;
        $totalGeneralEx3 += $totalSousCatEx3;
        $totalGeneralMaxP += $totalSousCatMaxP;
        $totalGeneralMaxEx += $totalSousCatMaxEx;
    }
    
    // Affichage des totaux généraux
    $pdf->setFont('Helvetica','B',8);
    $pdf->SetFillColor(220, 220, 220);
    $pdf->cell(30,5,'TOTAUX GENERAUX',1,0,'L',true);
    $pdf->cell(7.5,5,$totalGeneralP1,1,0,'C',true);
    $pdf->cell(7.5,5,$totalGeneralMaxP,1,0,'C',true);
    $pdf->cell(7.5,5,$totalGeneralP2,1,0,'C',true);
    $pdf->cell(7.5,5,$totalGeneralMaxP,1,0,'C',true);
    $pdf->cell(5,5,$totalGeneralEx1,1,0,'C',true);
    $pdf->cell(5,5,$totalGeneralMaxEx,1,0,'C',true);
    $pdf->cell(5,5,($totalGeneralP1 + $totalGeneralP2 + $totalGeneralEx1),1,0,'C',true);
    $pdf->cell(5,5,($totalGeneralMaxP*2 + $totalGeneralMaxEx),1,0,'C',true);
    $pdf->cell(7.5,5,$totalGeneralP3,1,0,'C',true);
    $pdf->cell(7.5,5,$totalGeneralMaxP,1,0,'C',true);
    $pdf->cell(7.5,5,$totalGeneralP4,1,0,'C',true);
    $pdf->cell(7.5,5,$totalGeneralMaxP,1,0,'C',true);
    $pdf->cell(5,5,$totalGeneralEx2,1,0,'C',true);
    $pdf->cell(5,5,$totalGeneralMaxEx,1,0,'C',true);
    $pdf->cell(5,5,($totalGeneralP3 + $totalGeneralP4 + $totalGeneralEx2),1,0,'C',true);
    $pdf->cell(5,5,($totalGeneralMaxP*2 + $totalGeneralMaxEx),1,0,'C',true);
    $pdf->cell(7.5,5,$totalGeneralP5,1,0,'C',true);
    $pdf->cell(7.5,5,$totalGeneralMaxP,1,0,'C',true);
    $pdf->cell(7.5,5,$totalGeneralP6,1,0,'C',true);
    $pdf->cell(7.5,5,$totalGeneralMaxP,1,0,'C',true);
    $pdf->cell(5,5,$totalGeneralEx3,1,0,'C',true);
    $pdf->cell(5,5,$totalGeneralMaxEx,1,0,'C',true);
    $pdf->cell(5,5,($totalGeneralP5 + $totalGeneralP6 + $totalGeneralEx3),1,0,'C',true);
    $pdf->cell(5,5,($totalGeneralMaxP*2 + $totalGeneralMaxEx),1,0,'C',true);
    $pdf->cell(7.5,5,($totalGeneralP1 + $totalGeneralP2 + $totalGeneralEx1 + $totalGeneralP3 + $totalGeneralP4 + $totalGeneralEx2 + $totalGeneralP5 + $totalGeneralP6 + $totalGeneralEx3),1,0,'C',true);
    $pdf->cell(7.5,5,(($totalGeneralMaxP*2 + $totalGeneralMaxEx)*3),1,0,'C',true);
    $pdf->Ln(5);
    
    // Pourcentages
    $pdf->setFont('Helvetica','B',6);
    $pdf->cell(30,5,'POURCENTAGE ',1);
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(15,5,($totalGeneralMaxP==0) ? '' : round(($totalGeneralP1 / $totalGeneralMaxP) * 100, 2).' %',1,0,'C');
    $pdf->cell(15,5,($totalGeneralMaxP==0) ? '' : round(($totalGeneralP2 / $totalGeneralMaxP) * 100, 2).' %',1,0,'C');
    $pdf->cell(10,5,($totalGeneralMaxEx==0) ? '' : round(($totalGeneralEx1 / $totalGeneralMaxEx) * 100, 2).' %',1,0,'C');
    $totalTrim1 = $totalGeneralP1 + $totalGeneralP2 + $totalGeneralEx1;
    $totalMaxTrim1 = $totalGeneralMaxP*2 + $totalGeneralMaxEx;
    $pdf->cell(10,5,($totalMaxTrim1==0) ? '' : round(($totalTrim1 / $totalMaxTrim1) * 100, 2).' %',1,0,'C');
    $pdf->cell(15,5,($totalGeneralMaxP==0) ? '' : round(($totalGeneralP3 / $totalGeneralMaxP) * 100, 2).' %',1,0,'C');
    $pdf->cell(15,5,($totalGeneralMaxP==0) ? '' : round(($totalGeneralP4 / $totalGeneralMaxP) * 100, 2).' %',1,0,'C');
    $pdf->cell(10,5,($totalGeneralMaxEx==0) ? '' : round(($totalGeneralEx2 / $totalGeneralMaxEx) * 100, 2).' %',1,0,'C');
    $totalTrim2 = $totalGeneralP3 + $totalGeneralP4 + $totalGeneralEx2;
    $totalMaxTrim2 = $totalGeneralMaxP*2 + $totalGeneralMaxEx;
    $pdf->cell(10,5,($totalMaxTrim2==0) ? '' : round(($totalTrim2 / $totalMaxTrim2) * 100, 2).' %',1,0,'C');
    $pdf->cell(15,5,($totalGeneralMaxP==0) ? '' : round(($totalGeneralP5 / $totalGeneralMaxP) * 100, 2).' %',1,0,'C');
    $pdf->cell(15,5,($totalGeneralMaxP==0) ? '' : round(($totalGeneralP6 / $totalGeneralMaxP) * 100, 2).' %',1,0,'C');
    $pdf->cell(10,5,($totalGeneralMaxEx==0) ? '' : round(($totalGeneralEx3 / $totalGeneralMaxEx) * 100, 2).' %',1,0,'C');
    $totalTrim3 = $totalGeneralP5 + $totalGeneralP6 + $totalGeneralEx3;
    $totalMaxTrim3 = $totalGeneralMaxP*2 + $totalGeneralMaxEx;
    $pdf->cell(10,5,($totalMaxTrim3==0) ? '' : round(($totalTrim3 / $totalMaxTrim3) * 100, 2).' %',1,0,'C');
    $totalAnnee = $totalTrim1 + $totalTrim2 + $totalTrim3;
    $totalMaxAnnee = $totalMaxTrim1 + $totalMaxTrim2 + $totalMaxTrim3;
    $pdf->cell(15,5,($totalMaxAnnee==0) ? '0 %' : round(($totalAnnee / $totalMaxAnnee) * 100, 2).' %',1,0,'C');
    $pdf->Ln(5);
    
    // Place pour periode
    $placePer1 = getPlaceElevePriPer($pdo, $idI, $annee, 'P1', $idC);
    $placePer2 = getPlaceElevePriPer($pdo, $idI, $annee, 'P2', $idC);
    $placePer3 = getPlaceElevePriPer($pdo, $idI, $annee, 'P3', $idC);
    $placePer4 = getPlaceElevePriPer($pdo, $idI, $annee, 'P4', $idC);
    $placePer5 = getPlaceElevePriPer($pdo, $idI, $annee, 'P5', $idC);
    $placePer6 = getPlaceElevePriPer($pdo, $idI, $annee, 'P6', $idC);
    $placePer7 = getPlaceElevePriTrim1($pdo, $idI, $annee, $idC);
    $placePer8 = getPlaceElevePriTrim2($pdo, $idI, $annee, $idC);
    $placePer9 = getPlaceElevePriTrim3($pdo, $idI, $annee, $idC);
    $placePer10 = getPlaceElevePriFin($pdo, $idI, $annee, $idC);
    $pdf->setFont('Helvetica','B',6);
    $pdf->cell(30,5,'PLACE ',1);
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(15,5,($placePer1 === 1) ? "1er/".$totIns : (($placePer1 > 1) ? $placePer1 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(15,5,($placePer2 === 1) ? "1er/".$totIns : (($placePer2 > 1) ? $placePer2 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(10,5,'',1,0,'C',true);
    $pdf->cell(10,5,($placePer7 === 1) ? "1er/".$totIns : (($placePer7 > 1) ? $placePer7 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(15,5,($placePer3 === 1) ? "1er/".$totIns : (($placePer3 > 1) ? $placePer3 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(15,5,($placePer4 === 1) ? "1er/".$totIns : (($placePer4 > 1) ? $placePer4 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(10,5,'',1,0,'C',true);
    $pdf->cell(10,5,($placePer8 === 1) ? "1er/".$totIns : (($placePer8 > 1) ? $placePer8 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(15,5,($placePer5 === 1) ? "1er/".$totIns : (($placePer5 > 1) ? $placePer5 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(15,5,($placePer6 === 1) ? "1er/".$totIns : (($placePer6 > 1) ? $placePer6 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(10,5,'',1,0,'C',true);
    $pdf->cell(10,5,($placePer9 === 1) ? "1er/".$totIns : (($placePer9 > 1) ? $placePer9 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(15,5,($placePer10 === 1) ? "1er/".$totIns : (($placePer10 > 1) ? $placePer10 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->Ln(5);
    
    // Application
    $pdf->setFont('Helvetica','B',6);
    $pdf->cell(30,5,'APPLICATION ',1);
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(15,5,($totalGeneralMaxP==0) ? '' : calculateGrade(round(($totalGeneralP1 / $totalGeneralMaxP) * 100, 2)),1,0,'C');
    $pdf->cell(15,5,($totalGeneralMaxP==0) ? '' : calculateGrade(round(($totalGeneralP2 / $totalGeneralMaxP) * 100, 2)),1,0,'C');
    $pdf->cell(10,5,($totalGeneralMaxEx==0) ? '' : calculateGrade(round(($totalGeneralEx1 / $totalGeneralMaxEx) * 100, 2)),1,0,'C');
    $pdf->cell(10,5,($totalMaxTrim1==0) ? '' : calculateGrade(round(($totalTrim1 / $totalMaxTrim1) * 100, 2)),1,0,'C');
    $pdf->cell(15,5,($totalGeneralMaxP==0) ? '' : calculateGrade(round(($totalGeneralP3 / $totalGeneralMaxP) * 100, 2)),1,0,'C');
    $pdf->cell(15,5,($totalGeneralMaxP==0) ? '' : calculateGrade(round(($totalGeneralP4 / $totalGeneralMaxP) * 100, 2)),1,0,'C');
    $pdf->cell(10,5,($totalGeneralMaxEx==0) ? '' : calculateGrade(round(($totalGeneralEx2 / $totalGeneralMaxEx) * 100, 2)),1,0,'C');
    $pdf->cell(10,5,($totalMaxTrim2==0) ? '' : calculateGrade(round(($totalTrim2 / $totalMaxTrim2) * 100, 2)),1,0,'C');
    $pdf->cell(15,5,($totalGeneralMaxP==0) ? '' : calculateGrade(round(($totalGeneralP5 / $totalGeneralMaxP) * 100, 2)),1,0,'C');
    $pdf->cell(15,5,($totalGeneralMaxP==0) ? '' : calculateGrade(round(($totalGeneralP6 / $totalGeneralMaxP) * 100, 2)),1,0,'C');
    $pdf->cell(10,5,($totalGeneralMaxEx==0) ? '' : calculateGrade(round(($totalGeneralEx3 / $totalGeneralMaxEx) * 100, 2)),1,0,'C');
    $pdf->cell(10,5,($totalMaxTrim3==0) ? '' : calculateGrade(round(($totalTrim3 / $totalMaxTrim3) * 100, 2)),1,0,'C');
    $pdf->cell(15,5,($totalMaxAnnee==0) ? '' : calculateGrade(round(($totalAnnee / $totalMaxAnnee) * 100, 2)),1,0,'C');
    $pdf->Ln(5);
    
    // Conduite
    $pdf->setFont('Helvetica','B',6);
    $pdf->cell(30,5,'CONDUITE ',1);
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(15,5,($stmCond['P1']==NULL) ? '' : $stmCond['P1'],1,0,'C');
    $pdf->cell(15,5,($stmCond['P2']==NULL) ? '' : $stmCond['P2'],1,0,'C');
    $pdf->cell(10,5,'',1,0,'C',true);
    $pdf->cell(10,5,'',1,0,'C',true);
    $pdf->cell(15,5,($stmCond['P3']==NULL) ? '' : $stmCond['P3'],1,0,'C');
    $pdf->cell(15,5,($stmCond['P4']==NULL) ? '' : $stmCond['P4'],1,0,'C');
    $pdf->cell(10,5,'',1,0,'C',true);
    $pdf->cell(10,5,'',1,0,'C',true);
    $pdf->cell(15,5,($stmCond['P5']==NULL) ? '' : $stmCond['P5'],1,0,'C');
    $pdf->cell(15,5,($stmCond['P6']==NULL) ? '' : $stmCond['P6'],1,0,'C');
    $pdf->cell(10,5,'',1,0,'C',true);
    $pdf->cell(10,5,'',1,0,'C',true);
    $pdf->cell(15,5,'',1,0,'C',true);
    $pdf->Ln(5);

}elseif($sectionClasse=='Secondaire'){
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(40,15,utf8_decode("BRANCHES"),1,0,'C');
    $pdf->Setx(50);
    $pdf->cell(70,5,utf8_decode("PREMIER SEMESTRE"),1,0,'C');
    $pdf->cell(70,5,utf8_decode("SECOND SEMESTRE"),1,0,'C');
    $pdf->cell(15,15,utf8_decode("TOT GEN"),1,0,'C');
    $pdf->Setx(200);
    $pdf->Ln(5);
    $pdf->Setx(50);
    $pdf->cell(40,5,utf8_decode("TRAV.JOUR"),1,0,'C');
    $pdf->cell(15,10,utf8_decode("EXAM"),1,0,'C');
    $pdf->cell(15,10,utf8_decode("TOT"),1,0,'C');
    $pdf->cell(40,5,utf8_decode("TRAV.JOUR"),1,0,'C');
    $pdf->cell(15,10,utf8_decode("EXAM"),1,0,'C');
    $pdf->cell(15,10,utf8_decode("TOT"),1,0,'C');
    $pdf->Setx(164);
    $pdf->Ln(5);
    $pdf->Setx(50);
    $pdf->cell(20,5,utf8_decode("1èP"),1,0,'C');
    $pdf->cell(20,5,utf8_decode("2èP"),1,0,'C');
    $pdf->Setx(120);
    $pdf->cell(20,5,utf8_decode("3èP"),1,0,'C');
    $pdf->cell(20,5,utf8_decode("4èP"),1,0,'C');
    $pdf->Ln(5);

    // Regrouper les cours par sous-catégorie
    $sqlSubCat = "SELECT DISTINCT tsc.idSC, tsc.designSousCat 
               FROM t_sous_categ tsc 
               INNER JOIN t_cours tc ON tsc.idSC = tc.idSC
               INNER JOIN t_cote_sec tcm ON tc.idCours = tcm.idCours
               WHERE tcm.idI = '$idI'
               ORDER BY tsc.idSC";
    $stmSubCat = $pdo->query($sqlSubCat);
    
    //Conduites request
    $reqCond = "SELECT * FROM t_cond_sec INNER JOIN t_inscrit ON 
    t_inscrit.idI = t_cond_sec.idI INNER JOIN t_classe ON
    t_classe.idC = t_cond_sec.idC INNER JOIN t_an ON
    t_an.idA = t_cond_sec.idA WHERE t_inscrit.idI = '$idI'
    AND t_an.idA='$annee' AND t_classe.idC='$idC'";
    $stmCond=$pdo->query($reqCond)->fetch();
    
    $totalGeneralP1 = 0;
    $totalGeneralP2 = 0;
    $totalGeneralEx1 = 0;
    $totalGeneralP3 = 0;
    $totalGeneralP4 = 0;
    $totalGeneralEx2 = 0;
    $totalGeneralMaxP = 0;
    $totalGeneralMaxEx = 0;
    while ($subCat = $stmSubCat->fetch()) {
        $idSC = $subCat['idSC'];
        $designSousCat = $subCat['designSousCat'];
        
        // Sous-catégorie titre
        $pdf->setFont('Helvetica','B',9);
        $pdf->SetFillColor(200, 220, 255);
        $pdf->cell(195,6,utf8_decode($designSousCat),1,0,'L',true);
        $pdf->Ln(6);
        
        // Requête pour récupérer les cours de cette sous-catégorie
        $reqCote = "SELECT tc.*, tcm.* FROM t_cours tc 
                   INNER JOIN t_cote_sec tcm ON tc.idCours = tcm.idCours 
                   WHERE tcm.idI = '$idI' AND tc.idSC = '$idSC'";
        $stmCote = $pdo->query($reqCote);
        
        $totalSousCatP1 = 0;
        $totalSousCatP2 = 0;
        $totalSousCatEx1 = 0;
        $totalSousCatP3 = 0;
        $totalSousCatP4 = 0;
        $totalSousCatEx2 = 0;
        $totalSousCatMaxP = 0;
        $totalSousCatMaxEx = 0;
        
        while ($cotes = $stmCote->fetch()) {
            $pdf->setFont('Helvetica','',6);
            $pdf->cell(40,5,utf8_decode($cotes['designCours']),1,0,'L');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(10,5,($cotes['coteP1']==NULL) ? '' : $cotes['coteP1'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(10,5,($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(10,5,($cotes['coteP2']==NULL) ? '' : $cotes['coteP2'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(10,5,($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(7.5,5,($cotes['coteEx1']==NULL) ? '' : $cotes['coteEx1'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(7.5,5,($cotes['maxEx']==NULL) ? '' : $cotes['maxEx'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(7.5,5,($cotes['coteEx1'] == NULL || $cotes['coteP1'] == NULL || $cotes['coteP2'] == NULL) ? '' : ($cotes['coteP1'] + $cotes['coteP2'] + $cotes['coteEx1']),1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(7.5,5,($cotes['maxEx']==NULL || $cotes['maxPer'] == NULL) ? '' : ($cotes['maxPer'] * 2 + $cotes['maxEx']),1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(10,5,($cotes['coteP3']==NULL) ? '' : $cotes['coteP3'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(10,5,($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(10,5,($cotes['coteP4']==NULL) ? '' : $cotes['coteP4'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(10,5,($cotes['maxPer']==NULL) ? '' : $cotes['maxPer'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(7.5,5,($cotes['coteEx2']==NULL) ? '' : $cotes['coteEx2'],1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(7.5,5,($cotes['maxEx']==NULL) ? '' : $cotes['maxEx'],1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(7.5,5,($cotes['coteEx2'] == NULL || $cotes['coteP3'] == NULL || $cotes['coteP4'] == NULL) ? '' : ($cotes['coteP3'] + $cotes['coteP4'] + $cotes['coteEx2']),1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(7.5,5,($cotes['maxEx']==NULL || $cotes['maxPer'] == NULL) ? '' : ($cotes['maxPer'] * 2 + $cotes['maxEx']),1,0,'C');
            $pdf->setFont('Helvetica','',7);
            $pdf->cell(7.5,5,($cotes['coteP1'] + $cotes['coteP2'] + $cotes['coteEx1']+$cotes['coteP3'] + $cotes['coteP4'] + $cotes['coteEx2']),1,0,'C');
            $pdf->setFont('Helvetica','B',7);
            $pdf->cell(7.5,5,(($cotes['maxPer'] * 2 + $cotes['maxEx'])*2),1,0,'C');
            $pdf->Ln(5);
            
            // Cumul des totaux pour cette sous-catégorie
            $totalSousCatP1 += ($cotes['coteP1'] == NULL) ? 0 : $cotes['coteP1'];
            $totalSousCatP2 += ($cotes['coteP2'] == NULL) ? 0 : $cotes['coteP2'];
            $totalSousCatEx1 += ($cotes['coteEx1'] == NULL) ? 0 : $cotes['coteEx1'];
            $totalSousCatP3 += ($cotes['coteP3'] == NULL) ? 0 : $cotes['coteP3'];
            $totalSousCatP4 += ($cotes['coteP4'] == NULL) ? 0 : $cotes['coteP4'];
            $totalSousCatEx2 += ($cotes['coteEx2'] == NULL) ? 0 : $cotes['coteEx2'];
            $totalSousCatMaxP += ($cotes['maxPer'] == NULL) ? 0 : $cotes['maxPer'];
            $totalSousCatMaxEx += ($cotes['maxEx'] == NULL) ? 0 : $cotes['maxEx'];
        }
        
        // Affichage des sous-totaux par sous-catégorie
        $pdf->setFont('Helvetica','B',7);
        $pdf->SetFillColor(240, 240, 240);
        $pdf->cell(40,5,'SOUS-TOTAL ',1,0,'L',true);
        $pdf->cell(10,5,$totalSousCatP1,1,0,'C',true);
        $pdf->cell(10,5,$totalSousCatMaxP,1,0,'C',true);
        $pdf->cell(10,5,$totalSousCatP2,1,0,'C',true);
        $pdf->cell(10,5,$totalSousCatMaxP,1,0,'C',true);
        $pdf->cell(7.5,5,$totalSousCatEx1,1,0,'C',true);
        $pdf->cell(7.5,5,$totalSousCatMaxEx,1,0,'C',true);
        $pdf->cell(7.5,5,($totalSousCatP1 + $totalSousCatP2 + $totalSousCatEx1),1,0,'C',true);
        $pdf->cell(7.5,5,($totalSousCatMaxP*2 + $totalSousCatMaxEx),1,0,'C',true);
        $pdf->cell(10,5,$totalSousCatP3,1,0,'C',true);
        $pdf->cell(10,5,$totalSousCatMaxP,1,0,'C',true);
        $pdf->cell(10,5,$totalSousCatP4,1,0,'C',true);
        $pdf->cell(10,5,$totalSousCatMaxP,1,0,'C',true);
        $pdf->cell(7.5,5,$totalSousCatEx2,1,0,'C',true);
        $pdf->cell(7.5,5,$totalSousCatMaxEx,1,0,'C',true);
        $pdf->cell(7.5,5,($totalSousCatP3 + $totalSousCatP4 + $totalSousCatEx2),1,0,'C',true);
        $pdf->cell(7.5,5,($totalSousCatMaxP*2 + $totalSousCatMaxEx),1,0,'C',true);
        $pdf->cell(7.5,5,($totalSousCatP1 + $totalSousCatP2 + $totalSousCatEx1 + $totalSousCatP3 + $totalSousCatP4 + $totalSousCatEx2),1,0,'C',true);
        $pdf->cell(7.5,5,(($totalSousCatMaxP*2 + $totalSousCatMaxEx)*2),1,0,'C',true);
        $pdf->Ln(5);
        
        // Cumul des totaux généraux
        $totalGeneralP1 += $totalSousCatP1;
        $totalGeneralP2 += $totalSousCatP2;
        $totalGeneralEx1 += $totalSousCatEx1;
        $totalGeneralP3 += $totalSousCatP3;
        $totalGeneralP4 += $totalSousCatP4;
        $totalGeneralEx2 += $totalSousCatEx2;
        $totalGeneralMaxP += $totalSousCatMaxP;
        $totalGeneralMaxEx += $totalSousCatMaxEx;
    }
    
    // Affichage des totaux généraux
    $pdf->setFont('Helvetica','B',8);
    $pdf->SetFillColor(220, 220, 220);
    $pdf->cell(40,5,'TOTAUX GENERAUX',1,0,'L',true);
    $pdf->cell(10,5,$totalGeneralP1,1,0,'C',true);
    $pdf->cell(10,5,$totalGeneralMaxP,1,0,'C',true);
    $pdf->cell(10,5,$totalGeneralP2,1,0,'C',true);
    $pdf->cell(10,5,$totalGeneralMaxP,1,0,'C',true);
    $pdf->cell(7.5,5,$totalGeneralEx1,1,0,'C',true);
    $pdf->cell(7.5,5,$totalGeneralMaxEx,1,0,'C',true);
    $pdf->cell(7.5,5,($totalGeneralP1 + $totalGeneralP2 + $totalGeneralEx1),1,0,'C',true);
    $pdf->cell(7.5,5,($totalGeneralMaxP*2 + $totalGeneralMaxEx),1,0,'C',true);
    $pdf->cell(10,5,$totalGeneralP3,1,0,'C',true);
    $pdf->cell(10,5,$totalGeneralMaxP,1,0,'C',true);
    $pdf->cell(10,5,$totalGeneralP4,1,0,'C',true);
    $pdf->cell(10,5,$totalGeneralMaxP,1,0,'C',true);
    $pdf->cell(7.5,5,$totalGeneralEx2,1,0,'C',true);
    $pdf->cell(7.5,5,$totalGeneralMaxEx,1,0,'C',true);
    $pdf->cell(7.5,5,($totalGeneralP3 + $totalGeneralP4 + $totalGeneralEx2),1,0,'C',true);
    $pdf->cell(7.5,5,($totalGeneralMaxP*2 + $totalGeneralMaxEx),1,0,'C',true);
    $pdf->cell(7.5,5,($totalGeneralP1 + $totalGeneralP2 + $totalGeneralEx1 + $totalGeneralP3 + $totalGeneralP4 + $totalGeneralEx2),1,0,'C',true);
    $pdf->cell(7.5,5,(($totalGeneralMaxP*2 + $totalGeneralMaxEx)*2),1,0,'C',true);
    $pdf->Ln(5);
    
    // Pourcentages
    $pdf->setFont('Helvetica','B',6);
    $pdf->cell(40,5,'POURCENTAGE ',1);
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(20,5,($totalGeneralMaxP==0) ? '' : round(($totalGeneralP1 / $totalGeneralMaxP) * 100, 2).' %',1,0,'C');
    $pdf->cell(20,5,($totalGeneralMaxP==0) ? '' : round(($totalGeneralP2 / $totalGeneralMaxP) * 100, 2).' %',1,0,'C');
    $pdf->cell(15,5,($totalGeneralMaxEx==0) ? '' : round(($totalGeneralEx1 / $totalGeneralMaxEx) * 100, 2).' %',1,0,'C');
    $totalSem1 = $totalGeneralP1 + $totalGeneralP2 + $totalGeneralEx1;
    $totalMaxSem1 = $totalGeneralMaxP*2 + $totalGeneralMaxEx;
    $pdf->cell(15,5,($totalMaxSem1==0) ? '' : round(($totalSem1 / $totalMaxSem1) * 100, 2).' %',1,0,'C');
    $pdf->cell(20,5,($totalGeneralMaxP==0) ? '' : round(($totalGeneralP3 / $totalGeneralMaxP) * 100, 2).' %',1,0,'C');
    $pdf->cell(20,5,($totalGeneralMaxP==0) ? '' : round(($totalGeneralP4 / $totalGeneralMaxP) * 100, 2).' %',1,0,'C');
    $pdf->cell(15,5,($totalGeneralMaxEx==0) ? '' : round(($totalGeneralEx2 / $totalGeneralMaxEx) * 100, 2).' %',1,0,'C');
    $totalSem2 = $totalGeneralP3 + $totalGeneralP4 + $totalGeneralEx2;
    $totalMaxSem2 = $totalGeneralMaxP*2 + $totalGeneralMaxEx;
    $pdf->cell(15,5,($totalMaxSem2==0) ? '' : round(($totalSem2 / $totalMaxSem2) * 100, 2).' %',1,0,'C');
    $totalAnnee = $totalSem1 + $totalSem2;
    $totalMaxAnnee = $totalMaxSem1 + $totalMaxSem2;
    $pdf->cell(15,5,($totalMaxAnnee==0) ? '0 %' : round(($totalAnnee / $totalMaxAnnee) * 100, 2).' %',1,0,'C');
    $pdf->Ln(5);
    
    // Place pour période
    $placePer1 = getPlaceEleveSecPer($pdo, $idI, $annee, 'P1', $idC);
    $placePer2 = getPlaceEleveSecPer($pdo, $idI, $annee, 'P2', $idC);
    $placePer3 = getPlaceEleveSecPer($pdo, $idI, $annee, 'P3', $idC);
    $placePer4 = getPlaceEleveSecPer($pdo, $idI, $annee, 'P4', $idC);
    $placePer5 = getPlaceEleveSecTrim1($pdo, $idI, $annee, $idC);
    $placePer6 = getPlaceEleveSecTrim2($pdo, $idI, $annee, $idC);
    $placePer7 = getPlaceEleveSecFin($pdo, $idI, $annee, $idC);
    $pdf->setFont('Helvetica','B',6);
    $pdf->cell(40,5,'PLACE ',1);
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(20,5,($placePer1 === 1) ? "1er/".$totIns : (($placePer1 > 1) ? $placePer1 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(20,5,($placePer2 === 1) ? "1er/".$totIns : (($placePer2 > 1) ? $placePer2 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(15,5,'',1,0,'C',true);
    $pdf->cell(15,5,($placePer5 === 1) ? "1er/".$totIns : (($placePer5 > 1) ? $placePer5 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(20,5,($placePer3 === 1) ? "1er/".$totIns : (($placePer3 > 1) ? $placePer3 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(20,5,($placePer4 === 1) ? "1er/".$totIns : (($placePer4 > 1) ? $placePer4 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(15,5,'',1,0,'C',true);
    $pdf->cell(15,5,($placePer6 === 1) ? "1er/".$totIns : (($placePer6 > 1) ? $placePer6 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->cell(15,5,($placePer7 === 1) ? "1er/".$totIns : (($placePer7 > 1) ? $placePer7 . utf8_decode("è/").$totIns : ""),1,0,'C');
    $pdf->Ln(5);
    
    // Application
    $pdf->setFont('Helvetica','B',6);
    $pdf->cell(40,5,'APPLICATION ',1);
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(20,5,($totalGeneralMaxP==0) ? '' : calculateGrade(round(($totalGeneralP1 / $totalGeneralMaxP) * 100, 2)),1,0,'C');
    $pdf->cell(20,5,($totalGeneralMaxP==0) ? '' : calculateGrade(round(($totalGeneralP2 / $totalGeneralMaxP) * 100, 2)),1,0,'C');
    $pdf->cell(15,5,($totalGeneralMaxEx==0) ? '' : calculateGrade(round(($totalGeneralEx1 / $totalGeneralMaxEx) * 100, 2)),1,0,'C');
    $pdf->cell(15,5,($totalMaxSem1==0) ? '' : calculateGrade(round(($totalSem1 / $totalMaxSem1) * 100, 2)),1,0,'C');
    $pdf->cell(20,5,($totalGeneralMaxP==0) ? '' : calculateGrade(round(($totalGeneralP3 / $totalGeneralMaxP) * 100, 2)),1,0,'C');
    $pdf->cell(20,5,($totalGeneralMaxP==0) ? '' : calculateGrade(round(($totalGeneralP4 / $totalGeneralMaxP) * 100, 2)),1,0,'C');
    $pdf->cell(15,5,($totalGeneralMaxEx==0) ? '' : calculateGrade(round(($totalGeneralEx2 / $totalGeneralMaxEx) * 100, 2)),1,0,'C');
    $pdf->cell(15,5,($totalMaxSem2==0) ? '' : calculateGrade(round(($totalSem2 / $totalMaxSem2) * 100, 2)),1,0,'C');
    $pdf->cell(15,5,($totalMaxAnnee==0) ? '' : calculateGrade(round(($totalAnnee / $totalMaxAnnee) * 100, 2)),1,0,'C');
    $pdf->Ln(5);
    
    // Conduite
    $pdf->setFont('Helvetica','B',6);
    $pdf->cell(40,5,'CONDUITE ',1);
    $pdf->setFont('Helvetica','B',8);
    $pdf->cell(20,5,($stmCond['P1']==NULL) ? '' : $stmCond['P1'],1,0,'C');
    $pdf->cell(20,5,($stmCond['P2']==NULL) ? '' : $stmCond['P2'],1,0,'C');
    $pdf->cell(15,5,'',1,0,'C',true);
    $pdf->cell(15,5,'',1,0,'C',true);
    $pdf->cell(20,5,($stmCond['P3']==NULL) ? '' : $stmCond['P3'],1,0,'C');
    $pdf->cell(20,5,($stmCond['P4']==NULL) ? '' : $stmCond['P4'],1,0,'C');
    $pdf->cell(15,5,'',1,0,'C',true);
    $pdf->cell(15,5,'',1,0,'C',true);
    $pdf->cell(15,5,'',1,0,'C',true);
    $pdf->Ln(5);
    
    
    
}else{
    $pdf->cell(192,5,utf8_decode("IL Y A UNE ERREUR"),1,0,'C');
    $pdf->Ln(5);
}

// Footer
$pdf->Ln(15);
$pdf->setFont('Arial','I',9);
$pdf->Cell(65,10,utf8_decode('Sceau et Signature'),0,0,'L');
$pdf->Cell(65,10,utf8_decode('Le Titulaire'),0,0,'C');
$pdf->Cell(65,10,utf8_decode('Fait à Kananga, Le '.date('d-m-Y')),0,0,'R');

$formatname = "bulletin-" . date('dmYhis');
$pdf->Output('../uploads/pdf/' . $formatname . '.pdf', 'F');

header('Location: ../uploads/pdf/' . $formatname . '.pdf');
exit;
?>



