<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php"); 
date_default_timezone_set('Africa/Lubumbashi');

error_reporting(E_ALL); ini_set("display_errors", 1);

// Paramettre PRINT
$requeteParamPrint = "SELECT * FROM parprintmag WHERE idP";
$resultatPrint = $pdo->query($requeteParamPrint)->fetch();

// Requete print
$date1 = $_POST["date1"];
$date2 = $_POST["date2"];

$requeteUser = "SELECT * FROM approv 
    INNER JOIN medicament ON medicament.idM = approv.idM 
    INNER JOIN categorie ON medicament.idCat = categorie.idCat 
    WHERE dateA BETWEEN '$date1' AND '$date2'";
$rowCountRequete = $pdo->query($requeteUser)->rowCount();

if ($rowCountRequete === 0) {
    $msg_erreur = "Il n'y a pas d'informations à renvoyer sur ce rapport";
    header("Location:../Stock/approv.php?erreur=$msg_erreur");
    exit;
} else {
    $requeteSomme = "SELECT SUM(paEn * qteA) AS sommeFac FROM approv 
        INNER JOIN medicament ON medicament.idM = approv.idM 
        INNER JOIN categorie ON medicament.idCat = categorie.idCat 
        WHERE dateA BETWEEN '$date1' AND '$date2'";
    $resSomme = $pdo->query($requeteSomme)->fetch();
    $sommeFacture = $resSomme['sommeFac'];

    $image1 = "../uploads/" . $resultatPrint['log'];

    $pdf = new FPDF();
    $pdf->AddPage();
    $pdf->Image($image1, 5, $pdf->GetY(), 36.78);
    $pdf->setFont('Arial', 'B', 15);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->cell(0, 20, $resultatPrint['soc'], 0, 0, 'C');
    $pdf->Ln(15);
    $pdf->setFont('courier', '', 15);
    $pdf->cell(0, 4, $resultatPrint['ad'], 0, 0, 'C');
    $pdf->Ln(7);
    $pdf->cell(0, 4, $resultatPrint['pays'], 0, 0, 'C');
    $pdf->Ln(6);
    $pdf->cell(0, 4, 'Contact : ' . $resultatPrint['con'], 0, 0, 'C');
    $pdf->Ln(6);
    $pdf->cell(0, 4, 'Email : ' . $resultatPrint['em'], 0, 0, 'C');
    $pdf->Ln(10);
    $pdf->setFont('courier', 'B', 15);
    $pdf->cell(0, 4, 'LISTE DES ARTICLES APPROVISIONNES DANS LE MAGASIN', 0, 0, 'C');
    $pdf->Ln(6);
    $pdf->cell(0, 4, 'ENTRE LE ' . date('d-m-Y', strtotime($_POST["date1"])) . ' ET LE ' . date('d-m-Y', strtotime($_POST["date2"])), 0, 0, 'C');
    $pdf->Ln(6);

    $pdf->setFont('Arial', 'U', 15);
    $pdf->cell(55, 8, '', 0);
    $pdf->Ln(5);
    $pdf->setFont('Arial', 'B', 12);
    $pdf->cell(10, 7, utf8_decode('N°'), 1, 0, 'C');
    $pdf->cell(65, 7, 'PRODUIT', 1, 0, 'C');  // Augmenter la largeur de la colonne PRODUIT
    $pdf->cell(35, 7, 'EMPLACEMENT', 1, 0, 'C');
    $pdf->cell(20, 7, 'QTE', 1, 0, 'C');  // Diminuer la largeur de la colonne Quantité
    $pdf->cell(25, 7, 'PAU', 1, 0, 'C');  // Diminuer la largeur de la colonne PAU
    $pdf->cell(30, 7, 'DATE', 1, 0, 'C');
    $pdf->Ln(7);

    $pdf->setFont('courier', '', 9);

    $i = 1;
    $resultat = $pdo->query($requeteUser);
    while ($ins = $resultat->fetch()) {
        $pdf->cell(10, 7, $i++, 1, 0, 'C');
        $pdf->cell(65, 7, utf8_decode(substr($ins['design'], 0, 40)), 1, 0, 'L');  // Plus d'espace pour les noms des produits
        $pdf->cell(35, 7, utf8_decode(substr($ins['designCat'], 0, 20)), 1, 0, 'C');
        $pdf->cell(20, 7, utf8_decode($ins['qteA']), 1, 0, 'R');  // Ajustement pour QTE
        $pdf->cell(25, 7, utf8_decode(number_format($ins['paEn'], 2, '.', ' ')), 1, 0, 'R');  // Ajustement pour PAU
        $pdf->cell(30, 7, utf8_decode(date('d-m-Y', strtotime($ins["dateA"]))), 1, 0, 'R');
        $pdf->Ln(7);
    }

    $pdf->setFont('courier', 'B', 9);
    $pdf->cell(130, 7, '', 0);
    $pdf->cell(35, 7, 'TOTAL', 1);
    $pdf->cell(25, 7, number_format($sommeFacture, 2, '.', ' ') . ' FC', 1, 0, 'R');
    $pdf->Ln(7);

    $pdf->setFont('Arial', 'I', 9);
    $pdf->Cell(125);
    $pdf->Cell(0, 10, utf8_decode('Fait à ' . $resultatPrint['vil']) . ' Le ' . date('d-m-Y H:i:s') . ' ', 0, 0, 'C');
    $pdf->Ln(15);

    $formatname = "rapport-" . date('dmYhis');
    $uploadRep = "../uploads/pdfs/";
    $pdf->Output($uploadRep . $formatname . '.pdf', 'F');
    header('Location:' . $uploadRep . $formatname . '.pdf');
    exit;
}
?>
