<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php"); 

//Requete print
$date1=$_POST["date1"];
$date2=$_POST["date2"];

$requeteUser="SELECT * FROM conge INNER JOIN agent
ON agent.idA=conge.idA WHERE dateC BETWEEN 
 '$date1' AND '$date2' ORDER BY nomA ASC";
$rowCountRequete = $pdo->query($requeteUser)->rowCount();
if($rowCountRequete===0){
    #Message d'ERREUR
    $msg_erreur = "Il n'y a pas d'informations à renvoyer sur ce rapport";
    header("Location:../Admin/conge.php?erreur=$msg_erreur");
    exit;
}else{
    $res=$pdo->query($requeteUser)->fetch();

    $rowMedicament = $pdo->query($requeteUser)->rowCount();
    $numFac = sprintf('%04d', $rowMedicament);

 
    $image1 = "../uploads/logo.png";

    $pdf=new FPDF();
    $pdf->AddPage();
    $pdf->Image($image1, 5, $pdf->GetY(), 36.78);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,20,"REPUBLIQUE DEMOCRATIQUE DU CONGO",0,0,'C');
    $pdf->Ln(15);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,"MINISTERE DE L'ENSEIGNEMENT PRIMAIRE,",0,0,'C');
    $pdf->Ln(7);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,"SECONDAIRE ET TECHNIQUE",0,0,'C');
    $pdf->Ln(6);
    $pdf->setFont('courier','',15);
    $pdf->cell(0,4,"COMPLEXE SCOLAIRE LA RECONNAISSANCE",0,0,'C');
    $pdf->Ln(10);

    $pdf->SetFont('Arial','B',14);

    //Cell(width , height , text , border , end line , [align] )

    $pdf->Cell(130 ,5,'LISTE DE DIFFERENTS CONGES',0,0);

    //set font to arial, regular, 12pt
    $pdf->SetFont('Arial','',10);

    $pdf->Cell(59 ,5,'',0,1);//end of line

    $pdf->Cell(130 ,5,utf8_decode('Nombre de congés : ').$numFac,0,0);
    $pdf->Cell(25 ,5,'DATE 1 : ',0,0);
    $pdf->Cell(34 ,5,date('d-m-Y',strtotime($date1))." jusqu'au",0,1);//end of line

    $pdf->Cell(130 ,5,utf8_decode('Situation périodique'),0,0);
    $pdf->Cell(25 ,5,'DATE 2 : ',0,0);
    $pdf->Cell(34 ,5,date('d-m-Y',strtotime($date2)),0,1);//end of line

    $pdf->SetTextColor(0,0,0); 
    $pdf->setFont('Arial','U',15);
    $pdf->cell(55,8,'',0);
    $pdf->SetX(3);

    $pdf->cell(5,8,'',0);
    $pdf->Ln(10);
    $pdf->setFont('Arial','B',12);
    $pdf->cell(10,7,utf8_decode('N°'),1,0,'C');
    $pdf->cell(50,7,'AGENT',1,0,'C');
    $pdf->cell(55,7,'MOTIF',1,0,'C');
    $pdf->cell(25,7,'DEBUT',1,0,'C');
    $pdf->cell(25,7,'FIN',1,0,'C');
    $pdf->cell(30,7,'OPERATION',1,0,'C');
    $pdf->Ln(7);

    $pdf->setFont('courier','',9);

        $i=1;
        $resultat=$pdo->query($requeteUser);
        if(isset($_POST['date1']) && isset($_POST['date2'])){
            while ($ins=$resultat->fetch()) { 
                $pdf->cell(10,7, $i++,1,0,'C');
                $pdf->cell(50,7, utf8_decode(substr($ins['nomA'],0,25)),1);
                $pdf->cell(55,7, utf8_decode(substr($ins['motif'],0,27)),1);
                $pdf->cell(25,7, utf8_decode(date('d-m-Y',strtotime($ins['deb']))),1,0,'C');
                $pdf->cell(25,7, utf8_decode(date('d-m-Y',strtotime($ins['fin']))),1,0,'C');
                $pdf->cell(30,7, utf8_decode(date('d-m-Y',strtotime($ins['dateC']))),1,0,'C');
                $pdf->Ln(7);
            }
        }

    $pdf->setFont('Arial','I',9);
    //Décalage à droite
    $pdf->Cell(130);
    //Numéro de page
    $pdf->Cell(0,10,' FAIT A KANANGA Le '.date('d-m-Y A h:i:s A').' ',0,0,'C');
    
    $formatname = "liste-" . date('dmYhis');
    $pdf->Output('../uploads/pdf/' . $formatname . '.pdf', 'F');

    header('Location: ' . $urlopen . $formatname . '.pdf');
    exit;
}
?>

