<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php"); 
date_default_timezone_set('Africa/Lubumbashi');
//Paramettre PRINT
$requeteParamPrint="SELECT * FROM parprintmag WHERE idP";
$resultatPrint=$pdo->query($requeteParamPrint)->fetch();
//Requete print
$idC = $_GET['idC'];

$newEtat="1";
$sqlRed = "UPDATE commande SET etatC = ? WHERE idC=?";
$reqRed = $pdo->prepare($sqlRed);
$reqRed->execute([$newEtat,$idC]);

$requeteUser="SELECT * FROM detail_commande INNER JOIN commande 
ON commande.idC=detail_commande.idC INNER JOIN medicament 
ON medicament.idM=detail_commande.idM INNER JOIN client 
ON client.idClient = commande.idClient 
WHERE commande.idC='$idC' AND commande.statut='Proformat'
ORDER BY design ASC";
$rowCountRequete = $pdo->query($requeteUser)->rowCount();
if($rowCountRequete===0){
    #Message d'ERREUR
    $msg_erreur = "Veillez completez les acticles à cette facture";
    header("Location:../Stock/ventes.php?erreur=$msg_erreur");
    exit;
}else{
    $res=$pdo->query($requeteUser)->fetch();
    $nomC = $res['nom'];
    $tel = $res['telephone'];
    $add = $res['adresse'];
    $date = $res['dateC'];

    $requeteSomme="SELECT SUM(prixV*qte) AS sommeFac, SUM(qte) AS sommeQ FROM detail_commande
     INNER JOIN commande ON commande.idC=detail_commande.idC INNER JOIN medicament 
    ON medicament.idM=detail_commande.idM INNER JOIN client 
    ON client.idClient = commande.idClient WHERE commande.idC='$idC'";
    $resSomme=$pdo->query($requeteSomme)->fetch();
    $sommeFacture = $resSomme['sommeFac'];
    $sommeQ = $resSomme['sommeQ'];

    $reqCountCom = "SELECT * FROM commande";
    $rowCountCom = $pdo->query($reqCountCom)->rowCount();
    $numFac = sprintf('%04d', $rowCountCom);

    $image1 = "../uploads/".$resultatPrint['log'];

    $pdf=new FPDF();
    $pdf->AddPage();
    $pdf->Image($image1, 5, $pdf->GetY(), 36.78);
    $pdf->setFont('Arial','B',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,20,$resultatPrint['soc'],0,0,'C');
    $pdf->Ln(15);
    $pdf->setFont('courier','',15);
    $pdf->SetTextColor(0,0,0);
    $pdf->setFont('courier','',15);
    $pdf->cell(0,4,$resultatPrint['ad'],0,0,'C');
    $pdf->Ln(7);
    $pdf->SetTextColor(0,0,0);
    $pdf->setFont('courier','',15);
    $pdf->cell(0,4,$resultatPrint['pays'],0,0,'C');
    $pdf->Ln(6);
    $pdf->cell(0,4,'Contact : '.$resultatPrint['con'],0,0,'C');
    $pdf->Ln(6);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,'Email : '.$resultatPrint['em'],0,0,'C');
    $pdf->Ln(10);

    $pdf->SetFont('Arial','B',14);

    //Cell(width , height , text , border , end line , [align] )

    $pdf->Cell(130 ,5,'FACTURE PROFORMAT A',0,0);

    //set font to arial, regular, 12pt
    $pdf->SetFont('Arial','',10);

    $pdf->Cell(59 ,5,'',0,1);//end of line

    $pdf->Cell(130 ,5,utf8_decode(strtoupper($nomC)),0,0);
    $pdf->Cell(25 ,5,'DATE COM : ',0,0);
    $pdf->Cell(34 ,5,date('d-m-Y',strtotime($date)),0,1);//end of line

    $pdf->Cell(130 ,5,'Cont. '.$tel,0,0);
    $pdf->Cell(25 ,5,'FACTURE '.utf8_decode('N°').' ',0,0);
    $pdf->Cell(34 ,5,$numFac,0,1);//end of line

    $pdf->Cell(130 ,5,'AD. '.$add,0,0);

    $pdf->SetTextColor(0,0,0); 
    $pdf->setFont('Arial','U',15);
    $pdf->cell(55,8,'',0);
    $pdf->SetX(3);

    $pdf->cell(5,8,'',0);
    $pdf->Ln(10);
    $pdf->setFont('Arial','B',12);
    $pdf->cell(10,7,utf8_decode('N°'),1,0,'C');
    $pdf->cell(85,7,'PRODUIT',1,0,'C');
    $pdf->cell(35,7,'PRIX',1,0,'C');
    $pdf->cell(25,7,'QTE',1,0,'C');
    $pdf->cell(45,7,'PRIX TOTAL',1,0,'C');
    $pdf->Ln(7);

    $pdf->setFont('Arial','',15);

        $i=1;
        $resultat=$pdo->query($requeteUser);
        while ($ins=$resultat->fetch()) { 
            $pdf->cell(10,7, $i++,1,0,'C');
            $pdf->cell(85,7, utf8_decode(substr($ins['design'],0,26)),1);
            $pdf->cell(35,7, utf8_decode(number_format($ins['prixV'],2,'.',' ')),1,0,'R');
            $pdf->cell(25,7, utf8_decode($ins['qte']),1,0,'R');
            $pdf->cell(45,7, utf8_decode(number_format($ins['qte']*$ins['prixV'],2,'.',' ')),1,0,'R');
            $pdf->Ln(7);
        }

    $pdf->setFont('Arial','B',10);
    $pdf->cell(95,7,'',0);
    $pdf->cell(35,7,'QUANTITES',1);
    $pdf->setFont('Arial','B',17);
    $pdf->cell(70,7,number_format($sommeQ,2,'.',' '),1,0,'R');
    $pdf->Ln(7);
    $pdf->cell(95,7,'',0);
    $pdf->setFont('Arial','B',10);
    $pdf->cell(35,7,'TOTAL FACTURE',1);
    $pdf->setFont('Arial','B',17);
    $pdf->cell(70,7,number_format($sommeFacture,2,'.',' ').' FC',1,0,'R');
    $pdf->Ln(7);
    
    $pdf->setFont('Arial','I',11);
    //Décalage à droite
    $pdf->Cell(110);
    //Numéro de page
    $pdf->Cell(0,10,utf8_decode('Fait à '.$resultatPrint['vil']).' Le '.date('d-m-Y H:i:s').' ',0,0,'C');
    $pdf->Ln(15);
    $pdf->setFont('Arial','',12);
    $pdf->SetTextColor(0,0,0);
    $pdf->cell(0,4,'LES MARCHANDISES VENDUES NE SONT NI REPRISE NI ECHANGEES, VEILLEZ VERIFIER',0,0,'C');
    $pdf->Ln(5);
    $pdf->cell(0,4,'LES MARCHANDISES A LA RECEPTION; PREPARED BY '.$resultatPrint['man'],0,0,'C');
    
    $formatname = "facture-" . date('dmYhis');
    $uploadRep = "../uploads/pdfs/";
    $pdf->Output($uploadRep . $formatname . '.pdf', 'F');
    header('Location:' . $uploadRep . $formatname . '.pdf');
    exit;
}
?>

