<?php
session_start();
require_once('../include/pdf/fpdf.php');
require_once("../include/connexiondb.php");

$idI = isset($_POST['idI']) ? $_POST['idI'] : null;

if ($idI === null) {
    // Ajoutez un script JavaScript pour revenir à la page précédente
    echo "<script>
   setTimeout(function() {
       window.history.back();
   }, 0); // 0 milliseconde
 </script>";
} else {
    $requeteCarte = "SELECT * FROM t_inscrit INNER JOIN t_classe 
ON t_inscrit.idC=t_classe.idC INNER JOIN t_option ON 
t_classe.idO=t_option.idO INNER JOIN t_an ON
t_inscrit.idA=t_an.idA WHERE t_inscrit.idI='$idI'";
    $res = $pdo->query($requeteCarte)->fetch();
    $numMat = $res['numMat'];
    $nom = $res['nom'];
    $sexe = $res['sexe'];
    $ln = $res['ln'];
    $dn = $res['dn'];
    $designA = $res['designA'];
    $design = $res['design'] . ' ' . $res['designO'] . ' ' . $res['ord'];
    $photo = $res['photo'];
    $qrCodeEtu = 'ELEVEQRC-' . $res['idI'] . '.png';
    // Create new object.
    $pdf = new FPDF('l', 'mm', array(85, 50));
    //RECTO
    $pdf->AddPage();
    $pdf->setFont('Arial', '', 6);
    $pdf->SetTextColor(0, 0, 0);
    $pdf->cell(0, -15, 'REPUBLIQUE DEMOCRATIQUE DU CONGO', 0, 0, 'C');
    $pdf->Ln(3);
    $pdf->setFont('Arial', '', 6);
    $pdf->cell(0, -15, "MINISTERE DE L'ENSEIGNEMENT PRIMAIRE, SECONDAIRE ET TECHNIQUE", 0, 0, 'C');
    $pdf->Ln(3);
    $pdf->setFont('Arial', 'B', 8);
    $pdf->cell(0, -15, "COMPLEXE SCOLAIRE LA RECONNAISSANCE", 0, 0, 'C');
    $pdf->Line(0, 11, 270 - 50, 11);
    $pdf->Line(0, 40, 80 - 4, 40);
    $pdf->Ln(3);
    $pdf->Image('../uploads/' . $photo, 1, 13, 23, 25);
    $pdf->cell(14, 8, '', 0);
    $pdf->setFont('Arial', '', 7);
    $pdf->cell(0, -10, "Matricule : " . $numMat, 0, 0, 'L');
    $pdf->Ln(3);
    $pdf->cell(14, -8, '', 0);
    $pdf->cell(0, -10, "Noms : " . utf8_decode($nom), 0, 0, 'L');
    $pdf->Ln(3);
    $pdf->cell(14, -8, '', 0);
    $pdf->cell(0, -10, "Sexe : " . utf8_decode($sexe), 0, 0, 'L');
    $pdf->Ln(3);
    $pdf->cell(14, -8, '', 0);
    $pdf->cell(0, -10, "Lieu de naissance : " . utf8_decode($ln), 0, 0, 'L');
    $pdf->Ln(3);
    $pdf->cell(14, -8, '', 0);
    $pdf->cell(0, -10, "Date de naissance : " . date('d/m/Y', strtotime($dn)), 0, 0, 'L');
    $pdf->Ln(3);
    $pdf->cell(14, -8, '', 0);
    $pdf->cell(0, -10, "Classe : " . utf8_decode($design), 0, 0, 'L');
    $pdf->Ln(3);
    $pdf->cell(14, -8, '', 0);
    $pdf->cell(0, -10, "Annee Scol : " . $designA, 0, 0, 'L');
    //QrCode
    if (file_exists('../uploads/' . $qrCodeEtu) && is_file('../uploads/' . $qrCodeEtu)) {
        $info = getimagesize('../uploads/' . $qrCodeEtu);
        if ($info !== false && $info['mime'] == 'image/png') {
            $pdf->Image('../uploads/' . $qrCodeEtu, 65, 30, 19, 19);
        } else {
            $pdf->Rect(65, 30, 19, 19, 'F');
        }
    }
    // $pdf->Image('../uploads/' . $qrCodeEtu, 65, 30, 19, 19);
    //VERSO
    $pdf->AddPage();
    $pdf->Image('../uploads/carteVerso.png', 0, 0, 85, 50);

    $formatname = "carteeleve-" . date('dmYhis');
    $pdf->Output('../uploads/pdf/' . $formatname . '.pdf', 'F');

    header('Location: ' . $urlopen . $formatname . '.pdf');
    exit;
}
