<?php
session_start();
if (!isset($_SESSION["login"]) && !isset($_SESSION['etat'])) {
  header('Location:../index.php');
}

require_once('../include/connexiondb.php');

//Situation Créances
$des2 = isset($_GET['des2']) ? $_GET['des2'] : "";
$page_no2 = isset($_GET['page_no2']) ? $_GET['page_no2'] : 1;
$total_records_per_page2 = 15;
$offset2 = ($page_no2 - 1) * $total_records_per_page2;
$previous_page2 = $page_no2 - 1;
$next_page2 = $page_no2 + 1;
$adjacents2 = "2";

$requeteRecord2 = "SELECT count(*) AS total_records 
FROM mouv_credit INNER JOIN commande ON commande.idC=mouv_credit.idC
INNER JOIN client ON client.idClient=commande.idClient 
WHERE nom like '%$des2%'";
$total_records2 = $pdo->query($requeteRecord2)->fetch();
$total_records2 = $total_records2['total_records'];
$total_no_of_pages2 = ceil($total_records2 / $total_records_per_page2);
$second_last2 = $total_no_of_pages2 - 1;

$requeteCredit = "SELECT * FROM mouv_credit INNER JOIN 
commande ON commande.idC=mouv_credit.idC
INNER JOIN client ON client.idClient=commande.idClient  WHERE nom like '%$des2%'
 ORDER BY dateCreance ASC LIMIT $offset2, $total_records_per_page2";
$resultatCreances = $pdo->query($requeteCredit);

?>
<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_stockagent.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#gest-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Gestions</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="gest-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="clients.php">
              <i class="bi bi-circle"></i><span>Clients</span>
            </a>
          </li>
          <li>
            <a href="fourn.php">
              <i class="bi bi-circle"></i><span>Fournisseurs</span>
            </a>
          </li>
          <li>
            <a href="categ.php">
              <i class="bi bi-circle"></i><span>Catégories</span>
            </a>
          </li>
        </ul>
      </li><!-- End Gestions Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="med.php">
          <i>&#9764;</i>
          <span>Stock Produit</span>
        </a>
      </li><!-- End stock Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="investis.php">
          <i class="bi bi-snow2"></i>
          <span>Stock Investi</span>
        </a>
      </li><!-- End Stock Investi Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="approv.php">
          <i class="bi bi-cart4"></i>
          <span>Approvisionnement</span>
        </a>
      </li><!-- End Approv Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="ventes.php">
          <i class="bi bi-cart-fill"></i>
          <span>Ventes</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link" href="serv_cre.php">
          <i class="bi bi-activity"></i>
          <span>Suivi des Créances</span>
        </a>
      </li><!-- End Créances Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="dep.php">
          <i class="bi bi-plus-slash-minus"></i>
          <span>Dépenses</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="requis.php">
          <i class="bi bi-stack"></i>
          <span>Requisition</span>
        </a>
      </li><!-- End Requisition Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="invet.php">
          <i class="bi bi-stickies-fill"></i>
          <span>Inventaire</span>
        </a>
      </li><!-- End Inventaire Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="analyse.php">
          <i class="bi bi-slack"></i>
          <span>Analyse</span>
        </a>
      </li><!-- End Analyse Page Nav -->

    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Situation de différentes créances</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
          <li class="breadcrumb-item active">Situation de différentes créances</li>
        </ol>
      </nav>
      <!-- Message d'erreur -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
          <div class="alert alert-warning" role="alert">
            <?php echo htmlspecialchars($_GET['erreur']); ?>
          </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
          <div class="alert alert-success" role="alert">
            <?php echo htmlspecialchars($_GET['succes']); ?>
          </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">
        <!-- TAbele data -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Situation de créances des clients <span>| <a data-bs-toggle="modal" data-bs-target="#modalPrintTotCreances" class="btn btn-warning"><i class="bi bi-printer-fill"></i> IMPRIMER</a> </span></h5>

                  <form method="get" action="serv_cre.php" class="searchform js__toggle">
                    <div class="input-group has-validation">
                      <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                      <input type="text" name="des2" placeholder="Search..." class="form-control">
                      <button class="bi bi-search btn btn-info" type="submit"></button>
                    </div>
                  </form>
                  <table class="table">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Client</th>
                        <th scope="col">Payé</th>
                        <th scope="col">Reste</th>
                        <th scope="col">Cumul</th>
                        <th scope="col">Date</th>
                        <th scope="col">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      $nombre = 1;
                      while ($dataCreances = $resultatCreances->fetch()) {
                      ?>

                        <tr>
                          <td scope="row"><?php echo $nombre ?></td>
                          <td><?php echo $dataCreances['nom'] ?></td>
                          <td><span class="btn btn-primary"><?php echo $dataCreances['montant'] . ' FC' ?></span></td>
                          <td><span class="btn btn-danger"><?php echo  $dataCreances['reste'] . ' FC' ?></span></td>
                          <td><span class="btn btn-success"><?php echo $dataCreances['montant'] + $dataCreances['reste'] . ' FC' ?></span></td>
                          <td><?php echo date('d-m-Y', strtotime($dataCreances['dateCreance'])) ?></td>
                          <td>
                            <a data-bs-toggle="modal" data-bs-target="#modalPrintOneCreance<?php echo $dataCreances['idClient'] ?>" class="btn btn-info"><span class="bi bi-printer-fill"></span> </a>
                            &nbsp;
                            <a data-bs-toggle="modal" data-bs-target="#modalPrintOneRecuCreance<?php echo $dataCreances['idMCred'] ?>" class="btn btn-warning"><span class="bi bi-printer-fill"></span> </a>
                          </td>
                        </tr>
                      <?php $nombre++;
                        include('modal_include/ModalmodifierMed.php');
                      } ?>
                    </tbody>
                  </table>

                  <ul class="pagination">
                    <?php // if($page_no > 1){ echo "<li><a href='?page_no=1'>First Page</a></li>"; } 
                    ?>

                    <li <?php if ($page_no2 <= 1) {
                          echo "class=' page-item disabled'";
                        } ?>>
                      <a class='page-link prevnext' <?php if ($page_no2 > 1) {
                                                      echo "href='serv_cre.php?page_no2=$previous_page2&des2=$des2'";
                                                    } ?>>Previous</a>
                    </li>

                    <?php
                    if ($total_no_of_pages2 <= 10) {
                      for ($counter2 = 1; $counter2 <= $total_no_of_pages2; $counter2++) {
                        if ($counter2 == $page_no2) {
                          echo "<li class='active class='page-item''><a class='page-link'>$counter2</a></li>";
                        } else {
                          echo "<li class='page-item'><a class='page-link' href='serv_cre.php?page_no2=$counter2&des2=$des2'>$counter2</a></li>";
                        }
                      }
                    } elseif ($total_no_of_pages2 > 10) {

                      if ($page_no2 <= 4) {
                        for ($counter2 = 1; $counter2 < 8; $counter2++) {
                          if ($counter2 == $page_no2) {
                            echo "<li class='page-item active'><a class='page-link'>$counter2</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='serv_cre.php?page_no2=$counter2&des2=$des2'>$counter2</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='serv_cre.php?page_no2=$second_last2&des2=$des2'>$second_last2</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='serv_cre.php?page_no2=$total_no_of_pages2&des2=$des2'>$total_no_of_pages2</a></li>";
                      } elseif ($page_no2 > 4 && $page_no2 < $total_no_of_pages2 - 4) {
                        echo "<li class='page-item'><a class='page-link' href='serv_cre.php?page_no2=1&des2=$des2'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='serv_cre.php?page_no2=2&des2=$des2'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        for ($counter2 = $page_no2 - $adjacents2; $counter2 <= $page_no2 + $adjacents2; $counter2++) {
                          if ($counter2 == $page_no2) {
                            echo "<li class='active'><a class='page-link'>$counter2</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='serv_cre.php?page_no2=$counter2&des2=$des2'>$counter2</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='serv_cre.php?page_no2=$second_last2'&des2=$des2>$second_last2</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='serv_cre.php?page_no2=$total_no_of_pages2&des2=$des2'>$total_no_of_pages2</a></li>";
                      } else {
                        echo "<li class='page-item'><a class='page-link' href='serv_cre.php?page_no2=1&des2=$des2'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='serv_cre.php?page_no2=2&des2=$des2'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";

                        for ($counter2 = $total_no_of_pages2 - 6; $counter2 <= $total_no_of_pages2; $counter2++) {
                          if ($counter2 == $page_no2) {
                            echo "<li class='page-item active'><a class='page-link'>$counter2</a></li>";
                          } else {
                            echo "<li  class='page-item'><a class='page-link' href='serv_cre.php?page_no2=$counter2&des2=$des2'>$counter2</a></li>";
                          }
                        }
                      }
                    }
                    ?>

                    <li <?php if ($page_no2 >= $total_no_of_pages2) {
                          echo "class='disabled page-item'";
                        } ?>>
                      <a class='page-link prevnext' <?php if ($page_no2 < $total_no_of_pages2) {
                                                      echo "href='serv_cre.php?page_no2=$next_page2'";
                                                    } ?>>Next</a>
                    </li>
                    <?php if ($page_no2 < $total_no_of_pages2) {
                      echo "<li class='page-item'><a class='page-link prevnext' href='serv_cre.php?page_no2=$total_no_of_pages2'>Last &rsaquo;&rsaquo;</a></li>";
                    } ?>
                  </ul>
                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->
      </div>
    </section>

  </main><!-- End #main -->

  <!-- MES DIFFERENTS MODALES -->
  <!-- MODAL ADD SERVICE -->
  <div class="modal fade" id="modalPrintTotCreances" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Print toutes les situations des créances</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="../include/situationGenCreance.php" target="_blank" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

            <div class="row mb-3">

              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Première Date</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-alarm-fill"></i></span>
                  <input type="date" name="date1" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez choisir la Date SVP !</div>
                </div>
              </div>

              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Seconde Date</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-alarm-fill"></i></span>
                  <input type="date" name="date2" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez choisir la Date SVP !</div>
                </div>
              </div>
            </div>

            <div class="modal-footer">
              <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
              <button type="submit" name="addMedBtn" onclick="document.fo.submit()" class="btnModSave">IMPRIMER</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal ADD SERVICE-->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>