<?php
    session_start();
    require_once('../../include/connexiondb.php');
    if (
        isset($_POST['idM']) && 
        isset($_POST['idC']) &&
        isset($_POST['idDC']) &&
        isset($_POST['q']) &&
        isset($_POST['p']) &&
        isset($_POST['qte'])
    ) {
        //Les variables
        $idDC = $_POST['idDC'];
        $idM = $_POST['idM'];
        $idC = $_POST['idC'];
        $q = $_POST['q']; 
        $p = $_POST['p']; 
        $qte = $_POST['qte'];
        $montantCa_mod = $q*$p;

        //Ajout de la quantité detail dans Stock Medoc
        $sqlProd = "SELECT * FROM medicament WHERE idM = ?";
        $reqProd = $pdo->prepare($sqlProd);
        $reqProd->execute([$idM]);
        $resProd = $reqProd->fetch();
        $stockProd = $resProd['stock'];
        $designM = $resProd['design'];
        $stockAjustement = $stockProd + $q;
        $sqlPremAjust = "UPDATE medicament SET `stock`=? WHERE `idM`=?";
        $reqPremAjust = $pdo->prepare($sqlPremAjust);
        $reqPremAjust->execute([$stockAjustement,$idM]);

        //Update Credit Table
        $sqlCred = "SELECT * FROM credit INNER JOIN commande
        ON credit.idC=commande.idC WHERE commande.idC = ? 
        AND commande.statut = ? ";
        $reqCred = $pdo->prepare($sqlCred);
        $reqCred->execute(['Credit',$idC]);
        $resCred = $reqCred->fetch();
        $mCred = $resCred['mCred'];
        $montantCreditTot = $mCred - $montantCa_mod;
        $sql = "UPDATE credit SET `mCred`=?
        WHERE `idC`=?";
        $req = $pdo->prepare($sql);
        $req->execute([$montantCreditTot,$idC]);

        //Modifier Caisse et CA
        $sqlca_mod = "SELECT * FROM ca WHERE idDC = ?";
        $reqca_mod = $pdo->prepare($sqlca_mod);
        $reqca_mod->execute([$idDC]);
        $resca_mod = $reqca_mod->fetch();
        $m_ca_mod = $resca_mod['m_ca'];

        $m_ca_actuel_mod = $m_ca_mod - $montantCa_mod;

        $sql = "UPDATE ca SET `m_ca`=? WHERE `idDC`=?";
        $req = $pdo->prepare($sql);
        $req->execute([$m_ca_actuel_mod,$idDC]);

        $sqlRec_mod = "SELECT * FROM caisse WHERE idCaisse = ?";
        $reqRec_mod = $pdo->prepare($sqlRec_mod);
        $reqRec_mod->execute([1]);
        $resRech_mod = $reqRec_mod->fetch();
        $ventes_mod = $resRech_mod['ventes'];
        $depenses_mod = $resRech_mod['depenses'];
        $creances_mod = $resRech_mod['creances'];

        $vente_actuelle_mod = $ventes_mod - $montantCa_mod;
        $Net_mod = $vente_actuelle_mod - $depenses_mod - $creances_mod;

        $sql_mod = "UPDATE caisse SET `ventes`=? , `net`= ? WHERE `idCaisse`=?";
        $req_mod = $pdo->prepare($sql_mod);
        $req_mod->execute([$vente_actuelle_mod,$Net_mod,1]);

        //Mon algo
        $sqlStockMedicament = "SELECT * FROM medicament WHERE idM = ?";
        $reqStockMedicament = $pdo->prepare($sqlStockMedicament);
        $reqStockMedicament->execute([$idM]);
        $resStockMedicament = $reqStockMedicament->fetch();
        $designM = $resStockMedicament['design'];
        $stock = $resStockMedicament['stock'];
        $stockMin = 0;
        $pvEnStock = $resStockMedicament['pvg'];

        $sql = "SELECT * FROM detail_commande 
            INNER JOIN commande ON commande.idC=detail_commande.idC 
            INNER JOIN medicament ON medicament.idM=detail_commande.idM 
            WHERE detail_commande.idC=? AND medicament.idM=?";
        $req = $pdo->prepare($sql);
        $req->execute([$idC,$idM]);
        $res = $req->fetch();
        $qteDetail = $res['qte'];
        $stockDetail = $res['stock'];

        if ($qte >= $stock) {
             //Ajout de la quantité detail dans Stock Medoc
            $sqlProd = "SELECT * FROM medicament WHERE idM = ?";
            $reqProd = $pdo->prepare($sqlProd);
            $reqProd->execute([$idM]);
            $resProd = $reqProd->fetch();
            $stockProd = $resProd['stock'];
            $stockAjustement = $stockProd - $q;
            $sqlPremAjust = "UPDATE medicament SET `stock`=? WHERE `idM`=?";
            $reqPremAjust = $pdo->prepare($sqlPremAjust);
            $reqPremAjust->execute([$stockAjustement,$idM]);

            $msg_erreur = "La quantité en stock pour ".$designM." est insuffisante pour cette commande";
            header("Location:../detail_vente.php?idC=$idC&erreur=$msg_erreur");
            exit;
        } elseif ($stock <= $stockMin) {
            $msg_erreur = "Vous êtes en rupture de stock pour ".$designM."";
            header("Location:../detail_vente.php?idC=$idC&erreur=$msg_erreur");
        }else{
            //Req commande
            $sqlcOM = "SELECT * FROM commande WHERE idC = ?";
            $reqCom = $pdo->prepare($sqlcOM);
            $reqCom->execute([$idC]);
            $resCom = $reqCom->fetch();
            $sta = $resCom['statut'];

            if($sta=="Cash"){
                # Insertion des données dans la table 
                $stockModif = $stock - $qte;
                $sql = "UPDATE detail_commande SET `qte`=?,`soldeIS`=?,`soldeS`=? WHERE `idDC`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$qte,$stock,$stockModif,$idDC]);

                # Insertion des données dans la table 
                $sql = "UPDATE medicament SET `stock`=? WHERE `idM`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$stockModif,$idM]);

                # update des données dans la table  caisse et ca
                $sqlca = "SELECT * FROM ca WHERE idDC = ?";
                $reqca = $pdo->prepare($sqlca);
                $reqca->execute([$idDC]);
                $resca = $reqca->fetch();
                $m_ca = $resca['m_ca'];

                $montantCa = $qte*$p;

                $m_ca_actuel = $m_ca + $montantCa;
            
                $sql = "UPDATE ca SET `m_ca`=? WHERE `idDC`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$m_ca_actuel,$idDC]);

                $sqlRec = "SELECT * FROM caisse WHERE idCaisse = ?";
                $reqRec = $pdo->prepare($sqlRec);
                $reqRec->execute([1]);
                $resRech = $reqRec->fetch();
                $ventes = $resRech['ventes'];
                $depenses = $resRech['depenses'];
                $creances = $resRech['creances'];

                $vente_actuelle = $ventes + $montantCa;
                $Net = $vente_actuelle - $depenses - $creances;

                $sql = "UPDATE caisse SET `ventes`=? , `net`= ? WHERE `idCaisse`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$vente_actuelle,$Net,1]);

            }elseif($sta=="Credit"){
                # Insertion des données dans la table 
                $stockModif = $stock - $qte;
                $sql = "UPDATE detail_commande SET `qte`=?,`soldeIS`=?,`soldeS`=? WHERE `idDC`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$qte,$stock,$stockModif,$idDC]);

                $montantCa = $qte*$p;

                //Update Credit Table
                $sqlCred = "SELECT * FROM credit WHERE idC = ?";
                $reqCred = $pdo->prepare($sqlCred);
                $reqCred->execute([$idC]);
                $resCred = $reqCred->fetch();
                $mCred = $resCred['mCred'];
                $montantCreditTot = $mCred - $montantCa;
                $sql = "UPDATE credit SET `mCred`=?
                WHERE `idC`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$montantCreditTot,$idC]);
                
                # Insertion des données dans la table 
                $sql = "UPDATE medicament SET `stock`=? WHERE `idM`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$stockModif,$idM]);

                # update des données dans la table  caisse
                $sqlRec = "SELECT * FROM caisse WHERE idCaisse = ?";
                $reqRec = $pdo->prepare($sqlRec);
                $reqRec->execute([1]);
                $resRech = $reqRec->fetch();
                $ventes = $resRech['ventes'];
                $depenses = $resRech['depenses'];
                $creances = $resRech['creances'];

                $credit_actuelle = $creances - $montantCa;
                $Net = $ventes - $depenses - $credit_actuelle;

                $sql = "UPDATE caisse SET `creances`=? , `net`= ? WHERE `idCaisse`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$credit_actuelle,$Net,1]);

            }elseif($sta=="Proformat"){
                $sql = "UPDATE detail_commande SET `qte`=?,`soldeIS`=?,`soldeS`=? WHERE `idDC`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$qte,$stock,0,$idDC]);

            }
        }
        header("Location:../detail_vente.php?idC=$idC");
    }
?>