<?php
    session_start();
    require_once('../../include/connexiondb.php');
    if (
        isset($_POST['addComBtn']) && 
        isset($_POST['idM']) && 
        isset($_POST['idC']) &&
        isset($_POST['qte']) 
    ) {
        //Les variables
        $idM = $_POST['idM'];
        $idC = $_POST['idC'];
        $qte = $_POST['qte'];

        //Recupération stock Produit
        $sqlStockMedicament = "SELECT * FROM medicament WHERE idM = ?";
        $reqStockMedicament = $pdo->prepare($sqlStockMedicament);
        $reqStockMedicament->execute([$idM]);
        $resStockMedicament = $reqStockMedicament->fetch();
        $designM = $resStockMedicament['design'];
        $stock = $resStockMedicament['stock'];
        $pvEnStock = $resStockMedicament['pvg'];
        $stockMin = 0;

        $sql = "SELECT * FROM detail_commande 
            INNER JOIN commande ON commande.idC=detail_commande.idC 
            INNER JOIN medicament ON medicament.idM=detail_commande.idM
            WHERE detail_commande.idC=? AND medicament.idM=?";
        $req = $pdo->prepare($sql);
        $req->execute([$idC,$idM]);

        if ($req->rowCount() > 0) {
            $msg_erreur = $designM." se trouve déjè dans le détail de la commande";
            header("Location:../detail_vente.php?idC=$idC&erreur=$msg_erreur");
            exit;
        } elseif ($qte >= $stock) {
            $msg_erreur = "La quantité en stock pour ".$designM." est insuffisante pour cette commande";
            header("Location:../detail_vente.php?idC=$idC&erreur=$msg_erreur");
            exit;
        }elseif ($stock <= $stockMin) {
            $msg_erreur = "Vous êtes en rupture de stock pour ".$designM."";
            header("Location:../detail_vente.php?idC=$idC&erreur=$msg_erreur");
        }else{
            //Req commande
            $sqlcOM = "SELECT * FROM commande WHERE idC = ?";
            $reqCom = $pdo->prepare($sqlcOM);
            $reqCom->execute([$idC]);
            $resCom = $reqCom->fetch();
            $sta = $resCom['statut'];

            if($sta=="Cash"){
                # Insertion des données dans la table 
                $stockApprov = $stock - $qte;
                $sql = "INSERT INTO detail_commande 
                (`idC`,`idM`,`qte`,`soldeIS`,`soldeS`,`prixV`) 
                VALUES (?,?,?,?,?,?)";
                $req = $pdo->prepare($sql);
                $req->execute([$idC,$idM,$qte,$stock,$stockApprov,$pvEnStock]);

                //Identifiant Detail_Commande
                $idDetailCommande = $pdo->lastInsertId();

                # update des données dans la table  stock medicament
                $sql = "UPDATE medicament SET `stock`=? WHERE `idM`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$stockApprov,$idM]);

                # update des données dans la table  caisse et ca
                $montantCa = $qte*$pvEnStock;
            
                $sql = "INSERT INTO ca (`idDC`,`m_ca`) VALUES (?,?)";
                $req = $pdo->prepare($sql);
                $req->execute([$idDetailCommande,$montantCa]);

                $sqlRec = "SELECT * FROM caisse WHERE idCaisse = ?";
                $reqRec = $pdo->prepare($sqlRec);
                $reqRec->execute([1]);
                $resRech = $reqRec->fetch();
                $ventes = $resRech['ventes'];
                $depenses = $resRech['depenses'];
                $creances = $resRech['creances'];

                $vente_actuelle = $ventes + $montantCa;
                $Net = $vente_actuelle - $depenses - $creances;

                $sql = "UPDATE caisse SET `ventes`=? , `net`= ? WHERE `idCaisse`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$vente_actuelle,$Net,1]);

                header("Location:../detail_vente.php?idC=$idC");
            }elseif($sta=="Credit"){
                # Insertion des données dans la table 
                $stockApprov = $stock - $qte;
                $sql = "INSERT INTO detail_commande 
                (`idC`,`idM`,`qte`,`soldeIS`,`soldeS`,`prixV`) 
                VALUES (?,?,?,?,?,?)";
                $req = $pdo->prepare($sql);
                $req->execute([$idC,$idM,$qte,$stock,$stockApprov,$pvEnStock]);

                $montantCa = $qte*$pvEnStock;

                //Update Credit Table
                $sqlCred = "SELECT * FROM credit WHERE idC = ?";
                $reqCred = $pdo->prepare($sqlCred);
                $reqCred->execute([$idC]);
                $resCred = $reqCred->fetch();
                $mCred = $resCred['mCred'];
                $montantCreditTot = $mCred + $montantCa;
                $sql = "UPDATE credit SET `mCred`=?
                WHERE `idC`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$montantCreditTot,$idC]);

                # update des données dans la table  stock medicament
                
                $sql = "UPDATE medicament SET `stock`=? WHERE `idM`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$stockApprov,$idM]);

                # update des données dans la table  caisse
                $sqlRec = "SELECT * FROM caisse WHERE idCaisse = ?";
                $reqRec = $pdo->prepare($sqlRec);
                $reqRec->execute([1]);
                $resRech = $reqRec->fetch();
                $ventes = $resRech['ventes'];
                $depenses = $resRech['depenses'];
                $creances = $resRech['creances'];

                $credit_actuelle = $creances + $montantCa;
                $Net = $vente_actuelle - $depenses - $credit_actuelle;

                $sql = "UPDATE caisse SET `creances`=? , `net`= ? WHERE `idCaisse`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$credit_actuelle,$Net,1]);

                header("Location:../detail_vente.php?idC=$idC");

            }elseif($sta=="Proformat"){
                # Insertion des données dans la table 
                $sql = "INSERT INTO detail_commande 
                (`idC`,`idM`,`qte`,`soldeIS`,`soldeS`,`prixV`) 
                VALUES (?,?,?,?,?,?)";
                $req = $pdo->prepare($sql);
                $req->execute([$idC,$idM,$qte,$stock,0,$pvEnStock]);

                header("Location:../detail_vente.php?idC=$idC");
            }
            
        }

    }else{
        $msg_erreur = "Il y a une erreure";
        header("Location:../detail_vente.php?idC=$idC&erreur=$msg_erreur");
        exit;
    }
?>

