<?php
session_start();
require_once('../../include/connexiondb.php');

// Récupérer l'année en cours
$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$idAn = $resPgrh['idAn'];

// Sélectionner les enregistrements de t_inscrit
$stmtTInscrit = $pdo->prepare("SELECT * FROM t_inscrit
INNER JOIN t_classe ON t_inscrit.idC = t_classe.idC 
INNER JOIN t_option ON t_classe.idO = t_option.idO 
INNER JOIN t_an ON t_inscrit.idA = t_an.idA 
WHERE  t_inscrit.idA = :idAn");
$stmtTInscrit->execute(['idAn' => $idAn]);
$tInscrits = $stmtTInscrit->fetchAll(PDO::FETCH_ASSOC);

foreach ($tInscrits as $tInscrit) {
    // Construire le nom de la classe
    $nomClasse = $tInscrit['nom'] . ' - ' . $tInscrit['design'] . ' ' . $tInscrit['designO'] . ' ' . $tInscrit['ord'];

    // Vérifier si le client existe déjà dans la table client
    $stmtClient = $pdo->prepare("SELECT idClient FROM client WHERE nom = :nom");
    $stmtClient->execute(['nom' => $nomClasse]);
    $existingClient = $stmtClient->fetch(PDO::FETCH_ASSOC);

    if ($existingClient) {
        // Mettre à jour le client existant
        $stmtUpdate = $pdo->prepare("UPDATE client SET adresse = :adresse, telephone = :telephone WHERE idClient = :idClient");
        $stmtUpdate->execute([
            'adresse' => $tInscrit['adresse'],
            'telephone' => $tInscrit['telP'],
            'idClient' => $existingClient['idClient']
        ]);
    } else {
        // Insérer un nouveau client
        $stmtInsert = $pdo->prepare("INSERT INTO client (nom, adresse, telephone, remise) VALUES (:nom, :adresse, :telephone, 0)");
        $stmtInsert->execute([
            'nom' => $nomClasse,
            'adresse' => $tInscrit['adresse'],
            'telephone' => $tInscrit['telP']
        ]);
    }
}

// Message de succès
$msg_erreur = "Clients synchronisés avec succès";
header("Location:../clients.php?succes=$msg_erreur");
exit;
