<?php
session_start();
if (!isset($_SESSION["login"]) && !isset($_SESSION['etat'])) {
  header('Location:../index.php');
}

require_once('../include/connexiondb.php');
$des = isset($_GET['des']) ? $_GET['des'] : "";
$page_no = isset($_GET['page_no']) ? $_GET['page_no'] : 1;
$total_records_per_page = 15;
$offset = ($page_no - 1) * $total_records_per_page;
$previous_page = $page_no - 1;
$next_page = $page_no + 1;
$adjacents = "2";

$requeteRecord = "SELECT count(*) AS total_records FROM medicament 
 INNER JOIN categorie ON medicament.idCat=categorie.idCat
 where design like '%$des%' or designCat like '%$des%' ";
$total_records = $pdo->query($requeteRecord)->fetch();
$total_records = $total_records['total_records'];
$total_no_of_pages = ceil($total_records / $total_records_per_page);
$second_last = $total_no_of_pages - 1;

$requete = "SELECT * FROM medicament 
INNER JOIN categorie ON medicament.idCat=categorie.idCat 
where design like '%$des%' OR designCat like '%$des%' ORDER BY design ASC
LIMIT $offset, $total_records_per_page";
$resultat = $pdo->query($requete);

?>
<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_stockagent.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#gest-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Gestions</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="gest-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="clients.php">
              <i class="bi bi-circle"></i><span>Clients</span>
            </a>
          </li>
          <li>
            <a href="fourn.php">
              <i class="bi bi-circle"></i><span>Fournisseurs</span>
            </a>
          </li>
          <li>
            <a href="categ.php">
              <i class="bi bi-circle"></i><span>Emplacement</span>
            </a>
          </li>
        </ul>
      </li><!-- End Gestions Nav -->

      <li class="nav-item">
        <a class="nav-link" href="med.php">
          <i>&#9764;</i>
          <span>Stock Produit</span>
        </a>
      </li><!-- End stock Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="investis.php">
          <i class="bi bi-snow2"></i>
          <span>Stock Investi</span>
        </a>
      </li><!-- End Stock Investi Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="approv.php">
          <i class="bi bi-cart4"></i>
          <span>Approvisionnement</span>
        </a>
      </li><!-- End Approv Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="ventes.php">
          <i class="bi bi-cart-fill"></i>
          <span>Ventes</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="serv_cre.php">
          <i class="bi bi-activity"></i>
          <span>Suivi des Créances</span>
        </a>
      </li><!-- End Créances Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="dep.php">
          <i class="bi bi-plus-slash-minus"></i>
          <span>Dépenses</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="requis.php">
          <i class="bi bi-stack"></i>
          <span>Requisition</span>
        </a>
      </li><!-- End Requisition Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="invet.php">
          <i class="bi bi-stickies-fill"></i>
          <span>Inventaire</span>
        </a>
      </li><!-- End Inventaire Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="analyse.php">
          <i class="bi bi-slack"></i>
          <span>Analyse</span>
        </a>
      </li><!-- End Analyse Page Nav -->

    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Stock</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
          <li class="breadcrumb-item active">Stock Magasin</li>
        </ol>
      </nav>
      <!-- Message d'erreur -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
          <div class="alert alert-warning" role="alert">
            <?php echo htmlspecialchars($_GET['erreur']); ?>
          </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
          <div class="alert alert-success" role="alert">
            <?php echo htmlspecialchars($_GET['succes']); ?>
          </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">
        <!-- TAbele data -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Liste des produits en magasin<span>| <a data-bs-toggle="modal" data-bs-target="#modalAddMed" class="btn btn-success"><i class="bi bi-plus-circle-fill"></i> AJOUTER</a>
                      | <a href="../include/stock_magasin_print.php" target="_blank" class="btn btn-warning"><i class="bi bi-printer-fill"></i> IMPRIMER</a></span></h5>
                  <form method="get" action="med.php" class="searchform js__toggle">
                    <div class="input-group has-validation">
                      <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                      <input type="text" name="des" placeholder="Search..." class="form-control">
                      <button class="bi bi-search btn btn-info" type="submit"></button>
                    </div>
                  </form>

                  <table class="table">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Produit</th>
                        <th scope="col">Emplacement</th>
                        <th scope="col">Stock</th>
                        <th scope="col">PAU</th>
                        <th scope="col">Intérêt</th>
                        <th scope="col">PVU</th>
                        <th scope="col">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      $aujourdhui = date('Y-m-d');
                      $stockMax = 500;
                      $nombre = 1;
                      while ($data = $resultat->fetch()) { ?>
                        <tr>
                          <td scope="row"><?php echo $nombre ?></td>
                          <td><?php echo $data['design'] ?></td>
                          <td><?php echo $data['designCat'] ?></td>
                          <td><?php
                              if ($data['stock'] <= $data['stockMin']) {
                                echo '<span style="color:#ffffff; background-color: #b90000;
                                display: inline-block; border-radius: 5px;text-align: center;font-size: 14px;padding: 10px;-webkit-transition: all 0.2s;
                                -moz-transition: all 0.2s;-o-transition: all 0.2s;transition: all 0.2s; margin: 2px;"> <strong> ' . $data['stock'] . ' </strong> </span>';
                              } elseif ($data['stock'] <=  $stockMax || $data['stock'] >=  $stockMax) {
                                echo '<span style="color:#ffffff; background-color: #2a9d8f;
                                display: inline-block; border-radius: 5px;text-align: center;font-size: 14px;padding: 10px;-webkit-transition: all 0.2s;
                                -moz-transition: all 0.2s;-o-transition: all 0.2s;transition: all 0.2s; margin: 2px;"> <strong> ' . $data['stock'] . ' </strong> </span>';
                              }
                              ?>
                          </td>
                          <td><?php echo number_format($data['paEn'], 2, '.', ' ') ?></td>
                          <td><?php echo $data['intg'] . ' %' ?></td>
                          <td><?php echo number_format($data['pvg'], 2, '.', ' ') ?></td>
                          <td>
                            <a data-bs-toggle="modal" data-bs-target="#modalUpdateMed<?php echo $data['idM'] ?>" class="btn btn-primary"><span class="bi bi-pencil-square"></span> </a>
                            <a data-bs-toggle="modal" data-bs-target="#modalDeleteProduit<?php echo $data['idM'] ?>" class="btn btn-danger"><span class="bi bi-x-octagon-fill"></span> </a>
                            <a data-bs-toggle="modal" data-bs-target="#modalPrintFiche<?php echo $data['idM'] ?>" class="btn btn-info"><span class="bi bi-printer-fill"></span> </a>
                          </td>
                        </tr>
                      <?php $nombre++;
                        include('modal_include/ModalmodifierMed.php');
                      } ?>
                    </tbody>
                  </table>
                  <ul class="pagination">
                    <?php // if($page_no > 1){ echo "<li><a href='?page_no=1'>First Page</a></li>"; } 
                    ?>

                    <li <?php if ($page_no <= 1) {
                          echo "class=' page-item disabled'";
                        } ?>>
                      <a class='page-link prevnext' <?php if ($page_no > 1) {
                                                      echo "href='med.php?page_no=$previous_page&des=$des'";
                                                    } ?>>Previous</a>
                    </li>

                    <?php
                    if ($total_no_of_pages <= 10) {
                      for ($counter = 1; $counter <= $total_no_of_pages; $counter++) {
                        if ($counter == $page_no) {
                          echo "<li class='active class='page-item''><a class='page-link'>$counter</a></li>";
                        } else {
                          echo "<li class='page-item'><a class='page-link' href='med.php?page_no=$counter&des=$des'>$counter</a></li>";
                        }
                      }
                    } elseif ($total_no_of_pages > 10) {

                      if ($page_no <= 4) {
                        for ($counter = 1; $counter < 8; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='med.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='med.php?page_no=$second_last&des=$des'>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='med.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } elseif ($page_no > 4 && $page_no < $total_no_of_pages - 4) {
                        echo "<li class='page-item'><a class='page-link' href='med.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='med.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        for ($counter = $page_no - $adjacents; $counter <= $page_no + $adjacents; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='med.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='med.php?page_no=$second_last'&des=$des>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='med.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } else {
                        echo "<li class='page-item'><a class='page-link' href='med.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='med.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";

                        for ($counter = $total_no_of_pages - 6; $counter <= $total_no_of_pages; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li  class='page-item'><a class='page-link' href='med.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                      }
                    }
                    ?>

                    <li <?php if ($page_no >= $total_no_of_pages) {
                          echo "class='disabled page-item'";
                        } ?>>
                      <a class='page-link prevnext' <?php if ($page_no < $total_no_of_pages) {
                                                      echo "href='med.php?page_no=$next_page'";
                                                    } ?>>Next</a>
                    </li>
                    <?php if ($page_no < $total_no_of_pages) {
                      echo "<li class='page-item'><a class='page-link prevnext' href='med.php?page_no=$total_no_of_pages'>Last &rsaquo;&rsaquo;</a></li>";
                    }

                    ?>
                  </ul>
                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->
      </div>
    </section>

  </main><!-- End #main -->

  <!-- MES DIFFERENTS MODALES -->

  <!-- MODAL ADD SERVICE -->
  <div class="modal fade" id="modalAddMed" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Ajouter un Produit en Magasin</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="php_include/addMed.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

            <div class="row mb-3">
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Désignation</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                  <input type="text" name="design" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez saisir la désignation SVP !</div>
                </div>
              </div>
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Emplacement</label>
                <select class="form-select" name="idCat" id="example-search">
                  <?php $requeteRequ = "select * from categorie";
                  $resultatRequest = $pdo->query($requeteRequ);
                  while ($result = $resultatRequest->fetch()) { ?>
                    <option value="<?php echo $result['idCat'] ?>">
                      <?php echo $result['designCat'] ?></option>
                  <?php } ?>
                </select>
              </div>

              <div class="col-md-6 col-lg-6">
                <label for="titre" class="form-label">Stock Initial</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-box"></i></span>
                  <input type="number" name="stock" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez saisir le stock initial SVP !</div>
                </div>
              </div>

              <div class="col-md-6 col-lg-6">
                <label for="titre" class="form-label">Stock Minimum</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-box"></i></span>
                  <input type="number" name="stockMin" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez saisir le stock min SVP !</div>
                </div>
              </div>

              <div class="col-md-6 col-lg-6">
                <label for="titre" class="form-label">Prix d'achat Unitaire</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i>En FC</i></span>
                  <input type="text" name="paEn" class="form-control" id="pa" required>
                  <div class="invalid-feedback">Veillez saisir le Prix d'achat En FC SVP !</div>
                </div>
              </div>

              <div class="col-md-6 col-lg-6">
                <label for="titre" class="form-label">Prix de vente en FC</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i>En FC</i></span>
                  <input type="text" name="pv" class="form-control" id="pv" onkeyup="pourInt(this.value);" required>
                  <div class="invalid-feedback">Veillez saisir le prix SVP !</div>
                </div>
              </div>
            </div>

            <div class="modal-footer">
              <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
              <button type="submit" name="addMedBtn" onclick="document.fo.submit()" class="btnModSave">Enregistrer</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal ADD SERVICE-->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>