<?php
session_start();

// Inclure le fichier de connexion à la base de données
require_once('../../include/connexiondb.php');

// Assurez-vous que le formulaire a été soumis
if (isset($_POST['modifBtn'])) {
    // Récupération des valeurs du formulaire
    $nomV = $_POST['nomV'];
    $motifV = $_POST['motif'];
    $concV = $_POST['concV'];
    $idV = $_POST['idV'];

    try {
        // Préparation de la requête SQL
        $query = "UPDATE t_visite SET nomV=:nomV, motifV=:motifV, concV=:concV WHERE idV=:idV";
        $statement = $pdo->prepare($query);

        // Liaison des paramètres
        $statement->bindParam(':nomV', $nomV, PDO::PARAM_STR);
        $statement->bindParam(':motifV', $motifV, PDO::PARAM_STR);
        $statement->bindParam(':concV', $concV, PDO::PARAM_STR);
        $statement->bindParam(':idV', $idV, PDO::PARAM_INT); // Utilisation de PARAM_INT pour l'ID

        // Exécution de la requête
        $statement->execute();

        //Redurection
        header("Location: ../vis.php?succes=Modification effectuée avec succès");
         exit;
    } catch (PDOException $e) {
        // Gestion des erreurs PDO
        header("Location: ../vis.php?erreur=Erreur lors de la modification");
        exit;
    }
}
?>
