<?php
session_start();
require_once('../../include/connexiondb.php');
// Assurez-vous que le formulaire a été soumis
if (isset($_POST['addBtn'])) {
    // Récupération des valeurs du formulaire
    $nomV = $_POST['nomV'];
    $motifV = $_POST['motif'];
    $concV = $_POST['concV'];

    try {
        // Préparation de la requête SQL
        $query = "INSERT INTO t_visite (nomV, motifV, concV, haV, dateV) VALUES (:nomV, :motifV, :concV, CURTIME(), CURDATE())";
        $statement = $pdo->prepare($query);

        // Liaison des paramètres
        $statement->bindParam(':nomV', $nomV, PDO::PARAM_STR);
        $statement->bindParam(':motifV', $motifV, PDO::PARAM_STR);
        $statement->bindParam(':concV', $concV, PDO::PARAM_STR);

        // Exécution de la requête
        $statement->execute();

        // Redirection après l'enregistrement
        header("Location: ../vis.php?succes=Enregistrement effectué avec succès");
        exit;
    } catch (PDOException $e) {
        // Gestion des erreurs PDO
        header("Location: ../vis.php?erreur=Erreur lors de l'enregistrement");
        exit;
    }
}
?>
