<?php
session_start();
if (!isset($_SESSION["login"]) && !isset($_SESSION['etat'])) {
  header('Location:../index.php');
}

require_once('../include/connexiondb.php');
$des = isset($_GET['des']) ? $_GET['des'] : "";
$page_no = isset($_GET['page_no']) ? $_GET['page_no'] : 1;
$total_records_per_page = 15;
$offset = ($page_no - 1) * $total_records_per_page;
$previous_page = $page_no - 1;
$next_page = $page_no + 1;
$adjacents = "2";

$requeteRecord = "SELECT count(*) AS total_records 
FROM commande INNER JOIN users ON 
users.idUser=commande.idUser INNER JOIN client 
ON client.idClient=commande.idClient WHERE nom like 
'%$des%' OR statut like '%$des%'";
$total_records = $pdo->query($requeteRecord)->fetch();
$total_records = $total_records['total_records'];
$total_no_of_pages = ceil($total_records / $total_records_per_page);
$second_last = $total_no_of_pages - 1;

$requete = "SELECT * FROM commande INNER JOIN users ON 
users.idUser=commande.idUser INNER JOIN client 
ON client.idClient=commande.idClient WHERE nom like 
'%$des%' OR statut like '%$des%' ORDER BY commande.idC DESC 
LIMIT $offset, $total_records_per_page ";
$resultat = $pdo->query($requete);

$idUser = $_SESSION['id'];

$requeteCA = "SELECT SUM(prixV*qte) as CA FROM detail_commande";
$resultatCA = $pdo->query($requeteCA);
$dataCA = $resultatCA->fetch();
$CA = $dataCA['CA'];

?>
<?php include("header_vente.php"); ?>

<!-- Espace de travail -->
<main id="main" class="main">

  <div class="pagetitle">
    <h1>Ventes</h1>
    <nav>
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
        <li class="breadcrumb-item active">Ventes</li>
      </ol>
    </nav>
    <!-- Message d'erreur -->
    <center>
      <?php if (isset($_GET['erreur'])) { ?>
        <div class="alert alert-warning" role="alert">
          <?php echo htmlspecialchars($_GET['erreur']); ?>
        </div>
      <?php } ?>
      <?php if (isset($_GET['succes'])) { ?>
        <div class="alert alert-success" role="alert">
          <?php echo htmlspecialchars($_GET['succes']); ?>
        </div>
      <?php } ?>
    </center>
  </div><!-- End Page Title -->

  <!-- Section Dashbord -->
  <section class="section dashboard">
    <div class="row">
      <!-- TAbele data -->
      <div class="col-lg-12">
        <div class="row">
          <!-- Table service -->
          <div class="col-12">
            <div class="card overflow-auto">

              <div class="card-body">
                <h5 class="card-title">Liste des ventes <span>| <a data-bs-toggle="modal" data-bs-target="#modalAddVente" class="btn btn-success"><i class="bi bi-plus-circle-fill"></i> <strong> Ajouter Commande </strong> </a>
                    | <a data-bs-toggle="modal" data-bs-target="#modalPrintTot" class="btn btn-warning"><i class="bi bi-printer-fill"></i> IMPRIMER</a>
                    | <a data-bs-toggle="modal" data-bs-target="#modalAddClient" class="btn btn-primary"><i class="bi bi-plus-circle-fill"></i> <strong> Nouveau Client </strong> </a>
                    | <a data-bs-toggle="modal" data-bs-target="#modalPrintInt" class="btn btn-info"><i class="bi bi-printer-fill"></i> <strong> Intérêts </strong> </a></span></h5>
                <form method="get" action="ventes.php" class="searchform js__toggle">
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                    <input type="text" name="des" placeholder="Search..." class="form-control">
                    <button class="bi bi-search btn btn-info" type="submit"></button>
                  </div>
                </form>
                <table class="table">
                  <thead>
                    <tr>
                      <th scope="col">#</th>
                      <th scope="col">Client</th>
                      <th scope="col">Date</th>
                      <th scope="col">Statut</th>
                      <th scope="col">Actions</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                    $nombre = 1;
                    while ($data = $resultat->fetch()) { ?>
                      <tr>
                        <td scope="row"><?php echo $nombre ?></td>
                        <td><?php echo $data['nom'] ?></td>
                        <td><?php echo date('d-m-Y', strtotime($data['dateC'])) ?></td>
                        <td>
                          <?php if ($data['statut'] == "Cash") { ?>
                            <span class="badge bg-info">Cash</span>&nbsp;
                          <?php } elseif ($data['statut'] == "Credit") { ?>
                            <span class="badge bg-danger">Crédit</span>&nbsp;
                          <?php } else { ?>
                            <span class="badge bg-warning">Proformat</span>&nbsp;
                          <?php } ?>
                        </td>
                        <td>
                          <?php
                          if ($data['statut'] == "Cash") { ?>
                            <a href="detail_vente.php?idC=<?php echo $data['idC'] ?>" class="btn btn-success"><span class="bi bi-eye-fill"></span> <strong> Détail </strong> </a>
                            &nbsp;
                            <a data-bs-toggle="modal" data-bs-target="#modalUpdateVenteCash<?php echo $data['idC'] ?>" class="btn btn-primary"><span class="bi bi-pencil-square"></span> <strong> </strong> </a>
                            &nbsp;
                          <?php } ?>

                          <?php
                          if ($data['statut'] == "Proformat") { ?>
                            <a href="detail_vente.php?idC=<?php echo $data['idC'] ?>" class="btn btn-success"><span class="bi bi-eye-fill"></span> <strong> Détail </strong> </a>
                            &nbsp;
                            <a data-bs-toggle="modal" data-bs-target="#modalUpdateVenteProformat<?php echo $data['idC'] ?>" class="btn btn-primary"><span class="bi bi-pencil-square"></span> <strong> </strong> </a>
                            &nbsp;
                          <?php } ?>

                          <?php
                          $numeroCom = $data['idC'];
                          $requeteCredC = "SELECT * FROM
                                credit INNER JOIN commande ON credit.idC=commande.idC
                                 AND commande.idC='$numeroCom'";
                          $resultatCredC = $pdo->query($requeteCredC)->fetch();
                          if ($data['statut'] == "Credit" && $resultatCredC['mCred'] != null) { ?>
                            <a href="detail_vente.php?idC=<?php echo $data['idC'] ?>" class="btn btn-success"><span class="bi bi-eye-fill"></span> <strong> Détail </strong> </a>
                            &nbsp;
                            <a data-bs-toggle="modal" data-bs-target="#modalPayerCredit<?php echo $data['idC'] ?>" class="btn btn-warning"><span class="bi bi-currency-exchange"></span> <strong> <?= $resultatCredC['mCred'] ?> FC </strong> </a>
                          <?php } ?>
                          &nbsp;
                          <a data-bs-toggle="modal" data-bs-target="#modalDeleteCommande<?php echo $data['idC'] ?>" class="btn btn-danger"><span class="bi bi-x-octagon-fill"></span> <strong> </strong> </a>
                        </td>
                      </tr>
                    <?php $nombre++;
                      include('modal_include/ModalmodifierVente.php');
                    } ?>
                  </tbody>
                </table>
                <ul class="pagination">
                  <?php // if($page_no > 1){ echo "<li><a href='?page_no=1'>First Page</a></li>"; } 
                  ?>

                  <li <?php if ($page_no <= 1) {
                        echo "class=' page-item disabled'";
                      } ?>>
                    <a class='page-link prevnext' <?php if ($page_no > 1) {
                                                    echo "href='ventes.php?page_no=$previous_page&des=$des'";
                                                  } ?>>Previous</a>
                  </li>

                  <?php
                  if ($total_no_of_pages <= 10) {
                    for ($counter = 1; $counter <= $total_no_of_pages; $counter++) {
                      if ($counter == $page_no) {
                        echo "<li class='active class='page-item''><a class='page-link'>$counter</a></li>";
                      } else {
                        echo "<li class='page-item'><a class='page-link' href='ventes.php?page_no=$counter&des=$des'>$counter</a></li>";
                      }
                    }
                  } elseif ($total_no_of_pages > 10) {

                    if ($page_no <= 4) {
                      for ($counter = 1; $counter < 8; $counter++) {
                        if ($counter == $page_no) {
                          echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                        } else {
                          echo "<li class='page-item'><a class='page-link' href='ventes.php?page_no=$counter&des=$des'>$counter</a></li>";
                        }
                      }
                      echo "<li class='page-item'><a class='page-link'>...</a></li>";
                      echo "<li class='page-item'><a class='page-link' href='ventes.php?page_no=$second_last&des=$des'>$second_last</a></li>";
                      echo "<li class='page-item'><a class='page-link' href='ventes.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                    } elseif ($page_no > 4 && $page_no < $total_no_of_pages - 4) {
                      echo "<li class='page-item'><a class='page-link' href='ventes.php?page_no=1&des=$des'>1</a></li>";
                      echo "<li class='page-item'><a class='page-link' href='ventes.php?page_no=2&des=$des'>2</a></li>";
                      echo "<li class='page-item'><a class='page-link'>...</a></li>";
                      for ($counter = $page_no - $adjacents; $counter <= $page_no + $adjacents; $counter++) {
                        if ($counter == $page_no) {
                          echo "<li class='active'><a class='page-link'>$counter</a></li>";
                        } else {
                          echo "<li class='page-item'><a class='page-link' href='ventes.php?page_no=$counter&des=$des'>$counter</a></li>";
                        }
                      }
                      echo "<li class='page-item'><a class='page-link'>...</a></li>";
                      echo "<li class='page-item'><a class='page-link' href='ventes.php?page_no=$second_last'&des=$des>$second_last</a></li>";
                      echo "<li class='page-item'><a class='page-link' href='ventes.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                    } else {
                      echo "<li class='page-item'><a class='page-link' href='ventes.php?page_no=1&des=$des'>1</a></li>";
                      echo "<li class='page-item'><a class='page-link' href='ventes.php?page_no=2&des=$des'>2</a></li>";
                      echo "<li class='page-item'><a class='page-link'>...</a></li>";

                      for ($counter = $total_no_of_pages - 6; $counter <= $total_no_of_pages; $counter++) {
                        if ($counter == $page_no) {
                          echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                        } else {
                          echo "<li  class='page-item'><a class='page-link' href='ventes.php?page_no=$counter&des=$des'>$counter</a></li>";
                        }
                      }
                    }
                  }
                  ?>

                  <li <?php if ($page_no >= $total_no_of_pages) {
                        echo "class='disabled page-item'";
                      } ?>>
                    <a class='page-link prevnext' <?php if ($page_no < $total_no_of_pages) {
                                                    echo "href='ventes.php?page_no=$next_page'";
                                                  } ?>>Next</a>
                  </li>
                  <?php if ($page_no < $total_no_of_pages) {
                    echo "<li class='page-item'><a class='page-link prevnext' href='ventes.php?page_no=$total_no_of_pages'>Last &rsaquo;&rsaquo;</a></li>";
                  }
                  ?>
                </ul>

                <h5 style="text-align: center; background-color: #3c1ced; color: white; padding: 5px; font-size: 25px;">
                  CHIFFRE D'AFFAIRE ::: <strong><?= number_format($CA, 2, '.', ' ') ?> FC</strong>
                </h5>

              </div>

            </div>
          </div><!-- End Recent messages -->

        </div>
      </div><!-- End table data -->
    </div>
  </section>

</main><!-- End #main -->

<!-- MODAL ADD SERVICE -->
<div class="modal fade" id="modalPrintTot" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Print des ventes réalisées</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form method="post" action="../include/printV.php" target="_blank" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

          <div class="row mb-3">

            <div class="col-md-12 col-lg-12">
              <label for="titre" class="form-label">Première Date</label>
              <div class="input-group has-validation">
                <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-alarm-fill"></i></span>
                <input type="date" name="date1" class="form-control" id="titre" required>
                <div class="invalid-feedback">Veillez choisir la Date SVP !</div>
              </div>
            </div>

            <div class="col-md-12 col-lg-12">
              <label for="titre" class="form-label">Seconde Date</label>
              <div class="input-group has-validation">
                <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-alarm-fill"></i></span>
                <input type="date" name="date2" class="form-control" id="titre" required>
                <div class="invalid-feedback">Veillez choisir la Date SVP !</div>
              </div>
            </div>
          </div>

          <div class="modal-footer">
            <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
            <button type="submit" name="addMedBtn" onclick="document.fo.submit()" class="btnModSave">IMPRIMER</button>
          </div>
        </form><!-- End Change Password Form -->
      </div>

    </div>
  </div>
</div><!-- End Modal ADD SERVICE-->

<!-- MODAL ADD SERVICE -->
<div class="modal fade" id="modalAddVente" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Ajouter une Commande</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form method="post" action="php_include/addVente.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

          <div class="row mb-3">
            <div class="col-md-12 col-lg-12">
              <label for="titre" class="form-label">Client</label>
              <select class="form-select" name="idClient" id="example-search">
                <?php
                $requeteClient = "SELECT * FROM client ORDER BY nom ASC ";
                $resultatClient = $pdo->query($requeteClient);
                while ($dataClient = $resultatClient->fetch()) { ?>
                  <option value="<?php echo $dataClient['idClient'] ?>">
                    <?php echo $dataClient['nom'] ?></option>
                <?php } ?>
              </select>
            </div>

            <div class="col-md-12 col-lg-12">
              <label for="titre" class="form-label">Statut Commande</label>
              <div class="input-group has-validation">
                <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                <input type="hidden" name="idUser" value="<?php echo $idUser ?>" class="form-control" id="titre" required>
                <select name="statut" class="form-select" id="titre" required>
                  <option value="Cash">Cash</option>
                  <option value="Credit">Crédit</option>
                  <option value="Proformat">Proformat</option>
                </select>
                <div class="invalid-feedback">Veillez Choisir la statut SVP !</div>
              </div>
            </div>
          </div>

          <div class="modal-footer">
            <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
            <button type="submit" name="addVenteBtn" onclick="document.fo.submit()" class="btnModSave">Enregistrer</button>
          </div>
        </form><!-- End Change Password Form -->
      </div>

    </div>
  </div>
</div>

<!-- MODAL ADD CLIENT -->
<div class="modal fade" id="modalAddClient" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Ajouter un Client</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form method="post" action="php_include/addClientVente.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

          <div class="row mb-3">
            <div class="col-md-12 col-lg-12">
              <label for="titre" class="form-label">Nom</label>
              <div class="input-group has-validation">
                <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-person"></i></span>
                <input type="text" name="nom" class="form-control" id="titre" required>
                <div class="invalid-feedback">Veillez saisir le nom SVP !</div>
              </div>
            </div>
          </div>

          <div class="row mb-3">
            <div class="col-md-12 col-lg-12">
              <label for="titre" class="form-label">Adresse</label>
              <div class="input-group has-validation">
                <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-person"></i></span>
                <input type="text" name="adresse" class="form-control" id="titre" required>
                <div class="invalid-feedback">Veillez saisir l'adresse SVP !</div>
              </div>
            </div>
          </div>

          <div class="row mb-3">
            <div class="col-md-12 col-lg-12">
              <label for="renewpassword" class="form-label">Téléphone</label>
              <div class="input-group has-validation">
                <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-phone"></i></span>
                <input type="text" name="telephone" class="form-control" id="renewPassword">
              </div>
            </div>
          </div>

          <div class="modal-footer">
            <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
            <button type="submit" name="addClientBtn" onclick="document.fo.submit()" class="btnModSave">Enregistrer</button>
          </div>
        </form><!-- End Change Password Form -->
      </div>

    </div>
  </div>
</div><!-- End Modal ADD CLIENT-->

<!-- MODAL ADD SERVICE -->
<div class="modal fade" id="modalPrintInt" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Print des intérêts réalisés</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form method="post" action="../include/printInteret.php" target="_blank" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

          <div class="row mb-3">

            <div class="col-md-12 col-lg-12">
              <label for="titre" class="form-label">Première Date</label>
              <div class="input-group has-validation">
                <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-alarm-fill"></i></span>
                <input type="date" name="date1" class="form-control" id="titre" required>
                <div class="invalid-feedback">Veillez choisir la Date SVP !</div>
              </div>
            </div>

            <div class="col-md-12 col-lg-12">
              <label for="titre" class="form-label">Seconde Date</label>
              <div class="input-group has-validation">
                <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-alarm-fill"></i></span>
                <input type="date" name="date2" class="form-control" id="titre" required>
                <div class="invalid-feedback">Veillez choisir la Date SVP !</div>
              </div>
            </div>
          </div>

          <div class="modal-footer">
            <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
            <button type="submit" name="printIntBtn" onclick="document.fo.submit()" class="btnModSave">IMPRIMER</button>
          </div>
        </form><!-- End Change Password Form -->
      </div>

    </div>
  </div>
</div><!-- End Modal ADD SERVICE-->

<!-- Footer et importation JavaScript -->
<?php include("../include/footer.php"); ?>

</body>

</html>