
<?php

function getNbClients($pdo)
{
    $sql = $pdo->prepare("SELECT * FROM client");
    $sql->execute();
    $nbm = $sql->rowCount();
    return $nbm;
}

function getNbFournisseur($pdo)
{
    $sql = $pdo->prepare("SELECT * FROM fournisseur");
    $sql->execute();
    $nbm = $sql->rowCount();
    return $nbm;
}

function getNbCategorie($pdo)
{
    $sql = $pdo->prepare("SELECT * FROM categorie");
    $sql->execute();
    $nbm = $sql->rowCount();
    return $nbm;
}

function getNbMedicament($pdo)
{
    $sql = $pdo->prepare("SELECT * FROM medicament");
    $sql->execute();
    $nbm = $sql->rowCount();
    return $nbm;
}

function getNbmedExpires($pdo)
{
    $today = date('y-m-d', strtotime('+ 2 month'));
    $sql = $pdo->prepare("SELECT * FROM medicament WHERE dateE <= ?");
    $sql->execute([$today]);
    $nbm = $sql->rowCount();
    return $nbm;
}

function getNbApprov($pdo)
{
    $sql = $pdo->prepare("SELECT * FROM approv");
    $sql->execute();
    $nbm = $sql->rowCount();
    return $nbm;
}

function getNbVente($pdo)
{
    $sql = $pdo->prepare("SELECT * FROM commande");
    $sql->execute();
    $nbm = $sql->rowCount();
    return $nbm;
}

function getNbCredit($pdo)
{
    $sql = $pdo->prepare("SELECT * FROM commande INNER JOIN users ON 
    users.idUser=commande.idUser INNER JOIN client ON 
    client.idClient=commande.idClient INNER JOIN detail_commande ON
    detail_commande.idC=commande.idC INNER JOIN medicament ON
    medicament.idM=detail_commande.idM WHERE commande.statut='credit'");
    $sql->execute();
    $nbm = $sql->rowCount();
    return $nbm;
}

function getNbCH($pdo)
{
    $sql = $pdo->query("SELECT SUM(prixV*qte) AS tot FROM detail_commande");
    $data=$sql->fetch();
    $nbm = $data['tot'];
    return $nbm;
}

function getApprovValeur($pdo)
{
    $sql = $pdo->query("SELECT SUM(pvg*qteA) AS tot FROM approv INNER JOIN 
     medicament ON approv.idM=medicament.idM");
    $data=$sql->fetch();
    $nbm = $data['tot'];
    return $nbm;
}

function getVenteValeur($pdo)
{
    $sql = $pdo->query("SELECT SUM(prixV*qte) AS tot FROM detail_commande INNER JOIN commande ON 
    commande.idC=detail_commande.idC INNER JOIN medicament 
    ON medicament.idM=detail_commande.idM");
    $data=$sql->fetch();
    $nbm = $data['tot'];
    return $nbm;
}


function getInteret($pdo)
{
    $sql = $pdo->query("SELECT SUM(prixV*qte*intg) AS tot FROM detail_commande INNER JOIN 
     medicament ON detail_commande.idM=medicament.idM");
    $data=$sql->fetch();
    $nbm = $data['tot'];
    return $nbm;
}

function getBenefice($pdo)
{
    $sql = $pdo->query("SELECT SUM(prixV*qte*intg) AS tot FROM detail_commande INNER JOIN 
     medicament ON detail_commande.idM=medicament.idM");
    $data=$sql->fetch();
    $nbm = $data['tot'];
    return $nbm;
}