<?php
session_start();
if (!isset($_SESSION["login"]) && !isset($_SESSION['etat'])) {
  header('Location:../index.php');
}

require_once('../include/connexiondb.php');

$des = isset($_GET['des']) ? $_GET['des'] : "";
$page_no = isset($_GET['page_no']) ? $_GET['page_no'] : 1;
$total_records_per_page = 15;
$offset = ($page_no - 1) * $total_records_per_page;
$previous_page = $page_no - 1;
$next_page = $page_no + 1;
$adjacents = "2";
$idCom = $_GET['idC'];

$requeteRecord = "SELECT count(*) AS total_records 
FROM detail_commande INNER JOIN 
  commande ON commande.idC=detail_commande.idC 
  INNER JOIN medicament ON medicament.idM=detail_commande.idM 
  WHERE detail_commande.idC='$idCom' AND design like '%$des%'";
$total_records = $pdo->query($requeteRecord)->fetch();
$total_records = $total_records['total_records'];
$total_no_of_pages = ceil($total_records / $total_records_per_page);
$second_last = $total_no_of_pages - 1;

$requeteMedoc = "SELECT * from medicament inner join categorie 
on medicament.idCat=categorie.idCat ORDER BY medicament.design ASC";
$resultatMedoc = $pdo->query($requeteMedoc);

$requete = "SELECT * FROM detail_commande INNER JOIN 
  commande ON commande.idC=detail_commande.idC 
  INNER JOIN medicament ON medicament.idM=detail_commande.idM 
  inner join categorie on medicament.idCat=categorie.idCat 
  WHERE detail_commande.idC='$idCom' AND design like '%$des%'
   ORDER BY medicament.design ASC 
  LIMIT $offset, $total_records_per_page ";
$resultat = $pdo->query($requete);

$DetailCount = $resultat->rowCount();

$requeteFacture = "SELECT * FROM detail_commande INNER JOIN 
  commande ON commande.idC=detail_commande.idC INNER JOIN 
  medicament ON medicament.idM=detail_commande.idM
   WHERE detail_commande.idC='$idCom'";
$resultatFacture = $pdo->query($requeteFacture);
$Fact = $resultatFacture->fetch();

$requeteQ = "SELECT SUM(prixV*qte) as tot, SUM(qte) as totQ, dateC as DateJour FROM 
detail_commande INNER JOIN commande ON commande.idC=detail_commande.idC 
INNER JOIN medicament ON medicament.idM=detail_commande.idM
 WHERE detail_commande.idC='$idCom'";
$resultatQ = $pdo->query($requeteQ);
$dataQ = $resultatQ->fetch();
$Quant = $dataQ['tot'];
$QuantG = $dataQ['totQ'];

//Modifier actualité
$newEtat = "1";
$sqlRed = "UPDATE commande SET etatC = ? WHERE idC=?";
$reqRed = $pdo->prepare($sqlRed);
$reqRed->execute([$newEtat, $idCom]);

?>
<?php include("header_vente.php"); ?>

<!-- Espace de travail -->
<main id="main" class="main">

  <div class="pagetitle">
    <h1>Détail d'une commande</h1>
    <nav>
      <ol class="breadcrumb">
        <li class="breadcrumb-item"><a href="ventes.php">ventes</a></li>
        <li class="breadcrumb-item active">Détail d'une commande</li>
      </ol>
    </nav>
    <!-- Message d'erreur -->
    <center>
      <?php if (isset($_GET['erreur'])) { ?>
        <div class="alert alert-warning" role="alert">
          <?php echo htmlspecialchars($_GET['erreur']); ?>
        </div>
      <?php } ?>
      <?php if (isset($_GET['succes'])) { ?>
        <div class="alert alert-success" role="alert">
          <?php echo htmlspecialchars($_GET['succes']); ?>
        </div>
      <?php } ?>
    </center>
  </div><!-- End Page Title -->

  <!-- Section Dashbord -->
  <section class="section dashboard">
    <div class="row">
      <!-- TAbele data -->
      <div class="col-lg-12">
        <div class="row">
          <!-- Table Detail medoc -->
          <div class="col-lg-12">
            <div class="card overflow-auto">

              <div class="card-body">
                <h5 class="card-title">Détail proprement-dit <span>| <a data-bs-toggle="modal" data-bs-target="#modalAddDetail" class="btn btn-success"><i class="bit bi-plus-circle-fill"></i> Ajouter</a> |
                    <?php if ($DetailCount == 0) { ?>
                      <h5 class="btn btn-danger"> Cette commande est vide </h5>
                    <?php } elseif ($Fact['statut'] == "Cash") { ?>
                      <a href="../include/factFin.php?idC=<?php echo $Fact['idC'] ?>" target="_blank" class="btn btn-primary"><i class="bi bi-printer-fill"></i> <strong> Facture Finale </strong> </a> &nbsp;
                    <?php } elseif ($Fact['statut'] == "Credit") { ?>
                      <a href="../include/factCred.php?idC=<?php echo $Fact['idC'] ?>" target="_blank" class="btn btn-danger"><i class="bi bi-printer-fill"></i> <strong> Facture à Crédit </strong> </a> &nbsp;
                    <?php } elseif ($Fact['statut'] == "Proformat") { ?>
                      <a href="../include/factProf.php?idC=<?php echo $Fact['idC'] ?>" target="_blank" class="btn btn-warning"><i class="bi bi-printer-fill"></i> <strong> Facture Proformat </strong> </a> &nbsp;
                    <?php } else { ?>
                      <span class="btn btn-danger"> Cette commande est vide </span>
                    <?php } ?>
                  </span>
                </h5>
                <form method="get" action="detail_vente.php" class="searchform js__toggle">
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                    <input type="text" name="des" placeholder="Search..." class="form-control">
                    <input type="hidden" name="idC" value="<?= $idCom ?>" class="form-control">
                    <button class="bi bi-search btn btn-info" type="submit"></button>
                  </div>
                </form>

                <table class="table">
                  <thead>
                    <tr>
                      <th scope="col">#</th>
                      <th scope="col">Produit</th>
                      <th scope="col">PV</th>
                      <th scope="col">Qté</th>
                      <th scope="col">PT</th>
                      <th scope="col">Actions</th>
                    </tr>
                  </thead>
                  <tbody>
                    <?php
                    $nombre = 1;
                    while ($data = $resultat->fetch()) { ?>
                      <tr>
                        <td scope="row"><?php echo $nombre ?></td>
                        <td><?php echo $data['design']?></td>
                        <td> <a data-bs-toggle="modal" data-bs-target="#modalModifPrixVente<?php echo $data['idDC'] ?>" class="btn btn-warning"> <strong> <?php echo $data['prixV'] ?> FC </strong> </a></td>
                        <td><?php echo $data['qte'] ?></td>
                        <td><?php echo  number_format($data['qte'] * $data['prixV'], 2, '.', ' ') . ' FC' ?></td>
                        <td>
                          <a href="php_include/addQuant.php?idM=<?php echo $data['idM'] ?>&idC=<?php echo $idCom ?>&idDC=<?php echo $data['idDC'] ?>" class="btn btn-success"><span class="bi bi-plus-lg"></span> </a>
                          &nbsp;
                          <a href="php_include/reduireQuant.php?idM=<?php echo $data['idM'] ?>&idC=<?php echo $idCom ?>&idDC=<?php echo $data['idDC'] ?>" class="btn btn-warning"><span class="bi bi-dash-lg"></span> </a>
                          &nbsp;
                          <a data-bs-toggle="modal" data-bs-target="#modalUpdateQuentDetail<?php echo $data['idDC'] ?>" class="btn btn-info"><span class="bi bi-pen"></span> </a>
                          &nbsp;
                          <a data-bs-toggle="modal" data-bs-target="#modalDeleteDetail<?php echo $data['idDC'] ?>" class="btn btn-danger"><span class="bi bi-x-lg"></span> </a>
                        </td>
                      </tr>
                    <?php $nombre++;
                      include('modal_include/ModalmodifierVente.php');
                    } ?>
                    </tr>
                  </tbody>
                </table>
                <ul class="pagination">
                  <?php // if($page_no > 1){ echo "<li><a href='?page_no=1'>First Page</a></li>"; } 
                  ?>

                  <li <?php if ($page_no <= 1) {
                        echo "class=' page-item disabled'";
                      } ?>>
                    <a class='page-link prevnext' <?php if ($page_no > 1) {
                                                    echo "href='detail_vente.php?idC=$idCom&page_no=$previous_page&des=$des'";
                                                  } ?>>Previous</a>
                  </li>

                  <?php
                  if ($total_no_of_pages <= 10) {
                    for ($counter = 1; $counter <= $total_no_of_pages; $counter++) {
                      if ($counter == $page_no) {
                        echo "<li class='active class='page-item''><a class='page-link'>$counter</a></li>";
                      } else {
                        echo "<li class='page-item'><a class='page-link' href='detail_vente.php?idC=$idCom&page_no=$counter&des=$des'>$counter</a></li>";
                      }
                    }
                  } elseif ($total_no_of_pages > 10) {

                    if ($page_no <= 4) {
                      for ($counter = 1; $counter < 8; $counter++) {
                        if ($counter == $page_no) {
                          echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                        } else {
                          echo "<li class='page-item'><a class='page-link' href='detail_vente.php?idC=$idCom&page_no=$counter&des=$des'>$counter</a></li>";
                        }
                      }
                      echo "<li class='page-item'><a class='page-link'>...</a></li>";
                      echo "<li class='page-item'><a class='page-link' href='detail_vente.php?idC=$idCom&page_no=$second_last&des=$des'>$second_last</a></li>";
                      echo "<li class='page-item'><a class='page-link' href='detail_vente.php?idC=$idCom&page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                    } elseif ($page_no > 4 && $page_no < $total_no_of_pages - 4) {
                      echo "<li class='page-item'><a class='page-link' href='detail_vente.php?idC=$idCom&page_no=1&des=$des'>1</a></li>";
                      echo "<li class='page-item'><a class='page-link' href='detail_vente.php?idC=$idCom&page_no=2&des=$des'>2</a></li>";
                      echo "<li class='page-item'><a class='page-link'>...</a></li>";
                      for ($counter = $page_no - $adjacents; $counter <= $page_no + $adjacents; $counter++) {
                        if ($counter == $page_no) {
                          echo "<li class='active'><a class='page-link'>$counter</a></li>";
                        } else {
                          echo "<li class='page-item'><a class='page-link' href='detail_vente.php?idC=$idCom&page_no=$counter&des=$des'>$counter</a></li>";
                        }
                      }
                      echo "<li class='page-item'><a class='page-link'>...</a></li>";
                      echo "<li class='page-item'><a class='page-link' href='detail_vente.php?idC=$idCom&page_no=$second_last'&des=$des>$second_last</a></li>";
                      echo "<li class='page-item'><a class='page-link' href='detail_vente.php?idC=$idCom&page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                    } else {
                      echo "<li class='page-item'><a class='page-link' href='detail_vente.php?idC=$idCom&page_no=1&des=$des'>1</a></li>";
                      echo "<li class='page-item'><a class='page-link' href='detail_vente.php?idC=$idCom&page_no=2&des=$des'>2</a></li>";
                      echo "<li class='page-item'><a class='page-link'>...</a></li>";

                      for ($counter = $total_no_of_pages - 6; $counter <= $total_no_of_pages; $counter++) {
                        if ($counter == $page_no) {
                          echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                        } else {
                          echo "<li  class='page-item'><a class='page-link' href='detail_vente.php?idC=$idCom&page_no=$counter&des=$des'>$counter</a></li>";
                        }
                      }
                    }
                  }
                  ?>

                  <li <?php if ($page_no >= $total_no_of_pages) {
                        echo "class='disabled page-item'";
                      } ?>>
                    <a class='page-link prevnext' <?php if ($page_no < $total_no_of_pages) {
                                                    echo "href='detail_vente.php?idC=$idCom&page_no=$next_page'";
                                                  } ?>>Next</a>
                  </li>
                  <?php if ($page_no < $total_no_of_pages) {
                    echo "<li class='page-item'><a class='page-link prevnext' href='detail_vente.php?idC=$idCom&page_no=$total_no_of_pages'>Last &rsaquo;&rsaquo;</a></li>";
                  } ?>
                </ul>
                <h5 style="text-align: center; background-color: #012970; color: white; padding: 5px; font-size: 25px;">TOTAL FACTURE ::: <strong><?= number_format($Quant,2,'.',' ').' FC' ?></strong></h5>
                <br>
                <h5 style="text-align: center; background-color: #012970; color: white; padding: 5px; font-size: 25px;">QUANTITE GLOBALE ::: <strong><?= number_format($QuantG,2,'.',' ').' PRODUITS' ?></strong></h5>
              </div>

            </div>
          </div><!-- End Table Detail Medoc -->

        </div>
      </div><!-- End table data -->
    </div>
  </section>

</main><!-- End #main -->

<!-- MODAL ADD DETAIL -->
<div class="modal fade" id="modalAddDetail" tabindex="-1">
  <div class="modal-dialog modal-dialog-centered">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title">Ajouter une Commande</h5>
        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
      </div>
      <div class="modal-body">
        <form method="post" action="php_include/addDetail.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

          <div class="row mb-3">
            <div class="col-md-12 col-lg-12">
              <label for="titre" class="form-label">Produit</label>
              <select class="form-select" name="idM" id="example-search">
                <?php $requeteMed = "select * from medicament inner join categorie 
                      on medicament.idCat=categorie.idCat";
                $resultatMed = $pdo->query($requeteMed);
                while ($result = $resultatMed->fetch()) { ?>
                  <option value="<?php echo $result['idM']; ?>">
                    <?php
                    echo $result['design'] . ' - Categ : ' . $result['designCat'].
                      ' - PVU : ' . $result['pvg'] . ' FC - Stock : ' . $result['stock'] . ' produits';
                    ?>
                  </option>
                <?php } ?>
              </select>
            </div>

            <div class="col-md-12 col-lg-12">
              <label for="titre" class="form-label">Quantité à vendre</label>
              <div class="input-group has-validation">
                <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                <input type="hidden" name="idC" value="<?php echo $idCom ?>" class="form-control" id="titre" required>
                <input type="number" name="qte" class="form-control" id="titre" required>
                <div class="invalid-feedback">Veillez Choisir la quantité SVP !</div>
              </div>
            </div>
          </div>

          <div class="modal-footer">
            <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
            <button type="submit" name="addComBtn" onclick="document.fo.submit()" class="btnModSave">Enregistrer</button>
          </div>
        </form><!-- End Change Password Form -->
      </div>

    </div>
  </div>
</div>
<!-- Footer et importation JavaScript -->
<?php include("../include/footer.php"); ?>

</body>

</html>