<?php
session_start();
require_once('../../include/connexiondb.php');
require_once('../../include/fonctionPrint.php');

// Fonction pour insérer ou mettre à jour les données d'un élève dans la table spécifiée
function insertDecision($pdo, $idI)
{
    // L'enregistrement n'existe pas, effectuer une insertion
    $insertQuery = "DELETE FROM t_decision WHERE idI=:idI";

    $stmt = $pdo->prepare($insertQuery);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);

    return $stmt->execute();
}

function insertRedevable($pdo, $idI, $idC, $idA)
{
    // L'enregistrement n'existe pas, effectuer une insertion
    $insertQuery = "DELETE FROM t_redevable WHERE idI:idI AND idC=:idC AND idA=:idA";

    $stmt = $pdo->prepare($insertQuery);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
    $stmt->bindParam(':idC', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idA', $idA, PDO::PARAM_INT);

    return $stmt->execute();
}

function insertInscrit($pdo, $numMat, $idC)
{
    // L'enregistrement n'existe pas, effectuer une insertion
    $insertQuery = "DELETE FROM t_inscrit WHERE numMat=:numMat AND idC=:idC";
    $stmt = $pdo->prepare($insertQuery);
    $stmt->bindParam(':numMat', $numMat, PDO::PARAM_STR);
    $stmt->bindParam(':idC', $idC, PDO::PARAM_STR);

    return $stmt->execute();
}

// Soumission du formulaire
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['idClasse']) && isset($_POST['idAnnee'])) {
        $idC = $_POST['idClasse'];
        $idA = $_POST['idAnnee'];
        $annee = $idA;
        $numMat = $_POST['numMat'];

        //Autre
        $idI = $_POST['idI'];
        $idC_ = $_POST["idC"];
        $idA_ = $_POST["idA"];
        $idUser = $_SESSION['id'];

        if ($decJury == "En cours de traitement") {
            // Appeler la fonction pour insérer ou mettre à jour
            insertDecision($pdo, $idI);
            //Vérification de la redevabilité
        } else {
            // Appeler la fonction pour insérer ou mettre à jour
            insertDecision($pdo, $idI);
            insertInscrit($pdo, $numMat, $idC_);

            if ($redChamp > 0) {
                // Appeler la fonction pour insérer ou mettre à jour
                insertRedevable($pdo, $idI, $idC, $idA);
            }
        }

        // Rediriger ou afficher un message de confirmation après l'enregistrement/mise à jour
        $msg_erreur = "Décisions du Jury supprimées avec succès";
        header("Location:../decision.php?succes=$msg_erreur");
    } else {
        $msg_erreur = "Il y a une erreur lors de l'initialisation des décisions du Jury.";
        header("Location:../decision.php?erreur=$msg_erreur");
    }
}
