<?php
session_start();
require_once('../../include/connexiondb.php');

// Fonction pour insérer ou mettre à jour les données d'un élève dans la table spécifiée
function insertOrUpdateDecision($pdo, $idI, $idC, $idA, $pourc, $decJury)
{
    // Vérifier si l'enregistrement existe déjà
    $query = "SELECT * FROM t_decision WHERE idI = :idI";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        // L'enregistrement existe, effectuer une mise à jour
        $updateQuery = "UPDATE t_decision SET idC=:idC, idA=:idA, pourc=:pourc, decJury=:decJury WHERE idI = :idI";
        $stmt = $pdo->prepare($updateQuery);
        // Ajouter les paramètres idI et idCours pour la clause WHERE
        $stmt->bindParam(':idC', $idC, PDO::PARAM_INT);
        $stmt->bindParam(':idA', $idA, PDO::PARAM_INT);
        $stmt->bindParam(':pourc', $pourc, PDO::PARAM_STR);
        $stmt->bindParam(':decJury', $decJury, PDO::PARAM_STR);
        $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);

        return $stmt->execute();
    } else {
        // L'enregistrement n'existe pas, effectuer une insertion
        $insertQuery = "INSERT INTO t_decision (idI,idC,idA,pourc,decJury) VALUES (:idI, :idC, :idA, :pourc, :decJury)";

        $stmt = $pdo->prepare($insertQuery);
        $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
        $stmt->bindParam(':idC', $idC, PDO::PARAM_INT);
        $stmt->bindParam(':idA', $idA, PDO::PARAM_INT);
        $stmt->bindParam(':pourc', $pourc, PDO::PARAM_STR);
        $stmt->bindParam(':decJury', $decJury, PDO::PARAM_STR);

        return $stmt->execute();
    }
}

function insertOrUpdatePalmares($pdo, $idI, $idC, $idA, $pourc)
{
    // Vérifier si l'enregistrement existe déjà
    $query = "SELECT * FROM t_palmares WHERE idI = :idI AND idC = :idC AND idA = :idA";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
    $stmt->bindParam(':idC', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idA', $idA, PDO::PARAM_INT);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        // L'enregistrement existe, effectuer une mise à jour
        $updateQuery = "UPDATE t_palmares SET pourc=:pourc WHERE idI = :idI AND idC = :idC AND idA = :idA";
        $stmt = $pdo->prepare($updateQuery);

        // Ajouter les paramètres idI et idCours pour la clause WHERE
        $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
        $stmt->bindParam(':idC', $idC, PDO::PARAM_INT);
        $stmt->bindParam(':idA', $idA, PDO::PARAM_INT);
        $stmt->bindParam(':pourc', $pourc, PDO::PARAM_INT);

        return $stmt->execute();
    } else {
        // L'enregistrement n'existe pas, effectuer une insertion
        $insertQuery = "INSERT INTO t_palmares (idI, idC, idA, pourc) VALUES (:idI, :idC, :idA, :pourc)";

        $stmt = $pdo->prepare($insertQuery);
        $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
        $stmt->bindParam(':idC', $idC, PDO::PARAM_INT);
        $stmt->bindParam(':idA', $idA, PDO::PARAM_INT);
        $stmt->bindParam(':pourc', $pourc, PDO::PARAM_INT);

        return $stmt->execute();
    }
}

function insertOrUpdateRedevable($pdo, $idI, $idC, $idA, $montR)
{
    // Vérifier si l'enregistrement existe déjà
    $query = "SELECT * FROM t_redevable WHERE idI = :idI AND idC = :idC AND idA = :idA";
    $stmt = $pdo->prepare($query);
    $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
    $stmt->bindParam(':idC', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idA', $idA, PDO::PARAM_INT);
    $stmt->execute();

    if ($stmt->rowCount() > 0) {
        // L'enregistrement existe, effectuer une mise à jour
        $updateQuery = "UPDATE t_redevable SET montR=:montR WHERE idI = :idI AND idC = :idC AND idA = :idA";
        $stmt = $pdo->prepare($updateQuery);

        // Ajouter les paramètres idI et idCours pour la clause WHERE
        $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
        $stmt->bindParam(':idC', $idC, PDO::PARAM_INT);
        $stmt->bindParam(':idA', $idA, PDO::PARAM_INT);
        $stmt->bindParam(':montR', $montR, PDO::PARAM_INT);

        return $stmt->execute();
    } else {
        // L'enregistrement n'existe pas, effectuer une insertion
        $insertQuery = "INSERT INTO t_redevable (idI, idC, idA, montR) VALUES (:idI, :idC, :idA, :montR)";

        $stmt = $pdo->prepare($insertQuery);
        $stmt->bindParam(':idI', $idI, PDO::PARAM_INT);
        $stmt->bindParam(':idC', $idC, PDO::PARAM_INT);
        $stmt->bindParam(':idA', $idA, PDO::PARAM_INT);
        $stmt->bindParam(':montR', $montR, PDO::PARAM_INT);

        return $stmt->execute();
    }
}

function insertOrUpdateInscrit($pdo, $idI, $idC, $idA, $idUser, $catEcole)
{
    //Recuperation des informations de l'eleve
    $rqIn = "SELECT * FROM t_inscrit WHERE idI='$idI'";
    $stmIns = $pdo->query($rqIn)->fetch();
    $photo = $stmIns['photo'];
    $nom = $stmIns['nom'];
    $nation = $stmIns['nation'];
    $sexe = $stmIns['sexe'];
    $ln = $stmIns['ln'];
    $dn = $stmIns['dn'];
    $ep = $stmIns['ep'];
    $nomP = $stmIns['nomP'];
    $profP = $stmIns['profP'];
    $telP = $stmIns['telP'];
    $nomM = $stmIns['nomM'];
    $profM = $stmIns['profM'];
    $telM = $stmIns['telM'];
    $pD = $stmIns['pD'];
    $trans = $stmIns['trans'];
    $hop = $stmIns['hop'];
    $adresse = $stmIns['adresse'];
    $numMat = $stmIns['numMat'];
    $etatI = $stmIns['etatI'];
    // L'enregistrement n'existe pas, effectuer une insertion
    $insertQuery = "INSERT INTO t_inscrit 
     (idC,idA,idUser,photo,nom,nation,sexe,ln,dn,ep,nomP,profP,telP,nomM,profM,telM,pD,trans,hop,adresse,numMat,catEcole,etatI) 
     VALUES (:idC,:idA,:idUser,:photo,:nom,:nation,:sexe,:ln,:dn,:ep,:nomP,:profP,:telP,:nomM,:profM,:telM,:pD,:trans,:hop,:adresse,:numMat,:catEcole,:etatI)";
    $stmt = $pdo->prepare($insertQuery);
    $stmt->bindParam(':idC', $idC, PDO::PARAM_INT);
    $stmt->bindParam(':idA', $idA, PDO::PARAM_INT);
    $stmt->bindParam(':idUser', $idUser, PDO::PARAM_INT);
    $stmt->bindParam(':photo', $photo, PDO::PARAM_STR);
    $stmt->bindParam(':nom', $nom, PDO::PARAM_STR);
    $stmt->bindParam(':nation', $nation, PDO::PARAM_STR);
    $stmt->bindParam(':sexe', $sexe, PDO::PARAM_STR);
    $stmt->bindParam(':ln', $ln, PDO::PARAM_STR);
    $stmt->bindParam(':dn', $dn, PDO::PARAM_STR);
    $stmt->bindParam(':ep', $ep, PDO::PARAM_STR);
    $stmt->bindParam(':nomP', $nomP, PDO::PARAM_STR);
    $stmt->bindParam(':profP', $profP, PDO::PARAM_STR);
    $stmt->bindParam(':telP', $telP, PDO::PARAM_STR);
    $stmt->bindParam(':nomM', $nomM, PDO::PARAM_STR);
    $stmt->bindParam(':profM', $profM, PDO::PARAM_STR);
    $stmt->bindParam(':telM', $telM, PDO::PARAM_STR);
    $stmt->bindParam(':pD', $pD, PDO::PARAM_STR);
    $stmt->bindParam(':trans', $trans, PDO::PARAM_STR);
    $stmt->bindParam(':hop', $hop, PDO::PARAM_STR);
    $stmt->bindParam(':adresse', $adresse, PDO::PARAM_STR);
    $stmt->bindParam(':numMat', $numMat, PDO::PARAM_STR);
    $stmt->bindParam(':catEcole', $catEcole, PDO::PARAM_STR);
    $stmt->bindParam(':etatI', $etatI, PDO::PARAM_STR);

    return $stmt->execute();
}

// Soumission du formulaire
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    if (isset($_POST['idClasse']) && isset($_POST['idAnnee'])) {
        $idC = $_POST['idClasse'];
        $idA = $_POST['idAnnee'];

        // Récuperation de la section
        $requestSection = "SELECT * FROM t_classe WHERE idC='$idC'";
        $stmSection = $pdo->query($requestSection)->fetch();
        $sectionClasse = $stmSection['sec'];

        // Récupérer le nombre d'élèves par classe et année
        $numStudents = $pdo->query("SELECT * FROM t_inscrit
         WHERE idC='$idC' And idA='$idA'")->rowCount();

        for ($i = 1; $i <= $numStudents; $i++) {
            $idI = $_POST["idI_$i"];
            $decJury = $_POST["decJury_$i"];
            $idC_ = $_POST["idC_$i"];
            $idA_ = $_POST["idA_$i"];
            $pourc_ = $_POST["pourc_$i"];
            $numMat = $_POST["numMat_$i"];
            $idUser = $_SESSION['id'];

            $reqcatEcole = "SELECT * FROM t_classe WHERE idC='$idC_'";
            $stmcatEcole = $pdo->query($reqcatEcole)->fetch();
            $catEcole = $stmcatEcole['sec'];
            //Redevable
            $sqlRed = $pdo->query("SELECT  SUM(DISTINCT t_frais.montF) AS dejaPayer, 
            SUM(DISTINCT t_typeFrais.montTF) AS aPayer FROM  t_inscrit
            INNER JOIN t_classe ON t_inscrit.idC = t_classe.idC 
            INNER JOIN t_an ON t_inscrit.idA = t_an.idA 
            INNER JOIN t_option ON t_classe.idO = t_option.idO 
            INNER JOIN t_frais ON t_frais.idI = t_inscrit.idI 
            INNER JOIN t_typeFrais ON t_typeFrais.idTF = t_frais.idTF 
            INNER JOIN users ON t_frais.idUser = users.idUser  
            WHERE  t_inscrit.idI = '$idI' AND t_an.idA = '$idA'");
            $stmRed = $sqlRed->fetch();
            $redChamp = $stmRed['aPayer'] - $stmRed['dejaPayer'];

            if ($decJury == "En cours de traitement") {
                // Appeler la fonction pour insérer ou mettre à jour
                insertOrUpdateDecision($pdo, $idI, $idC_, $idA_, $pourc_, $decJury);
                //Vérification de la redevabilité
            } else {
                // Appeler la fonction pour insérer ou mettre à jour
                insertOrUpdateDecision($pdo, $idI, $idC_, $idA_, $pourc_, $decJury);
                insertOrUpdatePalmares($pdo, $idI, $idC, $idA, $pourc_);
                insertOrUpdateInscrit($pdo, $idI, $idC_, $idA_, $idUser, $catEcole);

                if ($redChamp > 0) {
                    // Appeler la fonction pour insérer ou mettre à jour
                    insertOrUpdateRedevable($pdo, $idI, $idC, $idA, $redChamp);
                }
            }
        }

        // Rediriger ou afficher un message de confirmation après l'enregistrement/mise à jour
        $msg_erreur = "Décisions du Jury initialisée avec succès";
        header("Location:../decision.php?succes=$msg_erreur");
    } else {
        $msg_erreur = "Il y a une erreur lors de l'initialisation des décisions du Jury.";
        header("Location:../decision.php?erreur=$msg_erreur");
    }
}
