<?php
session_start();
if (!isset($_SESSION["login"])) {
  header('Location:../index.php');
}


require_once('../include/connexiondb.php');
require_once('../include/fonctionPrint.php');
$idC = $_SESSION['idC'];
$idUser = $_SESSION['idJ'];

$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$annee = $resPgrh['idAn'];

$rqt = "SELECT *
FROM t_classe INNER JOIN t_option ON t_classe.idO = t_option.idO
WHERE t_classe.idC = '$idC'";
$setClasse = $pdo->query($rqt)->fetch();
$classeEl = $setClasse['design'] . ' ' . $setClasse['designO'] . ' ' . $setClasse['ord'];

$des = isset($_GET['des']) ? $_GET['des'] : "";
$page_no = isset($_GET['page_no']) ? $_GET['page_no'] : 1;
$total_records_per_page = 15;
$offset = ($page_no - 1) * $total_records_per_page;
$previous_page = $page_no - 1;
$next_page = $page_no + 1;
$adjacents = "2";

$requeteRecord = "SELECT count(*) AS total_records FROM t_decision
INNER JOIN t_inscrit ON t_inscrit.idI=t_decision.idI 
INNER JOIN t_classe ON t_decision.idC=t_classe.idC
INNER JOIN t_option ON t_classe.idO=t_option.idO
INNER JOIN t_an ON t_decision.idA=t_an.idA WHERE t_an.idA='$annee'
AND t_classe.idC='$idC' AND t_inscrit.nom like '%$des%'";
$total_records = $pdo->query($requeteRecord)->fetch();
$total_records = $total_records['total_records'];
$total_no_of_pages = ceil($total_records / $total_records_per_page);
$second_last = $total_no_of_pages - 1;

$requete = "SELECT * FROM t_decision
INNER JOIN t_inscrit ON t_inscrit.idI=t_decision.idI 
INNER JOIN t_classe ON t_decision.idC=t_classe.idC
INNER JOIN t_option ON t_classe.idO=t_option.idO
INNER JOIN t_an ON t_decision.idA=t_an.idA 
WHERE t_an.idA='$annee' AND t_classe.idC='$idC' AND 
t_inscrit.nom like '%$des%' ORDER BY t_inscrit.nom ASC
LIMIT $offset, $total_records_per_page";
$resultat = $pdo->query($requete);
?>

<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_agent2.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link" href="classe.php">
          <i class="bi bi-house"></i>
          <span>Classes</span>
        </a>
      </li><!-- End Dashboard Nav -->
    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Décision du Jury ::: <?= $classeEl ?></h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Acceuil</a></li>
          <li class="breadcrumb-item active">Décision du Jury</li>
        </ol>
      </nav>
      <!-- LECTURE D'ERREUR -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
          <div class="alert alert-warning" role="alert">
            <?php echo htmlspecialchars($_GET['erreur']); ?>
          </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
          <div class="alert alert-success" role="alert">
            <?php echo htmlspecialchars($_GET['succes']); ?>
          </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <section class="section dashboard">
      <div class="row">
        <!-- TAbele data -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Décision du jury <span>
                      | <button data-bs-toggle="modal" data-bs-target="#modalAdd" name="addBtn" class="btnModSave"><i class="bi bi-plus-circle-fill"></i> AJOUTER</button>
                      | <a href="menuJury.php" class="btnModClose">RETOURNER</a> </span></h5>

                  <form method="get" action="decision.php" class="searchform js__toggle">
                    <div class="input-group has-validation">
                      <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                      <input type="text" name="des" placeholder="Search..." class="form-control">
                      <button class="bi bi-search btn btn-info" type="submit"></button>
                    </div>
                  </form>

                  <table class="table">
                    <thead>
                      <tr>
                      <th scope="col">#</th>
                        <th scope="col">Elève</th>
                        <th scope="col">Pourcentage</th>
                        <th scope="col">Classe</th>
                        <th scope="col">Année</th>
                        <th scope="col">Décision</th>
                        <th scope="col">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $number = 1;
                      while ($data = $resultat->fetch()) { ?>
                        <tr>
                          <th scope="row"><?= $number ?></th>
                          <td><?php echo $data['nom'] ?></td>
                          <td><strong><?php echo $data['pourc'] ?> %</strong></td>
                          <td><?php echo $data['design'] . " " . $data['designO'] . " " . $data['ord'] ?></td>
                          <td><?php echo $data['designA'] ?></td>
                          <td>
                            <strong>
                              <?php
                                if($data['decJury']=='En cours de traitement'){
                                  ?> <span class="btn btn-warning"><?php echo $data['decJury'] ?></span> <?php
                                }elseif($data['decJury']=='Monte la classe'){
                                  ?> <span class="btn btn-success"><?php echo $data['decJury'] ?></span> <?php
                                }elseif($data['decJury']=='Double la classe'){
                                  ?> <span class="btn btn-danger"><?php echo $data['decJury'] ?></span> <?php
                                }
                              ?>
                            </strong>
                          </td>
                          <td>
                            <a data-bs-toggle="modal" data-bs-target="#modalDelete<?php echo $data['idD'] ?>" class="btn btn-danger"><span class="bi bi-x-octagon-fill"></span> </a>
                          </td>
                        </tr>

                      <?php $number++;
                      include('php_include/modalDecision.php');
                      } ?>
                    </tbody>
                  </table>

                  <ul class="pagination">
                    <?php // if($page_no > 1){ echo "<li><a href='?page_no=1'>First Page</a></li>"; } 
                    ?>

                    <li <?php if ($page_no <= 1) {
                          echo "class=' page-item disabled'";
                        } ?>>
                      <a class='page-link prevnext' <?php if ($page_no > 1) {
                                                      echo "href='decision.php?page_no=$previous_page&des=$des'";
                                                    } ?>>Previous</a>
                    </li>

                    <?php
                    if ($total_no_of_pages <= 10) {
                      for ($counter = 1; $counter <= $total_no_of_pages; $counter++) {
                        if ($counter == $page_no) {
                          echo "<li class='active class='page-item''><a class='page-link'>$counter</a></li>";
                        } else {
                          echo "<li class='page-item'><a class='page-link' href='decision.php?page_no=$counter&des=$des'>$counter</a></li>";
                        }
                      }
                    } elseif ($total_no_of_pages > 10) {

                      if ($page_no <= 4) {
                        for ($counter = 1; $counter < 8; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='decision.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='decision.php?page_no=$second_last&des=$des'>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='decision.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } elseif ($page_no > 4 && $page_no < $total_no_of_pages - 4) {
                        echo "<li class='page-item'><a class='page-link' href='decision.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='decision.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        for ($counter = $page_no - $adjacents; $counter <= $page_no + $adjacents; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='decision.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='decision.php?page_no=$second_last'&des=$des>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='decision.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } else {
                        echo "<li class='page-item'><a class='page-link' href='decision.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='decision.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";

                        for ($counter = $total_no_of_pages - 6; $counter <= $total_no_of_pages; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li  class='page-item'><a class='page-link' href='decision.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                      }
                    }
                    ?>

                    <li <?php if ($page_no >= $total_no_of_pages) {
                          echo "class='disabled page-item'";
                        } ?>>
                      <a class='page-link prevnext' <?php if ($page_no < $total_no_of_pages) {
                                                      echo "href='decision.php?page_no=$next_page'";
                                                    } ?>>Next</a>
                    </li>
                    <?php if ($page_no < $total_no_of_pages) {
                      echo "<li class='page-item'><a class='page-link prevnext' href='decision.php?page_no=$total_no_of_pages'>Last &rsaquo;&rsaquo;</a></li>";
                    }
                    ?>
                  </ul>

                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->
      </div>
    </section>

  </main><!-- End #main -->

  <!-- MODAL ADD DECISION -->
  <div class="modal fade" id="modalAdd" tabindex="-1">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Ajouter une décision</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="php_include/addDecision.php" class="tab-pane pt-3 needs-validation" novalidate>

            <div class="row mb-3">

              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Elève</label>
                <input type="hidden" value="<?= $idC ?>" name="idClasse">
                <input type="hidden" value="<?= $annee ?>" name="idAnnee">
                <select class="form-select search-classe" name="idI">
                  <?php
                  $req = "SELECT * FROM t_inscrit WHERE idC = '$idC' AND idA = '$annee'";
                  $stm = $pdo->query($req);
                 
                  while ($resStm = $stm->fetch()) {
                    
                    $idIns = $resStm['idI'];
                     
                    $cat = $resStm['catEcole'];
                    /*
                    if ($cat == 'Maternelle') {
                      //Mes totaux
                      $totalCote1 = getTotCotePerMat($pdo, $idIns, $annee, 'P1');
                      $totalCote2 = getTotCotePerMat($pdo, $idIns, $annee, 'P2');
                      $totalCote3 = getTotCotePerMat($pdo, $idIns, $annee, 'P3');
                      $totalMaxPer = getTotCoteMaxMat($pdo, $idIns, $annee);
                      //Pourcentage
                      $pourc = round((($totalCote1 + $totalCote2 + $totalCote3) / ($totalMaxPer * 3)) * 100, 2);
                    } elseif ($cat == 'Primaire') {
                      //Mes totaux
                      $totalCote1 = getTotCotePerPri($pdo, $idIns, $annee, 'P1');
                      $totalCote2 = getTotCotePerPri($pdo, $idIns, $annee, 'P2');
                      $totalCote3 = getTotCotePerPri($pdo, $idIns, $annee, 'Ex1');
                      $totalCote4 = getTotCotePerPri($pdo, $idIns, $annee, 'P3');
                      $totalCote5 = getTotCotePerPri($pdo, $idIns, $annee, 'P4');
                      $totalCote6 = getTotCotePerPri($pdo, $idIns, $annee, 'Ex2');
                      $totalCote7 = getTotCotePerPri($pdo, $idIns, $annee, 'P5');
                      $totalCote8 = getTotCotePerPri($pdo, $idIns, $annee, 'P6');
                      $totalCote9 = getTotCotePerPri($pdo, $idIns, $annee, 'Ex3');
                      $totalMaxPer = getTotCoteMaxPri($pdo, $idIns, $annee);
                      $totalMaxEx = getTotExMaxPri($pdo, $idIns, $annee);
                      //Pourcentage
                      $pourc = round((($totalCote1 + $totalCote2 + $totalCote3 + $totalCote4 + $totalCote5 + $totalCote6 + $totalCote7 + $totalCote8 + $totalCote9) / (($totalMaxPer * 2 + $totalMaxEx) * 3)) * 100, 2);
                    } elseif ($cat == 'Secondaire') {
                      //Mes totaux
                      $totalCote1 = getTotCotePerSec($pdo, $idIns, $annee, 'P1');
                      $totalCote2 = getTotCotePerSec($pdo, $idIns, $annee, 'P2');
                      $totalCote3 = getTotCotePerSec($pdo, $idIns, $annee, 'Ex1');
                      $totalCote4 = getTotCotePerSec($pdo, $idIns, $annee, 'P3');
                      $totalCote5 = getTotCotePerSec($pdo, $idIns, $annee, 'P4');
                      $totalCote6 = getTotCotePerSec($pdo, $idIns, $annee, 'Ex2');
                      $totalMaxPer = getTotCoteMaxSec($pdo, $idIns, $annee);
                      $totalMaxEx = getTotExMaxSec($pdo, $idIns, $annee);
                      //Pourcentage
                      $pourc = round((($totalCote1 + $totalCote2 + $totalCote3 + $totalCote4 + $totalCote5 + $totalCote6) / (($totalMaxPer * 2 + $totalMaxEx) * 2)) * 100, 2);
                    }
                    */
                    $pourc="30";
                  ?>
                    <option value="<?php echo $idIns ?>">
                      <?php //echo 'Elève : ' . $resStm['nom'] . ' - Pourcentage : ' . $pourc . ' %' ?>
                      <?php echo 'Elève : ' . $resStm['nom'] ?>
                    </option>
                  <?php } ?>
                </select>
              </div>

              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Décision</label>
                <select name="decJury" class="form-select" required>
                  <option disabled>Sélectionnez une décision</option>
                  <option value="En cours de traitement">En cours de traitement</option>
                  <option value="Monte la classe">Monte la classe</option>
                  <option value="Double la classe">Double la classe</option>
                </select>
              </div>

              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Classe</label>
                <select class="form-select idClasse" name="idC">
                  <option disabled>Sélectionnez une classe</option>
                  <?php
                  $requeteAg = "SELECT * FROM t_classe INNER JOIN t_option
                                ON t_option.idO=t_classe.idO ORDER BY design ASC";
                  $resultatAg = $pdo->query($requeteAg);
                  while ($result = $resultatAg->fetch()) { ?>
                    <option value="<?php echo $result['idC']; ?>" <?php if ($result['idC'] === $idC) echo "Selected" ?>>
                      <?php echo $result['design'] . " " . $result['designO'] . " " . $result['ord'] ?>
                    </option>
                  <?php } ?>
                </select>
              </div>

              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Année Scolaire</label>
                <select class="form-select" name="idA">
                  <option disabled>Sélectionnez une année</option>
                  <?php
                  $requeteAg = "SELECT * FROM t_an";
                  $resultatAg = $pdo->query($requeteAg);
                  while ($result = $resultatAg->fetch()) { ?>
                    <option value="<?php echo $result['idA']; ?>" <?php if ($result['idA'] === $annee) echo "Selected" ?>>
                      <?php echo $result['designA'] ?>
                    </option>
                  <?php } ?>
                </select>
              </div>

            </div>

            <div class="modal-footer">
              <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
              <button type="submit" name="addLDBtn" onclick="document.fo.submit()" class="btnModSave">Enregistrer</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal ADD DECISION-->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>