<?php
session_start();
if (!isset($_SESSION["login"]) && !isset($_SESSION['etat'])) {
  header('Location:../index.php');
}

require_once('../include/connexiondb.php');
$idUser = $_SESSION['id'];
$des = isset($_GET['des']) ? $_GET['des'] : "";
$page_no = isset($_GET['page_no']) ? $_GET['page_no'] : 1;
$total_records_per_page = 3;
$offset = ($page_no - 1) * $total_records_per_page;
$previous_page = $page_no - 1;
$next_page = $page_no + 1;
$adjacents = "2";

$requeteRecord = "SELECT count(*) AS total_records FROM agent where nomA like '%$des%'";
$total_records = $pdo->query($requeteRecord)->fetch();
$total_records = $total_records['total_records'];
$total_no_of_pages = ceil($total_records / $total_records_per_page);
$second_last = $total_no_of_pages - 1;

$requete = "SELECT * FROM agent where nomA like '%$des%' ORDER BY nomA ASC
LIMIT $offset, $total_records_per_page";
$resultat = $pdo->query($requete);

?>
<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_agent.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">

    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link " href="agent.php">
          <i class="bi bi-person-rolodex"></i>
          <span>Agents</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="pres.php">
          <i class="bi bi-person-rolodex"></i>
          <span>Présences</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="conge.php">
          <i class="bi bi-person-rolodex"></i>
          <span>Congés</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="avance.php">
          <i class="bi bi-currency-exchange"></i>
          <span>Avances</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="salaire.php">
          <i class="bi bi-currency-exchange"></i>
          <span>Paiements</span>
        </a>
      </li><!-- End ventes Page Nav -->
    </ul>

  </aside><!-- End Sidebar-->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Employés</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
          <li class="breadcrumb-item active">Employés</li>
        </ol>
      </nav>
      <!-- Message d'erreur -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
          <div class="alert alert-warning" role="alert">
            <?php echo htmlspecialchars($_GET['erreur']); ?>
          </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
          <div class="alert alert-success" role="alert">
            <?php echo htmlspecialchars($_GET['succes']); ?>
          </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">
        <!-- TAbele data -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Gestion des employés <span>| <a data-bs-toggle="modal" data-bs-target="#modalAddAgent" class="btn btn-success"><i class="bi bi-plus-circle-fill"></i> AJOUTER</a>
                      | <a href="../include/listAgentGrh.php" class="btn btn-warning"><i class="bi bi-printer-fill"></i> IMPRIMER </a>
                      | <a data-bs-toggle="modal" data-bs-target="#modalMessageAgent" class="btn btn-info"><i class="bi bi-chat-dots-fill"></i> MESSAGE </a></span></h5>

                  <form method="get" action="agent.php" class="searchform js__toggle">
                    <div class="input-group has-validation">
                      <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                      <input type="text" name="des" placeholder="Search..." class="form-control">
                      <button class="bi bi-search btn btn-info" type="submit"></button>
                    </div>
                  </form>

                  <table class="table">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Nom</th>
                        <th scope="col">Fonction</th>
                        <th scope="col">Niveau</th>
                        <th scope="col">Salaire</th>
                        <th scope="col">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $number = 1;
                      while ($data = $resultat->fetch()) { ?>
                        <tr>
                          <th scope="row"><?= $number ?></th>
                          <td><?php echo $data['nomA'] ?></td>
                          <td><?php echo $data['foncA'] ?></td>
                          <td><?php echo $data['nivA'] ?></td>
                          <td><strong><?php echo number_format($data['salA'], 2, '.', ' ') ?> $</strong></td>
                          <td>
                            <a data-bs-toggle="modal" data-bs-target="#modalUpdateAgent<?php echo $data['idA'] ?>" class="btn btn-primary"><span class="bi bi-pencil-square"></span> </a>
                            &nbsp;
                            <?php
                            if ($data['etatA'] == 'Hors service')
                              echo "<span class='btn btn-warning'> <i class='bi bi-x-circle-fill'></i> </span>";
                            else
                              echo "<span class='btn btn-success'> <i class='bi bi-check-circle-fill'></i> </span>";
                            ?>
                            &nbsp;
                            <a data-bs-toggle="modal" data-bs-target="#modalEnvoyerMessage<?php echo $data['idA'] ?>" class="btn btn-info"><span class="bi bi-chat-dots-fill"></span></a>
                          </td>
                        </tr>
                      <?php $number++;
                        include('modal_include/ModalmodifierPersonnel.php');
                      } ?>
                    </tbody>
                  </table>

                  <ul class="pagination">
                    <?php // if($page_no > 1){ echo "<li><a href='?page_no=1'>First Page</a></li>"; } 
                    ?>

                    <li <?php if ($page_no <= 1) {
                          echo "class=' page-item disabled'";
                        } ?>>
                      <a class='page-link prevnext' <?php if ($page_no > 1) {
                                                      echo "href='agent.php?page_no=$previous_page&des=$des'";
                                                    } ?>>Previous</a>
                    </li>

                    <?php
                    if ($total_no_of_pages <= 10) {
                      for ($counter = 1; $counter <= $total_no_of_pages; $counter++) {
                        if ($counter == $page_no) {
                          echo "<li class='active class='page-item''><a class='page-link'>$counter</a></li>";
                        } else {
                          echo "<li class='page-item'><a class='page-link' href='agent.php?page_no=$counter&des=$des'>$counter</a></li>";
                        }
                      }
                    } elseif ($total_no_of_pages > 10) {

                      if ($page_no <= 4) {
                        for ($counter = 1; $counter < 8; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='agent.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='agent.php?page_no=$second_last&des=$des'>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='agent.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } elseif ($page_no > 4 && $page_no < $total_no_of_pages - 4) {
                        echo "<li class='page-item'><a class='page-link' href='agent.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='agent.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        for ($counter = $page_no - $adjacents; $counter <= $page_no + $adjacents; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='agent.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='agent.php?page_no=$second_last'&des=$des>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='agent.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } else {
                        echo "<li class='page-item'><a class='page-link' href='agent.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='agent.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";

                        for ($counter = $total_no_of_pages - 6; $counter <= $total_no_of_pages; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li  class='page-item'><a class='page-link' href='agent.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                      }
                    }
                    ?>

                    <li <?php if ($page_no >= $total_no_of_pages) {
                          echo "class='disabled page-item'";
                        } ?>>
                      <a class='page-link prevnext' <?php if ($page_no < $total_no_of_pages) {
                                                      echo "href='agent.php?page_no=$next_page'";
                                                    } ?>>Next</a>
                    </li>
                    <?php if ($page_no < $total_no_of_pages) {
                      echo "<li class='page-item'><a class='page-link prevnext' href='agent.php?page_no=$total_no_of_pages'>Last &rsaquo;&rsaquo;</a></li>";
                    }
                    ?>
                  </ul>

                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->
      </div>
    </section>

  </main><!-- End #main -->

  <!-- MES DIFFERENTS MODALES -->

  <!-- MODAL ADD Agent -->
  <div class="modal fade" id="modalAddAgent" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Ajouter un agent</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="php_include/addAgent.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

            <div class="row mb-3">
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Nom</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-person"></i></span>
                  <input type="text" name="nomA" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez saisir le nom SVP !</div>
                </div>
              </div>

              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Niveau</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-globe"></i></span>
                  <select class="form-control" name="nivA">
                    <option value="Maternelle">Maternelle</option>
                    <option value="Primaire">Primaire</option>
                    <option value="Secondaire">Secondaire</option>
                  </select>
                </div>
              </div>
            </div>

            <div class="row mb-3">
              <div class="col-md-6 col-lg-6">
                <label for="titre" class="form-label">Sexe</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-person"></i></span>
                  <select name="sexA" id="titre" class="form-control" required>
                    <option value="Masculin">Masculin</option>
                    <option value="Feminin">Feminin</option>
                  </select>
                  <div class="invalid-feedback">Veillez choisir le sexe SVP !</div>
                </div>
              </div>

              <div class="col-md-6 col-lg-6">
                <label for="titre" class="form-label">Civilité</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-person"></i></span>
                  <select name="civA" id="titre" class="form-control" required>
                    <option value="Celibataire">Celibataire</option>
                    <option value="Marié(e)">Marié(e)</option>
                    <option value="Veuf(ve)">Veuf(ve)</option>
                  </select>
                  <div class="invalid-feedback">Veillez choisir la civilité SVP !</div>
                </div>
              </div>
              <div class="col-md-6 col-lg-6">
                <label for="titre" class="form-label">Téléphone</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-phone"></i></span>
                  <input type="text" name="telA" class="form-control" id="titre">
                  <div class="invalid-feedback">Veillez saisir le téléphone SVP !</div>
                </div>
              </div>
              <div class="col-md-6 col-lg-6">
                <label for="titre" class="form-label">Fonction</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-bookmark"></i></span>
                  <input type="text" name="foncA" class="form-control" id="titre">
                  <div class="invalid-feedback">Veillez saisir la fonction SVP !</div>
                </div>
              </div>

            </div>
            <div class="row mb-3">
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Adresse</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-globe"></i></span>
                  <input type="text" name="adA" class="form-control" id="titre">
                  <div class="invalid-feedback">Veillez saisir l'adresse SVP !</div>
                </div>
              </div>
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Salaire</label>
                <div class="input-group has-validation">
                  <span class="input-group-text" id="inputGroupPrepend"><i>En Dollar</i></span>
                  <input type="text" name="salA" class="form-control" id="titre" required>
                  <div class="invalid-feedback">Veillez saisir le salaire SVP !</div>
                </div>
              </div>
            </div>

            <div class="modal-footer">
              <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
              <button type="submit" name="addAgentBtn" onclick="document.fo.submit()" class="btnModSave">Enregistrer</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal ADD CLIENT-->

  <!-- MODAL ADD Agent -->
  <div class="modal fade" id="modalMessageAgent" tabindex="-1">
    <div class="modal-dialog modal-lg">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Communication Enseignant</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <div class="row">
            <div class="col-lg-12">
              <form action="php_include/addCommunique.php" method="post" class="needs-validation" novalidate>
                <div class="row mb-3">
                  <div class="col-md-12 col-lg-12">
                    <div class="form-outline">
                      <label class="form-label" for="textAreaExample">Message à envoyer</label>
                      <textarea class="form-control" name="msg" id="textAreaExample1" rows="5" required></textarea>
                    </div>
                  </div>
                </div>

                <div class="modal-footer">
                  <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
                  <button type="submit" name="addMsgTousEnseignantBtn" onclick="document.fo.submit()" class="btnModSave">Envoyer Message</button>
                </div>
              </form>
            </div>
          </div>
        </div>

      </div>
    </div>
  </div><!-- End Modal ADD CLIENT-->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>