<?php 
session_start();
if(!isset($_SESSION["login"]) && !isset($_SESSION['etat'])){
  header('Location:../index.php');
}
$id = $_SESSION["id"];
require_once('../include/connexiondb.php');
require_once('php_include/some_fonctions.php');

// Recuperation des coordonnées GRH
$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$retC = $resPgrh['retC'];
$retF = $resPgrh['retF'];
$hFerm = $resPgrh['hFerm'];
// Ajouter une retenue sur fin Congé non signalé
$LeoDate = date('Y-m-d');
$sqlConge = "UPDATE conge SET `ret`=? WHERE
 fin < ? AND etatC = ?";
$reqConge = $pdo->prepare($sqlConge);
$reqConge->execute([$retC,$LeoDate,'En Conge']);
//Fin Ajouter une retenue sur fin Congé non signalé

// Ajouter une retenue sur une sortie non signalée
$heureSystem = date('H:i:s');
$dateSystem = date('Y-m-d');
if($hFerm<=$heureSystem){
  $sqlPresence = "UPDATE presence SET `rhs`=?
   WHERE hS =? AND eP =? AND dateP =?";
  $reqPresence = $pdo->prepare($sqlPresence);
  $reqPresence->execute([$retF,'00:00:00',0,$dateSystem]);
}
?>

<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_agent.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">

    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="agent.php">
          <i class="bi bi-person-rolodex"></i>
          <span>Agents</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="pres.php">
        <i class="bi bi-person-rolodex"></i>
          <span>Présences</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="conge.php">
        <i class="bi bi-person-rolodex"></i>
          <span>Congés</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="avance.php">
          <i class="bi bi-currency-exchange"></i>
          <span>Avances</span>
        </a>
      </li><!-- End ventes Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="salaire.php">
          <i class="bi bi-currency-exchange"></i>
          <span>Paiements</span>
        </a>
      </li><!-- End ventes Page Nav -->
    </ul>

  </aside><!-- End Sidebar-->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1><strong>GRH</strong> :: Tableau de bord</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Acceuil</a></li>
          <li class="breadcrumb-item active">Tableau de bord</li>
        </ol>
      </nav>
      <!-- LECTURE D'ERREUR -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
        <div class="alert alert-warning" role="alert">
          <?php echo htmlspecialchars($_GET['erreur']); ?>
        </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
        <div class="alert alert-success" role="alert">
          <?php echo htmlspecialchars($_GET['succes']); ?>
        </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">

        <!-- Left side columns -->
        <div class="col-lg-12">
          <div class="row">

            <!-- Agent Card -->
            <div class="col-xxl-4 col-md-4">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Employés <span>| Tous</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-person-square"></i>
                    </div>
                    <div class="ps-3">
                      <h6><?= getNbAgent($pdo) ?></h6>
                      <span class="text-success small pt-1 fw-bold"> <a href="agent.php">employés</a> </span>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End Agent Card -->

            <!-- Présence Card -->
            <div class="col-xxl-4 col-md-4">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Présence Journalière <span>| Toutes</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-check-circle-fill"></i>
                    </div>
                    <div class="ps-3">
                      <h6><?= getNbPresence($pdo) ?></h6>
                      <span class="text-success small pt-1 fw-bold"> <a href="pres.php">présence</a> </span>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End Presence Card -->

            <!-- Crédits Card -->
            <div class="col-xxl-4 col-md-4">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Avances <span>| Salaires</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-3">
                      <h6><?= getNbAvance($pdo) ?></h6>
                      <span class="text-success small pt-1 fw-bold"> <a href="avance.php">avances</a> </span>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End Crédits Card -->

            <!-- Crédits Card -->
            <div class="col-xxl-4 col-md-4">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Congés <span>| Tous</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-credit-card-fill"></i>
                    </div>
                    <div class="ps-3">
                      <h6><?= getNbConge($pdo) ?></h6>
                      <span class="text-success small pt-1 fw-bold"> <a href="conge.php">congés</a> </span>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End Crédits Card -->

          </div>
        </div><!-- End Left side columns -->

      </div>
    </section>

  </main><!-- End #main -->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>