<?php
session_start();
if (!isset($_SESSION["login"])) {
  header('Location:../index.php');
}

require_once('../include/connexiondb.php');
$idUser = $_SESSION['id'];

$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$ResultmaxAS = $resPgrh['idAn'];

$requete = "SELECT * FROM t_classe INNER JOIN t_option ON t_classe.idO=t_option.idO
 ORDER BY t_classe.design ";
$resultat = $pdo->query($requete);

?>
<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_agent2.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="ld.php">
          <i class="bi bi-slack"></i>
          <span>Prévision budgetaire</span>
        </a>
      </li><!-- End Classe Page Nav -->

      <li class="nav-item">
        <a class="nav-link" href="rec.php">
          <i class="bi bi-slack"></i>
          <span>Recouvrement</span>
        </a>
      </li><!-- End Classe Page Nav -->

    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Frais Scolaires par Classe</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
          <li class="breadcrumb-item active">Frais Scolaires par Classe</li>
        </ol>
      </nav>
      <!-- Message d'erreur -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
          <div class="alert alert-warning" role="alert">
            <?php echo htmlspecialchars($_GET['erreur']); ?>
          </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
          <div class="alert alert-success" role="alert">
            <?php echo htmlspecialchars($_GET['succes']); ?>
          </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">
        <!-- TAbele data -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Liste des classes <span>|
                      <a data-bs-toggle="modal" data-bs-target="#modalPrintRec" class="btn btn-warning"><i class="bi bi-printer-fill"></i> RECOUVREMENTS</a>
                      | <a data-bs-toggle="modal" data-bs-target="#modalPrintRed" class="btn btn-danger"><i class="bi bi-printer-fill"></i> REDEVABILITES</a>
                      | <a data-bs-toggle="modal" data-bs-target="#modalPrintFrais" class="btn btn-info"><i class="bi bi-printer-fill"></i> LISTE DES FRAIS</a> </span></h5>

                  <table class="table datatable">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Désignation</th>
                        <th scope="col">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $number = 1;
                      while ($data = $resultat->fetch()) { ?>
                        <tr>
                          <th scope="row"><?= $number ?></th>
                          <td><?php echo $data['design'] . " " . $data['designO'] . " " . $data['ord'] ?></td>
                          <td>
                            <a href="listeFraisByClasse.php?classe=<?= $data['idC'] ?>" class="btn btn-primary"><span class="bi bi-check-all"></span> Afficher les Frais</a>
                            <a href="../include/recouvrePaieFinClasse.php?idC=<?= $data['idC'] ?>" class="btn btn-danger"><span class="bi bi-printer-fill"></span> Recouvrement</a>
                            <a href="../include/listeFraisClasse.php?idC=<?= $data['idC'] ?>&idA=<?= $ResultmaxAS ?>" class="btn btn-info"><span class="bi bi-printer-fill"></span> Frais</a>
                          </td>
                        </tr>
                      <?php $number++;
                      } ?>
                    </tbody>
                  </table>

                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->
      </div>
    </section>

  </main><!-- End #main -->

  <!-- MODAL SUIVI -->
  <div class="modal fade" id="modalPrintRec" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Recouvrement annuel</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="../include/recouvrePaieFinGlobal.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

            <div class="row mb-3">
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Année Scolaire</label>
                <select class="form-select" name="idA" required>
                  <?php
                  $reqAn = "SELECT * FROM t_an ORDER BY designA ASC";
                  $resAn = $pdo->query($reqAn);
                  while ($stmAn = $resAn->fetch()) { ?>
                    <option value="<?php echo $stmAn['idA']; ?>">
                      <?php echo $stmAn['designA'] ?>
                    </option>
                  <?php }
                  ?>
                </select>
              </div>
            </div>

            <div class="modal-footer">
              <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
              <button type="submit" name="anneeBtn" onclick="document.fo.submit()" class="btnModSave">IMPRIMER</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal SUIVI -->

  <!-- MODAL SUIVI -->
  <div class="modal fade" id="modalPrintFrais" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Liste des frais à payer pour une année</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="../include/listeFraisAn.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

            <div class="row mb-3">
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Année Scolaire</label>
                <select class="form-select" name="idA" required>
                  <?php
                  $reqAn = "SELECT * FROM t_an ORDER BY designA ASC";
                  $resAn = $pdo->query($reqAn);
                  while ($stmAn = $resAn->fetch()) { ?>
                    <option value="<?php echo $stmAn['idA']; ?>">
                      <?php echo $stmAn['designA'] ?>
                    </option>
                  <?php }
                  ?>
                </select>
              </div>
            </div>

            <div class="modal-footer">
              <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
              <button type="submit" name="anneeBtn" onclick="document.fo.submit()" class="btnModSave">IMPRIMER</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal SUIVI -->

  <!-- MODAL SUIVI -->
  <div class="modal fade" id="modalPrintRed" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Rédevabilité annuelle</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
          <form method="post" action="../include/redevablePaieFin.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

            <div class="row mb-3">
              <div class="col-md-12 col-lg-12">
                <label for="titre" class="form-label">Année Scolaire</label>
                <select class="form-select" name="idA"  required>
                  <?php
                  $reqAn = "SELECT * FROM t_an ORDER BY designA ASC";
                  $resAn = $pdo->query($reqAn);
                  while ($stmAn = $resAn->fetch()) { ?>
                    <option value="<?php echo $stmAn['idA']; ?>">
                      <?php echo $stmAn['designA'] ?>
                    </option>
                  <?php }
                  ?>
                </select>
              </div>
            </div>

            <div class="modal-footer">
              <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
              <button type="submit" name="anneeBtn" onclick="document.fo.submit()" class="btnModSave">IMPRIMER</button>
            </div>
          </form><!-- End Change Password Form -->
        </div>

      </div>
    </div>
  </div><!-- End Modal SUIVI -->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>