<?php
session_start();
require_once('../../include/connexiondb.php');

if (
    isset($_POST['modifTFBtn']) &&
    isset($_POST['idTF']) &&
    isset($_POST['idC']) &&
    isset($_POST['catTF']) &&
    isset($_POST['designTF']) &&
    isset($_POST['montTF'])
) {
    // Les variables
    $idTF = $_POST['idTF'];
    $idC = $_POST['idC'];
    $catTF = $_POST['catTF'];
    $designTF = $_POST['designTF'];
    $montTF = $_POST['montTF'];

    if (is_numeric($montTF)) {
        try {
            // Update des données dans la table 
            $sql = "UPDATE t_typeFrais SET `catTF`=?, `designTF`=?, `montTF`=? WHERE `idTF`=?";
            $req = $pdo->prepare($sql);
            $req->execute([$catTF, $designTF, $montTF, $idTF]);

            // Message de succès
            $msg_success = "Type de frais modifié avec succès";
            header("Location:../listeFraisByClasse.php?succes=$msg_success&classe=$idC");
            exit;
        } catch (PDOException $e) {
            // Message d'erreur SQL
            $msg_erreur = "Erreur SQL : " . $e->getMessage();
            header("Location:../listeFraisByClasse.php?erreur=$msg_erreur&classe=$idC");
            exit;
        }
    } else {
        // Message d'erreur pour le champ montant
        $msg_erreur = "Le champ montant doit être un nombre";
        header("Location:../listeFraisByClasse.php?erreur=$msg_erreur&classe=$idC");
        exit;
    }
} else {
    // Message d'erreur pour les paramètres manquants
    $msg_error = "Il y a une erreur avec les paramètres. ";
    header("Location:../listeFraisByClasse.php?erreur=$msg_error&classe=$idC");
    exit;
}
