<?php
session_start();
if (!isset($_SESSION["login"]) && !isset($_SESSION['etat'])) {
    header('Location:../index.php');
}

require_once('../include/connexiondb.php');

$idClasse = isset($_GET['classe']) ? $_GET['classe'] : 0;

$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]);
$resPgrh = $reqPgrh->fetch();
$ResultmaxAS = $resPgrh['idAn'];

$requete = "SELECT * FROM t_typeFrais 
            INNER JOIN t_classe ON t_classe.idC = t_typeFrais.idC 
            INNER JOIN t_option ON t_classe.idO = t_option.idO 
            WHERE t_typeFrais.idC = :idClasse AND
            t_typeFrais.idA=:idAnnee ORDER BY designTF ASC";
$stmt = $pdo->prepare($requete);
$stmt->bindParam(':idClasse', $idClasse);
$stmt->bindParam(':idAnnee', $ResultmaxAS);
$stmt->execute();

if ($stmt->rowCount() > 0) {
    // Fetch overall class information
    $setClasse = $stmt->fetch(PDO::FETCH_ASSOC);
    $classeEl = $setClasse['design'] . ' ' . $setClasse['designO'] . ' ' . $setClasse['ord'];

    // Reset the pointer to the beginning of the result set
    $stmt->execute();
}
?>

<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

    <!-- ======= Header ======= -->
    <?php include("../include/header_agent2.php"); ?>
    <!-- ======= Sidebar ======= -->
    <aside id="sidebar" class="sidebar">
        <ul class="sidebar-nav" id="sidebar-nav">

            <li class="nav-item">
                <a class="nav-link collapsed" href="acceuil.php">
                    <i class="bi bi-grid"></i>
                    <span>Tableau de bord</span>
                </a>
            </li><!-- End Dashboard Nav -->

            <li class="nav-item">
                <a class="nav-link collapsed" href="ld.php">
                    <i class="bi bi-slack"></i>
                    <span>Prévision budgetaire</span>
                </a>
            </li><!-- End Classe Page Nav -->

            <li class="nav-item">
                <a class="nav-link" href="rec.php">
                    <i class="bi bi-slack"></i>
                    <span>Recouvrement</span>
                </a>
            </li><!-- End Classe Page Nav -->

        </ul>

    </aside><!-- End Sidebar -->

    <!-- Espace de travail -->
    <main id="main" class="main">

        <div class="pagetitle">
            <h1>Types des frais scolaires ::: <?= $stmt->rowCount() > 0 ? $classeEl : '' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
                    <li class="breadcrumb-item active">Types des frais scolaires</li>
                </ol>
            </nav>
            <!-- Message d'erreur -->
            <center>
                <?php if (isset($_GET['erreur'])) { ?>
                    <div class="alert alert-warning" role="alert">
                        <?php echo htmlspecialchars($_GET['erreur']); ?>
                    </div>
                <?php } ?>
                <?php if (isset($_GET['succes'])) { ?>
                    <div class="alert alert-success" role="alert">
                        <?php echo htmlspecialchars($_GET['succes']); ?>
                    </div>
                <?php } ?>
            </center>
        </div><!-- End Page Title -->

        <!-- Section Dashbord -->
        <section class="section dashboard">
            <div class="row">
                <!-- TAbele data -->
                <div class="col-lg-12">
                    <div class="row">
                        <!-- Table service -->
                        <div class="col-12">
                            <div class="card overflow-auto">

                                <div class="card-body">
                                    <h5 class="card-title">Liste des différents frais <span>| <a data-bs-toggle="modal" data-bs-target="#modalAdd" class="btn btn-success"><i class="bi bi-plus-circle-fill"></i> AJOUTER</a> </span></h5>

                                    <table class="table datatable">
                                        <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th scope="col">Type Frais</th>
                                                <th scope="col">Catégorie</th>
                                                <th scope="col">Montant</th>
                                                <th scope="col">Classe</th>
                                                <th scope="col">Actions</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php $number = 1;
                                            while ($data = $stmt->fetch(PDO::FETCH_ASSOC)) { ?>
                                                <tr>
                                                    <th scope="row"><?= $number ?></th>
                                                    <td><?php echo $data['designTF'] ?></td>
                                                    <td><?php echo $data['catTF'] ?></td>
                                                    <td><strong><?php echo $data['montTF'] . ' $' ?></strong></td>
                                                    <td><?php echo $data['design'] . " " . $data['designO'] . " " . $data['ord'] ?></td>
                                                    <td>
                                                        <a data-bs-toggle="modal" data-bs-target="#modalUpdateTypeFrais<?php echo $data['idTF'] ?>" class="btn btn-primary"><span class="bi bi-pencil-square"></span> <strong> Modifier </strong> </a>
                                                        <a data-bs-toggle="modal" data-bs-target="#modalRecouvrement<?php echo $data['idTF'] ?>" class="btn btn-danger"><span class="bi bi-ui-checks-grid"></span> Recouvrement</a>
                                                    </td>
                                                </tr>
                                            <?php $number++;
                                                include('modal_include/ModalmodifierDep.php');
                                            } ?>
                                        </tbody>
                                    </table>

                                </div>

                            </div>
                        </div><!-- End Recent messages -->

                    </div>
                </div><!-- End table data -->
            </div>
        </section>

    </main><!-- End #main -->

    <!-- MES DIFFERENTS MODALES -->

    <!-- MODAL ADD SERVICE -->
    <div class="modal fade" id="modalAdd" tabindex="-1">
        <div class="modal-dialog modal-dialog-centered">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Ajouter un frais</h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <form method="post" action="php_include/addTypeF.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

                        <div class="row mb-3">
                            <div class="col-md-12 col-lg-12">
                                <label for="titre" class="form-label">Catégorie</label>
                                <input type="hidden" name="idC" value="<?= $idClasse ?>" class="form-control" id="titre" required>
                                <input type="hidden" name="idA" value="<?= $ResultmaxAS ?>" class="form-control" id="titre" required>
                                <div class="has-validation">
                                    <select name="catTF" class="form-select">
                                        <option value="Frais scolaire">Frais scolaire</option>
                                        <option value="Frais connexe">Frais connexe</option>
                                    </select>
                                    <div class="invalid-feedback">Veillez saisir la désignation SVP !</div>
                                </div>
                            </div>
                            <div class="col-md-12 col-lg-12">
                                <label for="titre" class="form-label">Frais</label>
                                <div class="input-group has-validation">
                                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-globe"></i></span>
                                    <input type="text" name="designTF" class="form-control" id="titre" required>
                                    <div class="invalid-feedback">Veillez saisir la désignation SVP !</div>
                                </div>
                            </div>
                            <div class="col-md-12 col-lg-12">
                                <label for="titre" class="form-label">Montant</label>
                                <div class="input-group has-validation">
                                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-currency-exchange"></i></span>
                                    <input type="text" name="montTF" class="form-control" id="titre" required>
                                    <div class="invalid-feedback">Veillez saisir le Montant SVP !</div>
                                </div>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
                            <button type="submit" name="addTFBtn" onclick="document.fo.submit()" class="btnModSave">Enregistrer</button>
                        </div>
                    </form><!-- End Change Password Form -->
                </div>

            </div>
        </div>
    </div><!-- End Modal ADD SERVICE-->

    <!-- Footer et importation JavaScript -->
    <?php include("../include/footer.php"); ?>

</body>

</html>