<?php 
session_start();
if(!isset($_SESSION["login"])){
  header('Location:../index.php');
} 
require_once('../include/connexiondb.php');
$idUser = $_SESSION['id'];

//Requetes pour les info de base
$sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
$reqPgrh = $pdo->prepare($sqlPgrh);
$reqPgrh->execute([1]); 
$resPgrh = $reqPgrh->fetch();
$annee = $resPgrh['idAn'];

$rqt=$pdo->query("SELECT t_classe.idC,MIN(t_classe.design) AS design,
MIN(t_classe.sec) AS sec,MIN(t_classe.ord) AS ord,MIN(t_option.designO) AS designO
FROM t_inscrit
INNER JOIN t_classe ON t_classe.idC = t_inscrit.idC
INNER JOIN t_option ON t_classe.idO = t_option.idO   
INNER JOIN t_an ON t_inscrit.idA = t_an.idA
INNER JOIN t_cours ON t_classe.idC = t_cours.idC
INNER JOIN t_ens ON t_ens.idEns = t_cours.idEns
WHERE t_ens.idEns = '$idUser' AND t_an.idA = '$annee'
GROUP BY t_classe.idC;");

?>

<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?> 

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_agent2.php"); ?>

  <!-- Menu principal -->
 <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link" href="fc.php">
          <i class="bi bi-card-checklist"></i>
          <span>Fiches de côtes</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="preseleve.php">
          <i class="bi bi-person-check-fill"></i>
          <span>Présences des élèves</span>
        </a>
      </li><!-- End Dashboard Nav -->

    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Fiches des côtes</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Acceuil</a></li>
          <li class="breadcrumb-item active">Classes</li>
        </ol>
      </nav>
      <!-- LECTURE D'ERREUR -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
        <div class="alert alert-warning" role="alert">
          <?php echo htmlspecialchars($_GET['erreur']); ?>
        </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
        <div class="alert alert-success" role="alert">
          <?php echo htmlspecialchars($_GET['succes']); ?>
        </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">
        <?php
          while($ligne=$rqt->fetch()){
            $idClasse = $ligne['idC'];
        ?>

          <div class="col-lg-4">
            <div class="card card-primary">
              <div class="card-heading">
              <center>
                <?php
                  $sql = $pdo->prepare("SELECT COUNT(DISTINCT t_inscrit.idI) AS nombreEleves
                  FROM t_inscrit
                  INNER JOIN t_classe ON t_classe.idC = t_inscrit.idC
                  INNER JOIN t_cours ON t_classe.idC = t_cours.idC
                  INNER JOIN t_ens ON t_ens.idEns = t_cours.idEns
                  WHERE t_ens.idEns = ? AND t_classe.idC = ? AND t_inscrit.idA = ?");
                  $sql->execute([$idUser,$idClasse,$annee]);
                  $data = $sql->fetch(PDO::FETCH_ASSOC);
                  // Retourne le nombre d'élèves
                  $rs= $data['nombreEleves'];

                  $sql2=$pdo->prepare("SELECT COUNT(DISTINCT t_cours.idCours) AS nombreCours
                  FROM t_inscrit
                  INNER JOIN t_classe ON t_classe.idC = t_inscrit.idC
                  INNER JOIN t_cours ON t_classe.idC = t_cours.idC
                  INNER JOIN t_ens ON t_ens.idEns = t_cours.idEns
                  WHERE t_ens.idEns = ? AND t_classe.idC = ? AND t_cours.idA = ?");
                  $sql2->execute([$idUser,$idClasse,$annee]);
                  $data2 = $sql2->fetch(PDO::FETCH_ASSOC);

                  $rs2=$data2['nombreCours'];
                ?>
              </center>
              </div>
              <div class="card-body">
              <h5 class="card-title"><?php echo $ligne['design'].' '.$ligne['designO'].' '.$ligne['ord'];?></h5>
                <h6>
                  Nombre d'élèves : <?php echo $rs;?><br>
                  Nombre des cours : <?php echo $rs2;?>
                </h6>
              </div>
              <div class="card-footer">
              <center>
                <a href='../Ens/php_include/sessionClasse.php?idC=<?=$idClasse ?>&idJ=<?=$idUser ?>' class='btnModSave btn btn-info'> <i class="bi bi-check-all"></i> MES COURS</a><br><br>
              </center>
              </div>
            </div>
          </div>
        <?php
          }
        ?>
      </div>
    </section>

  </main><!-- End #main -->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>