<?php
    session_start();
    require_once('../../include/connexiondb.php');
    if (
        isset($_GET['idM']) && 
        isset($_GET['idC']) &&
        isset($_GET['idDC'])
    ) {
        //Les variables
        $idDC = $_GET['idDC'];
        $idM = $_GET['idM'];
        $idC = $_GET['idC'];
        $qte = 1;

        $sqlStockMedicament = "SELECT * FROM medicament WHERE idM = ?";
        $reqStockMedicament = $pdo->prepare($sqlStockMedicament);
        $reqStockMedicament->execute([$idM]);
        $resStockMedicament = $reqStockMedicament->fetch();
        $designM = $resStockMedicament['design'];
        $stock = $resStockMedicament['stock'];
        $stockMin = 0;

        $sql = "SELECT * FROM detail_commande 
            INNER JOIN commande ON commande.idC=detail_commande.idC 
            INNER JOIN medicament ON medicament.idM=detail_commande.idM 
            WHERE detail_commande.idC=? AND medicament.idM=?";
        $req = $pdo->prepare($sql);
        $req->execute([$idC,$idM]);
        $res = $req->fetch();
        $qteDetail = $res['qte'];
        $stockDetail = $res['stock'];
        $pvEnStock = $res['prixV'];

        if ($qte >= $stock) {
            $msg_erreur = "La quantité en stock pour ".$designM." est insuffisante pour cette commande";
            header("Location:../detail_vente.php?idC=$idC&erreur=$msg_erreur");
            exit;
        } elseif ($stock <= $stockMin) {
            $msg_erreur = "Vous êtes en rupture de stock pour ".$designM."";
            header("Location:../detail_vente.php?idC=$idC&erreur=$msg_erreur");
        }elseif ($qteDetail == 1) {
            $msg_erreur = "Vous ne pouvez pas reduire la quantité car sur la facture, elle n'est que d'une seule mesure";
            header("Location:../detail_vente.php?idC=$idC&erreur=$msg_erreur");
            exit;
        }else{
            //Req commande
            $sqlcOM = "SELECT * FROM commande WHERE idC = ?";
            $reqCom = $pdo->prepare($sqlcOM);
            $reqCom->execute([$idC]);
            $resCom = $reqCom->fetch();
            $sta = $resCom['statut'];

            if($sta=="Cash"){
                # Insertion des données dans la table 
                $stockModif = $stock - $qte;
                $quantDC = $qteDetail + $qte;
                $sql = "UPDATE detail_commande SET `qte`=?,`soldeIS`=?,`soldeS`=? WHERE `idDC`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$quantDC,$stock,$stockModif,$idDC]);

                # Insertion des données dans la table stock mediment
                $sql = "UPDATE medicament SET `stock`=? WHERE `idM`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$stockModif,$idM]);

                # update des données dans la table  caisse et ca
                $sqlca = "SELECT * FROM ca WHERE idDC = ?";
                $reqca = $pdo->prepare($sqlca);
                $reqca->execute([$idDC]);
                $resca = $reqca->fetch();
                $m_ca = $resca['m_ca'];

                $montantCa = $qte*$pvEnStock;

                $m_ca_actuel = $m_ca - $montantCa;
            
                $sql = "UPDATE ca SET `m_ca`=? WHERE `idDC`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$m_ca_actuel,$idDC]);

                $sqlRec = "SELECT * FROM caisse WHERE idCaisse = ?";
                $reqRec = $pdo->prepare($sqlRec);
                $reqRec->execute([1]);
                $resRech = $reqRec->fetch();
                $ventes = $resRech['ventes'];
                $depenses = $resRech['depenses'];
                $creances = $resRech['creances'];

                $vente_actuelle = $ventes - $montantCa;
                $Net = $vente_actuelle - $depenses - $creances;

                $sql = "UPDATE caisse SET `ventes`=? , `net`= ? WHERE `idCaisse`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$vente_actuelle,$Net,1]);

            }elseif($sta=="Credit"){
                # Insertion des données dans la table 
                $stockModif = $stock - $qte;
                $quantDC = $qteDetail + $qte;
                $sql = "UPDATE detail_commande SET `qte`=?,`soldeIS`=?,`soldeS`=? WHERE `idDC`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$quantDC,$stock,$stockModif,$idDC]);

                $montantCa = $qte * $pvEnStock;

                //Update Credit Table
                $sqlCred = "SELECT * FROM credit WHERE idC = ?";
                $reqCred = $pdo->prepare($sqlCred);
                $reqCred->execute([$idC]);
                $resCred = $reqCred->fetch();
                $mCred = $resCred['mCred'];
                $montantCreditTot = $mCred - $montantCa;
                $sql = "UPDATE credit SET `mCred`=?
                WHERE `idC`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$montantCreditTot,$idC]);

                # Insertion des données dans la table stock mediment
                $sql = "UPDATE medicament SET `stock`=? WHERE `idM`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$stockModif,$idM]);

                # update des données dans la table caisse
                $sqlRec = "SELECT * FROM caisse WHERE idCaisse = ?";
                $reqRec = $pdo->prepare($sqlRec);
                $reqRec->execute([1]);
                $resRech = $reqRec->fetch();
                $ventes = $resRech['ventes'];
                $depenses = $resRech['depenses'];
                $creances = $resRech['creances'];

                $creances_actuelle = $creances - $montantCa;
                $Net = $ventes - $depenses - $creances_actuelle;

                $sql = "UPDATE caisse SET `creances`=? , `net`= ? WHERE `idCaisse`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$creances_actuelle,$Net,1]);

            }elseif($sta=="Proformat"){
                $quantDC = $qteDetail + $qte;
                $sql = "UPDATE detail_commande SET `qte`=?,`soldeIS`=?,`soldeS`=? WHERE `idDC`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$quantDC,$stock,0,$idDC]);
            }
        }
        header("Location:../detail_vente.php?idC=$idC");
    }else{
        $msg_erreur = "Il y a une erreure";
        header("Location:../detail_vente.php?idC=$idC&erreur=$msg_erreur");
        exit;
    }
?>