<?php
session_start();
require_once('../../include/connexiondb.php');

if (
    isset($_POST['addSalaireBtn']) &&
    isset($_POST['idA']) &&
    isset($_POST['mS']) &&
    isset($_POST['logem']) &&
    isset($_POST['trans']) &&
    isset($_POST['idA']) &&
    isset($_POST['ipr']) &&
    isset($_POST['aS'])
) {
    //Les variables
    $idA = $_POST['idA'];
    $mS = $_POST['mS'];
    $aS = $_POST['aS'];
    $logem = $_POST['logem'];
    $trans = $_POST['trans'];
    $prime = $_POST['prime'];
    $ipr = $_POST['ipr'];
    //Agent
    $sqlAgent = "SELECT * FROM agent WHERE idA = ?";
    $reqAgent = $pdo->prepare($sqlAgent);
    $reqAgent->execute([$idA]);
    $resAgent = $reqAgent->fetch();
    $sal = $resAgent['salA'];
    $nomAgent = $resAgent['nomA'];
    //Avance
    $sqlAv = "SELECT SUM(mtAv) AS mt FROM avance
         WHERE idA = ? AND mAv = ? AND aAv = ?";
    $reqAv = $pdo->prepare($sqlAv);
    $reqAv->execute([$idA, $mS, $aS]);
    $resAv = $reqAv->fetch();
    $mtAv = $resAv['mt'] ? $resAv['mt'] : 0;
    //Présence
    $sqlPre = "SELECT SUM(rha) AS retHA,
        SUM(rhs) AS retHS FROM presence
        WHERE idA = ? AND mP = ? AND aP = ?";
    $reqPre = $pdo->prepare($sqlPre);
    $reqPre->execute([$idA, $mS, $aS]);
    $resPre = $reqPre->fetch();
    $retHA = $resPre['retHA'];
    $retHS = $resPre['retHS'];
    //Congé
    $sqlCo = "SELECT SUM(ret) AS retCo FROM conge
        WHERE idA = ? AND mC = ? AND aC = ?";
    $reqCo = $pdo->prepare($sqlCo);
    $reqCo->execute([$idA, $mS, $aS]);
    $resCo = $reqCo->fetch();
    $retCo = $resCo['retCo'];
    //Jours
    $sqlJours = "SELECT * FROM presence
        WHERE idA = ? AND mP = ? AND aP = ?";
    $reqJours = $pdo->prepare($sqlJours);
    $reqJours->execute([$idA, $mS, $aS]);
    $jours = $reqJours->rowCount();
    //Paramettres GRH
    $sqlPgrh = "SELECT * FROM pargrh WHERE idPar = ?";
    $reqPgrh = $pdo->prepare($sqlPgrh);
    $reqPgrh->execute([1]);
    $resPgrh = $reqPgrh->fetch();
    $impot = $resPgrh['impot'];
    $indem = $resPgrh['indem'];
    $retJ = $resPgrh['retJ'];
    $nbrJ = $resPgrh['nbrJ'];

    if ($jours == $nbrJ) {
        $retenuJour = 0;
    } else {
        $retenuJour = ($nbrJ - $jours) * $retJ;
    }

    //CalculSalaire
    $retN = $retHA + $retHS + $retCo + $retenuJour;
    $avN = $mtAv;
    $imp = $impot;

    $sb = $jours * $sal;
    $sbrut = $sb + $logem + $trans + $prime + $indem;
    $retenu = $ipr + $retN + $avN + $imp;
    $netS = $sbrut - $retenu;
 
    //Agent
    $sqlSal1 = "SELECT * FROM agent INNER JOIN salaire
        ON salaire.idA=agent.idA WHERE agent.`idA` = ? AND `mS` = ? AND `aS` = ?";
    $reqSal1 = $pdo->prepare($sqlSal1);
    $reqSal1->execute([$idA, $mS, $aS]);
    $resSal1 = $reqSal1->rowCount();

    if ($resSal1 > 0) {
        $msg_erreur = $nomAgent . " est deja payé pour le mois " . $mS . " - Année " . $aS;
        header("Location:../salaire.php?erreur=$msg_erreur");
        exit;
    } else {
        # Update des données dans la table 
        $sql = "INSERT INTO salaire (`idA`,`jour`,`retN`,`avN`,`imp`,`logem`,`trans`,`prime`,`ipr`,`netS`,`mS`,`aS`)
            VALUES(?,?,?,?,?,?,?,?,?,?,?,?)";
        $req = $pdo->prepare($sql);
        $req->execute([$idA, $jours, $retN, $avN, $imp, $logem, $trans, $prime, $ipr, $netS, $mS, $aS]);

        #Message de succès
        $msg_erreur = "Paiement enregistrée avec succès pour " . $nomAgent;
        header("Location:../salaire.php?succes=$msg_erreur");
    }
} else {
    $msg_erreur = "Il y a une erreure";
    header("Location:../salaire.php?erreur=$msg_erreur");
    exit;
}
