<?php
session_start();
require_once('../../include/connexiondb.php');

if (
    isset($_POST['addTFBtn']) &&
    isset($_POST['idC']) &&
    isset($_POST['niv']) &&
    isset($_POST['idA']) &&
    isset($_POST['catTF']) &&
    isset($_POST['designTF']) &&
    isset($_POST['montTF'])
) {
    //Les variables
    $idC = $_POST['idC'];
    $idA = $_POST['idA'];
    $catTF = $_POST['catTF'];
    $designTF = $_POST['designTF'];
    $montTF = $_POST['montTF'];
    $niv = $_POST['niv'];

    if (is_numeric($montTF)) {
        // Mon algo
        $sqlRec = "SELECT * FROM t_typeFrais WHERE catTF = ? 
            AND designTF = ? AND idC = ? AND idA = ?";
        $reqRec = $pdo->prepare($sqlRec);
        $reqRec->execute([$catTF, $designTF, $idC, $idA]);
        $resRech = $reqRec->rowCount();

        if ($resRech > 0) {
            $msg_erreur = "Ce type de frais existe deja dans cette classe";
            if ($niv == "Maternelle") {
                header("Location:../listeFraisMat.php?erreur=$msg_erreur&classe=$idC");
            } elseif ($niv == "Primaire") {
                header("Location:../listeFraisPri.php?erreur=$msg_erreur&classe=$idC");
            } elseif ($niv == "Secondaire") {
                header("Location:../listeFraisSec.php?erreur=$msg_erreur&classe=$idC");
            }
            exit;
        } else {
            # Update des données dans la table 
            $sql = "INSERT INTO t_typeFrais (`idA`,`idC`,`catTF`,`designTF`,`montTF`)
                VALUES(?,?,?,?,?)";
            $req = $pdo->prepare($sql);
            $req->execute([$idA,$idC, $catTF, $designTF, $montTF]);

            #Message de succès
            $msg_erreur = "Type de frais enregistré avec succès";
            if ($niv == "Maternelle") {
                header("Location:../listeFraisMat.php?succes=$msg_erreur&classe=$idC");
            } elseif ($niv == "Primaire") {
                header("Location:../listeFraisPri.php?succes=$msg_erreur&classe=$idC");
            } elseif ($niv == "Secondaire") {
                header("Location:../listeFraisSec.php?succes=$msg_erreur&classe=$idC");
            }
            exit;
        }
    } else {
        $msg_erreur = "Le champ montant doit être en numérique";
        if ($niv == "Maternelle") {
            header("Location:../listeFraisMat.php?erreur=$msg_erreur&classe=$idC");
        } elseif ($niv == "Primaire") {
            header("Location:../listeFraisPri.php?erreur=$msg_erreur&classe=$idC");
        } elseif ($niv == "Secondaire") {
            header("Location:../listeFraisSec.php?erreur=$msg_erreur&classe=$idC");
        }
        exit;
    }
} else {
    $niv = $_POST['niv'];
    $msg_erreur = "Il y a une erreure";
    if ($niv == "Maternelle") {
        header("Location:../listeFraisMat.php?erreur=$msg_erreur&classe=$idC");
    } elseif ($niv == "Primaire") {
        header("Location:../listeFraisPri.php?erreur=$msg_erreur&classe=$idC");
    } elseif ($niv == "Secondaire") {
        header("Location:../listeFraisSec.php?erreur=$msg_erreur&classe=$idC");
    }
    exit;
}
