<?php
session_start();
require_once('../../include/connexiondb.php');

// Vérifier si le formulaire a été soumis
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Récupérer les données du formulaire
    $idSC = $_POST['idSC'];
    $idCat = $_POST['idCat'];
    $designSousCat = $_POST['designSousCat'];
    $niveauSousCat = $_POST['niveauSousCat'];

    // Préparer la requête SQL de mise à jour
    $sql = "UPDATE t_sous_categ SET idCat = :idCat, designSousCat = :designSousCat,
     niveauSousCat = :niveauSousCat WHERE idSC = :idSC";

    // Préparer et exécuter la requête PDO
    $stmt = $pdo->prepare($sql);
    $stmt->bindParam(':idSC', $idSC, PDO::PARAM_INT);
    $stmt->bindParam(':idCat', $idCat, PDO::PARAM_INT);
    $stmt->bindParam(':designSousCat', $designSousCat, PDO::PARAM_STR);
    $stmt->bindParam(':niveauSousCat', $niveauSousCat, PDO::PARAM_STR);

    if ($stmt->execute()) {
        // La mise à jour a réussi
        $msg_erreur = "Catégorie modifier avec succès";
        header("Location:../scat.php?succes=$msg_erreur");
        exit();
    } else {
        // La mise à jour a échoué
        $msg_erreur = "Echec de modification";
        header("Location:../scat.php?erreur=$msg_erreur");
        exit();
    }
}

?>