<?php

session_start();
require_once('../../include/connexiondb.php');

if(isset($_POST['niv'])){

    $niv = $_POST['niv'];

    if (isset($_POST['modEnsBtn'])) {
        $idEns = $_POST['idEns'];
        $log = $_POST['log'];
    
        // Mettez à jour les champs du formulaire en utilisant une requête SQL préparée.
        $sql = "UPDATE t_ens SET loginEns = ? WHERE idEns = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$log, $idEns]);
    
        // Redirigez l'utilisateur vers une page de confirmation ou de gestion des enseignants.
        if($niv=="Maternelle"){
            $msg_erreur = "Enseignant(e) modifié avec succès";
            header("Location:../ensmat.php?succes=$msg_erreur");
            exit;
        }elseif($niv=="Primaire"){
            $msg_erreur = "Enseignant(e) modifié avec succès";
            header("Location:../enspri.php?succes=$msg_erreur");
            exit;
        }elseif($niv=="Secondaire"){
            $msg_erreur = "Enseignant(e) modifié avec succès";
            header("Location:../enssec.php?succes=$msg_erreur");
            exit;
        }
    }
    
    if (isset($_POST['photoBtn'])) {
        $idEns = $_POST['idEns'];
        $allowedExtensions = ['jpg', 'jpeg', 'png'];
        $targetDirectory = '../../uploads/'; // 
    
        $filename = $_FILES['photo']['name'];
        $fileExtension = pathinfo($filename, PATHINFO_EXTENSION);
    
        if (!in_array(strtolower($fileExtension), $allowedExtensions)) {
            if($niv=="Maternelle"){
                $msg_erreur = "Extension de fichier non autorisée. Veuillez choisir une image au format JPG, JPEG ou PNG.";
                header("Location:../ensmat.php?succes=$msg_erreur");
                exit;
            }elseif($niv=="Primaire"){
                $msg_erreur = "Extension de fichier non autorisée. Veuillez choisir une image au format JPG, JPEG ou PNG.";
                header("Location:../enspri.php?succes=$msg_erreur");
                exit;
            }elseif($niv=="Secondaire"){
                $msg_erreur = "Extension de fichier non autorisée. Veuillez choisir une image au format JPG, JPEG ou PNG.";
                header("Location:../enssec.php?succes=$msg_erreur");
                exit;
            }
        }
    
        $newFilename = uniqid("ENS-", true) . '.' . $fileExtension;
        $targetFile = $targetDirectory . $newFilename;
    
        if (move_uploaded_file($_FILES['photo']['tmp_name'], $targetFile)) {
            // Mettez à jour le champ imageEns dans la base de données.
            $sql = "UPDATE t_ens SET imageEns = ? WHERE idEns = ?";
            $stmt = $pdo->prepare($sql);
            $stmt->execute([$newFilename, $idEns]);
    
            // Redirigez l'utilisateur vers une page de confirmation ou de gestion des enseignants.
            if($niv=="Maternelle"){
                $msg_erreur = "Enseignant(e) modifié avec succès";
                header("Location:../ensmat.php?succes=$msg_erreur");
                exit;
            }elseif($niv=="Primaire"){
                $msg_erreur = "Enseignant(e) modifié avec succès";
                header("Location:../enspri.php?succes=$msg_erreur");
                exit;
            }elseif($niv=="Secondaire"){
                $msg_erreur = "Enseignant(e) modifié avec succès";
                header("Location:../enssec.php?succes=$msg_erreur");
                exit;
            }
        } else {
            if($niv=="Maternelle"){
                $msg_erreur = "Une erreur s'est produite lors de l'envoi de l'image.";
                header("Location:../ensmat.php?succes=$msg_erreur");
                exit;
            }elseif($niv=="Primaire"){
                $msg_erreur = "Une erreur s'est produite lors de l'envoi de l'image.";
                header("Location:../enspri.php?succes=$msg_erreur");
                exit;
            }elseif($niv=="Secondaire"){
                $msg_erreur = "Une erreur s'est produite lors de l'envoi de l'image.";
                header("Location:../enssec.php?succes=$msg_erreur");
                exit;
            }
        }
    }
    
    if (isset($_POST['pwBtn'])) {
        $mot_de_passe = password_hash($_POST['pw'], PASSWORD_DEFAULT); 
        $sql = "UPDATE t_ens SET pwEns = ? WHERE idEns = ?";
        $stmt = $pdo->prepare($sql);
        $stmt->execute([$mot_de_passe, $idEns]);
    
        // Redirigez l'utilisateur vers une page de confirmation ou de gestion des enseignants.
        if($niv=="Maternelle"){
            $msg_erreur = "Enseignant(e) modifié avec succès";
            header("Location:../ensmat.php?succes=$msg_erreur");
            exit;
        }elseif($niv=="Primaire"){
            $msg_erreur = "Enseignant(e) modifié avec succès";
            header("Location:../enspri.php?succes=$msg_erreur");
            exit;
        }elseif($niv=="Secondaire"){
            $msg_erreur = "Enseignant(e) modifié avec succès";
            header("Location:../enssec.php?succes=$msg_erreur");
            exit;
        }
    }
}
?>
