<?php
session_start();
require_once('../../include/connexiondb.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Récupérer les données du formulaire
    $idCat = $_POST["idCat"];
    $designCat = $_POST["designCat"];
    $niveauCat = $_POST["niveauCat"];

    try {
        // Préparer la requête SQL de mise à jour
        $sql = "UPDATE t_categ SET designCat = :designCat, niveauCat = :niveauCat WHERE idCat = :idCat";
        $stmt = $pdo->prepare($sql);

        // Liaison des paramètres
        $stmt->bindParam(":designCat", $designCat);
        $stmt->bindParam(":niveauCat", $niveauCat);
        $stmt->bindParam(":idCat", $idCat);

        // Exécuter la requête
        $stmt->execute();

        // Rediriger vers une page de confirmation ou une autre page
        $msg_erreur = "Catégorie modifiée avec succès";
        header("Location:../cat.php?succes=$msg_erreur");
        exit();
    } catch (PDOException $e) {
        // Gérer les erreurs de la base de données
        $msg_erreur = "Erreur lors de la modification des données";
        header("Location:../cat.php?erreur=$msg_erreur");
        exit();
    }
}
?>