<?php
session_start();
require_once('../../include/connexiondb.php');

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Récupérer les données soumises par le formulaire
    $designCat = $_POST['designCat'];
    $niveauCat = $_POST['niveauCat'];

    try {
        // Préparer la requête d'insertion
        $stmt = $pdo->prepare("INSERT INTO t_categ (designCat, niveauCat) 
        VALUES (:designCat, :niveauCat)");

        // Binder les valeurs aux paramètres
        $stmt->bindParam(':designCat', $designCat, PDO::PARAM_STR);
        $stmt->bindParam(':niveauCat', $niveauCat, PDO::PARAM_STR);

        // Exécuter la requête
        $stmt->execute();

        // Rediriger vers une page de succès ou afficher un message de succès
        $msg_erreur = "Catégorie ajoutée avec succès";
        header("Location:../cat.php?succes=$msg_erreur");
        exit();
    } catch (PDOException $e) {
        $msg_erreur = "Erreur lors de l'insertion des données";
        header("Location:../cat.php?erreur=$msg_erreur");
        exit();
    }
}
?>