<?php 
session_start();
if(!isset($_SESSION["login"]) && !isset($_SESSION['etat'])){
  header('Location:../index.php');
}

require_once('../include/connexiondb.php');
$idUser = $_SESSION['id'];
$des = isset($_GET['des']) ? $_GET['des'] : "";
$page_no = isset($_GET['page_no']) ? $_GET['page_no'] : 1;
$total_records_per_page = 15;
$offset = ($page_no - 1) * $total_records_per_page;
$previous_page = $page_no - 1;
$next_page = $page_no + 1;
$adjacents = "2";

$requeteRecord="SELECT count(*) AS total_records FROM agent INNER JOIN conge
ON conge.idA=agent.idA where nomA like '%$des%' OR motif like '%$des%'";
$total_records=$pdo->query($requeteRecord)->fetch();
$total_records = $total_records['total_records'];
$total_no_of_pages = ceil($total_records / $total_records_per_page);
$second_last = $total_no_of_pages - 1; 

$requete="SELECT * FROM agent INNER JOIN conge
ON conge.idA=agent.idA where nomA like '%$des%' OR motif
 like '%$des%' ORDER BY nomA ASC
LIMIT $offset, $total_records_per_page";
$resultat=$pdo->query($requete);

?>
<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_admin.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="classe.php">
          <i class="bi bi-slack"></i>
          <span>Classe</span>
        </a>
      </li><!-- End Classe Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#mat-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Maternelle</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="mat-nav" class="nav-content collapse" data-bs-parent="#sidebar-nav">
          <li>
            <a href="insmat.php">
              <i class="bi bi-circle"></i><span>Inscription</span>
            </a>
          </li>
          <li>
            <a href="presmat.php">
              <i class="bi bi-circle"></i><span>Présence</span>
            </a>
          </li>
          <li>
            <a href="ensmat.php">
              <i class="bi bi-circle"></i><span>Enseignants</span>
            </a>
          </li>
          <li>
            <a href="coursmat.php">
              <i class="bi bi-circle"></i><span>Cours</span>
            </a>
          </li>
          <li>
            <a href="pfmat.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
          <li>
            <a href="fraismat.php">
              <i class="bi bi-circle"></i><span>Type des Frais</span>
            </a>
          </li>
          <li>
            <a href="jurymat.php">
              <i class="bi bi-circle"></i><span>Jury</span>
            </a>
          </li>
        </ul>
      </li><!-- End Maternelle Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#prim-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Primaire</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="prim-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="inspri.php">
              <i class="bi bi-circle"></i><span>Inscription</span>
            </a>
          </li>
          <li>
            <a href="prespri.php">
              <i class="bi bi-circle"></i><span>Présence</span>
            </a>
          </li>
          <li>
            <a href="enspri.php">
              <i class="bi bi-circle"></i><span>Enseignants</span>
            </a>
          </li>
          <li>
            <a href="courspri.php">
              <i class="bi bi-circle"></i><span>Cours</span>
            </a>
          </li>
          <li>
            <a href="pfpri.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
          <li>
            <a href="fraispri.php">
              <i class="bi bi-circle"></i><span>Type des Frais</span>
            </a>
          </li>
          <li>
            <a href="jurypri.php">
              <i class="bi bi-circle"></i><span>Jury</span>
            </a>
          </li>
        </ul>
      </li><!-- End Primaire Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#sec-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Secondaire</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="sec-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="inssec.php">
              <i class="bi bi-circle"></i><span>Inscription</span>
            </a>
          </li>
          <li>
            <a href="presec.php">
              <i class="bi bi-circle"></i><span>Présence</span>
            </a>
          </li>
          <li>
            <a href="enssec.php">
              <i class="bi bi-circle"></i><span>Enseignants</span>
            </a>
          </li>
          <li>
            <a href="courssec.php">
              <i class="bi bi-circle"></i><span>Cours</span>
            </a>
          </li>
          <li>
            <a href="pfsec.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
          <li>
            <a href="fraissec.php">
              <i class="bi bi-circle"></i><span>Type des Frais</span>
            </a>
          </li>
          <li>
            <a href="jurysec.php">
              <i class="bi bi-circle"></i><span>Jury</span>
            </a>
          </li>
        </ul>
      </li><!-- End Secondaire Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="dep.php">
          <i class="bi bi-plus-slash-minus"></i>
          <span>Dépenses</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="com.php">
          <i class="bi bi-megaphone-fill"></i>
          <span>E-Communication</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link" data-bs-target="#grh-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-person-rolodex"></i><span>Ressources Humaines</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="grh-nav" class="nav-content collapse show" data-bs-parent="#sidebar-nav">
          <li>
            <a href="agent.php">
              <i class="bi bi-circle"></i><span>Employés</span>
            </a>
          </li>
          <li>
            <a href="conge.php" class="active">
              <i class="bi bi-circle"></i><span>Congés</span>
            </a>
          </li>
          <li>
            <a href="pres.php">
              <i class="bi bi-circle"></i><span>Présences</span>
            </a>
          </li>
          <li>
            <a href="avance.php">
              <i class="bi bi-circle"></i><span>Avances</span>
            </a>
          </li>
          <li>
            <a href="salaire.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
        </ul>
      </li><!-- End Ressources humaines Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#par-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-gear"></i><span>Paramètres</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="par-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="an.php">
              <i class="bi bi-circle"></i><span>Années Scolaires</span>
            </a>
          </li>
          <li>
            <a href="option.php">
              <i class="bi bi-circle"></i><span>Option</span>
            </a>
          </li>
          <li>
            <a href="cat.php">
              <i class="bi bi-circle"></i><span>Catégorie</span>
            </a>
          </li>
          <li>
            <a href="scat.php">
              <i class="bi bi-circle"></i><span>Sous-catégories</span>
            </a>
          </li>
          <li>
            <a href="ld.php">
              <i class="bi bi-circle"></i><span>Lignes de dépenses</span>
            </a>
          </li>
          <li>
            <a href="users.php">
              <i class="bi bi-circle"></i><span>Utilisateurs</span>
            </a>
          </li>
        </ul>
      </li><!-- End PArametre Nav -->

    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Congés</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
          <li class="breadcrumb-item active">Congés</li>
        </ol>
      </nav>
      <!-- Message d'erreur -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
        <div class="alert alert-warning" role="alert">
          <?php echo htmlspecialchars($_GET['erreur']); ?>
        </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
        <div class="alert alert-success" role="alert">
          <?php echo htmlspecialchars($_GET['succes']); ?>
        </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">
        <!-- TAbele data -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Gestion des congés des employés <span>| <a data-bs-toggle="modal" data-bs-target="#modalAddConge" class="btn btn-success"><i class="bi bi-plus-circle-fill"></i> AJOUTER</a>
                  | <a data-bs-toggle="modal" data-bs-target="#modalPrintConge" class="btn btn-warning"><i class="bi bi-printer-fill"></i> IMPRIMER</a>
                  </span></h5>

                  <form method="get" action="conge.php" class="searchform js__toggle">
                    <div class="input-group has-validation">
                      <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                      <input type="text" name="des" placeholder="Search..." class="form-control">
                      <button class="bi bi-search btn btn-info" type="submit" ></button>
                    </div>
                  </form>

                  <table class="table">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Nom</th>
                        <th scope="col">Motif</th>
                        <th scope="col">Début</th>
                        <th scope="col">Fin</th>
                        <th scope="col">Mois</th>
                        <th scope="col">Année</th>
                        <th scope="col">Retenu</th>
                        <th scope="col">Date</th>
                        <th scope="col">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $number = 1; while($data=$resultat->fetch()){ ?>
                        <tr>
                          <th scope="row"><?=$number?></th>
                          <td><?php echo $data['nomA']?></td>
                          <td><?php echo $data['motif']?></td>
                          <td><?php echo date('d-m-Y', strtotime($data['deb']))?></td>
                          <td>
                            <?php
                              $plusUnjourConge = date($data['fin'], strtotime('+1 day'));
                              $todayConge = date('Y-m-d');
                              if($todayConge>=$plusUnjourConge){
                                echo '<span style="color:#ffffff; background-color: #b90000;
                                display: inline-block; border-radius: 5px;text-align: center;font-size: 14px;padding: 10px;-webkit-transition: all 0.2s;
                                -moz-transition: all 0.2s;-o-transition: all 0.2s;transition: all 0.2s; margin: 2px;"> <strong> '.date('d-m-Y', strtotime($data['fin'])).' </strong> </span>';
                              }else{

                                echo date('d-m-Y', strtotime($data['fin']));
                              }
                            ?>
                          </td>
                          <td><?php echo $data['mC']?></td>
                          <td><?php echo $data['aC']?></td>
                          <td>
                            <?php
                              if($data['ret']>0){
                                  echo '<span style="color:#ffffff; background-color: #b90000;
                                  display: inline-block; border-radius: 5px;text-align: center;font-size: 14px;padding: 10px;-webkit-transition: all 0.2s;
                                  -moz-transition: all 0.2s;-o-transition: all 0.2s;transition: all 0.2s; margin: 2px;"> <strong> '.number_format($data['ret'],2,'.',' ').' </strong> </span>';
                                }else{
                                  echo number_format($data['ret'],2,'.',' ');
                                }
                            ?>
                          </td>
                          <td><?php echo date('d-m-Y', strtotime($data['dateC']))?></td>
                          <td>
                            <a data-bs-toggle="modal" data-bs-target="#modalUpdateConge<?php echo $data['idC']?>" class="btn btn-primary"><span class="bi bi-pencil-square"></span> </a>
                            &nbsp;
                            <a data-bs-toggle="modal" data-bs-target="#modalModifierEtatConge<?php echo $data['idC']?>">
                              <?php
                                if($data['etatC']=='En Conge')
                                  echo "<span class='btn btn-warning'> <i class='bi bi-x-circle-fill'></i> </span>";
                                else
                                  echo "<span class='btn btn-success'> <i class='bi bi-check-circle-fill'></i> </span>";
                              ?> 
                            </a>
                            &nbsp;
                            <a data-bs-toggle="modal" data-bs-target="#modalDeleteConge<?php echo $data['idC']?>" class="btn btn-danger"><span class="bi bi-x-octagon-fill"></span> </a>
                          </td>
                        </tr>
                      <?php $number++; include('modal_include/ModalmodifierPersonnel.php'); } ?> 
                    </tbody>
                  </table>

                  <ul class="pagination">
                    <?php // if($page_no > 1){ echo "<li><a href='?page_no=1'>First Page</a></li>"; } 
                    ?>

                    <li <?php if ($page_no <= 1) {
                        echo "class=' page-item disabled'";
                      } ?>>
                      <a class='page-link prevnext' <?php if ($page_no > 1) {
                                        echo "href='conge.php?page_no=$previous_page&des=$des'";
                                      } ?>>Previous</a>
                    </li>

                    <?php
                    if ($total_no_of_pages <= 10) {
                      for ($counter = 1; $counter <= $total_no_of_pages; $counter++) {
                        if ($counter == $page_no) {
                          echo "<li class='active class='page-item''><a class='page-link'>$counter</a></li>";
                        } else {
                          echo "<li class='page-item'><a class='page-link' href='conge.php?page_no=$counter&des=$des'>$counter</a></li>";
                        }
                      }
                    } elseif ($total_no_of_pages > 10) {

                      if ($page_no <= 4) {
                        for ($counter = 1; $counter < 8; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='conge.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='conge.php?page_no=$second_last&des=$des'>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='conge.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } elseif ($page_no > 4 && $page_no < $total_no_of_pages - 4) {
                        echo "<li class='page-item'><a class='page-link' href='conge.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='conge.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        for ($counter = $page_no - $adjacents; $counter <= $page_no + $adjacents; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='conge.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='conge.php?page_no=$second_last'&des=$des>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='conge.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } else {
                        echo "<li class='page-item'><a class='page-link' href='conge.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='conge.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";

                        for ($counter = $total_no_of_pages - 6; $counter <= $total_no_of_pages; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li  class='page-item'><a class='page-link' href='conge.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                      }
                    }
                    ?>

                    <li <?php if ($page_no >= $total_no_of_pages) {
                        echo "class='disabled page-item'";
                      } ?>>
                      <a class='page-link prevnext' <?php if ($page_no < $total_no_of_pages) {
                          echo "href='conge.php?page_no=$next_page'"; } ?>>Next</a>
                    </li>
                    <?php if ($page_no < $total_no_of_pages) {
                      echo "<li class='page-item'><a class='page-link prevnext' href='conge.php?page_no=$total_no_of_pages'>Last &rsaquo;&rsaquo;</a></li>";
                    } ?>
                  </ul>

                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->
      </div>
    </section>

  </main><!-- End #main -->

  <!-- MES DIFFERENTS MODALES -->

  <!-- MODAL ADD Agent -->
  <div class="modal fade" id="modalAddConge" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Ajouter un congé</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <form method="post" action="php_personnel/addConge.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

              <div class="row mb-3">
                <div class="col-md-12 col-lg-12">
                  <label for="titre" class="form-label">Agent</label>
                  <select class="form-select" name="idA" id="example-search">
                    <?php 
                      $requeteAg="select * from agent where etatA='En service'";
                      $resultatAg=$pdo->query($requeteAg);
                      while($result=$resultatAg->fetch()){?>
                      <option value="<?php echo $result['idA'];?>">
                        <?php echo $result['nomA']?>
                      </option>
                    <?php } ?>
                  </select>
                </div>
                <div class="col-md-12 col-lg-12">
                  <label for="titre" class="form-label">Motif</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-globe"></i></span>
                    <input type="text" name="motif" class="form-control" id="titre" required>
                    <div class="invalid-feedback">Veillez saisir le motif SVP !</div>
                  </div>
                </div>
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Date de Début</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-clock"></i></span>
                    <input type="date" name="deb" class="form-control" id="titre" required>
                    <div class="invalid-feedback">Veillez choirir la date SVP !</div>
                  </div>
                </div>
                <div class="col-md-6 col-lg-6">
                  <label for="titre" class="form-label">Date de Fin</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-clock"></i></span>
                    <input type="date" name="fin" class="form-control" id="titre" required>
                    <div class="invalid-feedback">Veillez choirir la date SVP !</div>
                  </div>
                </div>
              </div>

              <div class="modal-footer">
                <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
                <button type="submit" name="addConBtn" onclick="document.fo.submit()" class="btnModSave">Enregistrer</button>
              </div>
            </form><!-- End Change Password Form -->
        </div>
        
      </div>
    </div>
  </div><!-- End Modal ADD CLIENT-->

      <!-- MODAL ADD SERVICE -->
  <div class="modal fade" id="modalPrintConge" tabindex="-1">
    <div class="modal-dialog modal-dialog-centered">
      <div class="modal-content">
        <div class="modal-header">
          <h5 class="modal-title">Print différents congés</h5>
          <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
        </div>
        <div class="modal-body">
            <form method="post" action="../include/listeConge.php" class="tab-pane pt-3 needs-validation" enctype="multipart/form-data" novalidate>

              <div class="row mb-3">
                
                <div class="col-md-12 col-lg-12">
                  <label for="titre" class="form-label">Première Date</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-alarm-fill"></i></span>
                    <input type="date" name="date1" class="form-control" id="titre" required>
                    <div class="invalid-feedback">Veillez choisir la Date SVP !</div>
                  </div>
                </div>

                <div class="col-md-12 col-lg-12">
                  <label for="titre" class="form-label">Seconde Date</label>
                  <div class="input-group has-validation">
                    <span class="input-group-text" id="inputGroupPrepend"><i class="bi bi-alarm-fill"></i></span>
                    <input type="date" name="date2" class="form-control" id="titre" required>
                    <div class="invalid-feedback">Veillez choisir la Date SVP !</div>
                  </div>
                </div>
              </div>

              <div class="modal-footer">
                <button type="button" class="btnModClose" data-bs-dismiss="modal">Fermer</button>
                <button type="submit" name="printCongeBtn" onclick="document.fo.submit()" class="btnModSave">IMPRIMER</button>
              </div>
            </form><!-- End Change Password Form -->
        </div>
        
      </div>
    </div>
  </div><!-- End Modal ADD SERVICE-->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>