<?php
session_start();
if (!isset($_SESSION["login"])) {
  header('Location:../index.php');
}
require_once('../include/connexiondb.php');
require_once('php_include/some_fonctions.php');

$today = date("y-m-d");
$requete = "SELECT * FROM t_inscrit INNER JOIN t_classe ON 
t_inscrit.idC=t_classe.idC INNER JOIN t_an ON t_inscrit.idA=t_an.idA
INNER JOIN t_option ON t_classe.idO=t_option.idO INNER JOIN t_frais ON 
t_frais.idI = t_inscrit.idI INNER JOIN t_typeFrais ON 
t_typeFrais.idTF = t_frais.idTF INNER JOIN users ON t_frais.idUser = users.idUser WHERE 
t_frais.dateF='$today' ORDER BY nom ASC";
$resultat = $pdo->query($requete);

$requeteQ = "SELECT SUM(montF) AS tot, dateF AS DateJour FROM t_frais WHERE t_frais.dateF='$today'";
$resultatQ = $pdo->query($requeteQ);
$dataQ = $resultatQ->fetch();
$MontantJour = $dataQ['tot'];
$DateJour = $dataQ['DateJour'];
?>

<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_admin.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="classe.php">
          <i class="bi bi-slack"></i>
          <span>Classe</span>
        </a>
      </li><!-- End Classe Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#mat-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Maternelle</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="mat-nav" class="nav-content collapse" data-bs-parent="#sidebar-nav">
          <li>
            <a href="insmat.php">
              <i class="bi bi-circle"></i><span>Inscription</span>
            </a>
          </li>
          <li>
            <a href="presmat.php">
              <i class="bi bi-circle"></i><span>Présence</span>
            </a>
          </li>
          <li>
            <a href="ensmat.php">
              <i class="bi bi-circle"></i><span>Enseignants</span>
            </a>
          </li>
          <li>
            <a href="coursmat.php">
              <i class="bi bi-circle"></i><span>Cours</span>
            </a>
          </li>
          <li>
            <a href="pfmat.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
          <li>
            <a href="fraismat.php">
              <i class="bi bi-circle"></i><span>Type des Frais</span>
            </a>
          </li>
          <li>
            <a href="jurymat.php">
              <i class="bi bi-circle"></i><span>Jury</span>
            </a>
          </li>
        </ul>
      </li><!-- End Maternelle Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#prim-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Primaire</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="prim-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="inspri.php">
              <i class="bi bi-circle"></i><span>Inscription</span>
            </a>
          </li>
          <li>
            <a href="prespri.php">
              <i class="bi bi-circle"></i><span>Présence</span>
            </a>
          </li>
          <li>
            <a href="enspri.php">
              <i class="bi bi-circle"></i><span>Enseignants</span>
            </a>
          </li>
          <li>
            <a href="courspri.php">
              <i class="bi bi-circle"></i><span>Cours</span>
            </a>
          </li>
          <li>
            <a href="pfpri.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
          <li>
            <a href="fraispri.php">
              <i class="bi bi-circle"></i><span>Type des Frais</span>
            </a>
          </li>
          <li>
            <a href="jurypri.php">
              <i class="bi bi-circle"></i><span>Jury</span>
            </a>
          </li>
        </ul>
      </li><!-- End Primaire Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#sec-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Secondaire</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="sec-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="inssec.php">
              <i class="bi bi-circle"></i><span>Inscription</span>
            </a>
          </li>
          <li>
            <a href="presec.php">
              <i class="bi bi-circle"></i><span>Présence</span>
            </a>
          </li>
          <li>
            <a href="enssec.php">
              <i class="bi bi-circle"></i><span>Enseignants</span>
            </a>
          </li>
          <li>
            <a href="courssec.php">
              <i class="bi bi-circle"></i><span>Cours</span>
            </a>
          </li>
          <li>
            <a href="pfsec.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
          <li>
            <a href="fraissec.php">
              <i class="bi bi-circle"></i><span>Type des Frais</span>
            </a>
          </li>
          <li>
            <a href="jurysec.php">
              <i class="bi bi-circle"></i><span>Jury</span>
            </a>
          </li>
        </ul>
      </li><!-- End Secondaire Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="dep.php">
          <i class="bi bi-plus-slash-minus"></i>
          <span>Dépenses</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="com.php">
          <i class="bi bi-megaphone-fill"></i>
          <span>E-Communication</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#grh-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-person-rolodex"></i><span>Ressources Humaines</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="grh-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="agent.php">
              <i class="bi bi-circle"></i><span>Employés</span>
            </a>
          </li>
          <li>
            <a href="conge.php">
              <i class="bi bi-circle"></i><span>Congés</span>
            </a>
          </li>
          <li>
            <a href="pres.php">
              <i class="bi bi-circle"></i><span>Présences</span>
            </a>
          </li>
          <li>
            <a href="avance.php">
              <i class="bi bi-circle"></i><span>Avances</span>
            </a>
          </li>
          <li>
            <a href="salaire.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
        </ul>
      </li><!-- End Ressources humaines Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#par-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-gear"></i><span>Paramètres</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="par-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="an.php">
              <i class="bi bi-circle"></i><span>Années Scolaires</span>
            </a>
          </li>
          <li>
            <a href="option.php">
              <i class="bi bi-circle"></i><span>Option</span>
            </a>
          </li>
          <li>
            <a href="cat.php">
              <i class="bi bi-circle"></i><span>Catégorie</span>
            </a>
          </li>
          <li>
            <a href="scat.php">
              <i class="bi bi-circle"></i><span>Sous-catégories</span>
            </a>
          </li>
          <li>
            <a href="ld.php">
              <i class="bi bi-circle"></i><span>Lignes de dépenses</span>
            </a>
          </li>
          <li>
            <a href="users.php">
              <i class="bi bi-circle"></i><span>Utilisateurs</span>
            </a>
          </li>
        </ul>
      </li><!-- End PArametre Nav -->

    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Tableau de bord</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Acceuil</a></li>
          <li class="breadcrumb-item active">Tableau de bord</li>
        </ol>
      </nav>
      <!-- LECTURE D'ERREUR -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
          <div class="alert alert-warning" role="alert">
            <?php echo htmlspecialchars($_GET['erreur']); ?>
          </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
          <div class="alert alert-success" role="alert">
            <?php echo htmlspecialchars($_GET['succes']); ?>
          </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">

        <!-- Left side columns -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Agent Card -->
            <div class="col-xxl-4 col-md-4">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Agents <span>| Tous</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-person-square"></i>
                    </div>
                    <div class="ps-3">
                      <h6><?= getNbAgent($pdo) ?></h6>
                      <span class="text-success small pt-1 fw-bold"> <a href="agent.php">Employés</a> </span>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End Agent Card -->

            <!-- Mat Card -->
            <div class="col-xxl-4 col-md-4">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Maternelle <span>| Inscription</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-person-square"></i>
                    </div>
                    <div class="ps-3">
                      <h6><?= getNbMatIns($pdo) ?></h6>
                      <span class="text-success small pt-1 fw-bold"> <a href="#">Gestion des élèves</a> </span>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End Mat Card -->



            <!-- Mat Card -->
            <div class="col-xxl-4 col-md-4">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Maternelle <span>| Classe</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-person-square"></i>
                    </div>
                    <div class="ps-3">
                      <h6><?= getNbMatClasse($pdo) ?></h6>
                      <span class="text-success small pt-1 fw-bold"> <a href="#">Classe</a> </span>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End Mat Card -->

            <!-- Prim Card -->
            <div class="col-xxl-4 col-md-4">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Primaire <span>| Inscription</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-person-square"></i>
                    </div>
                    <div class="ps-3">
                      <h6><?= getNbPriIns($pdo) ?></h6>
                      <span class="text-success small pt-1 fw-bold"> <a href="#">Gestion des élèves</a> </span>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End prim Card -->





            <!-- Prim Card -->
            <div class="col-xxl-4 col-md-4">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Primaire <span>| Classe</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-person-square"></i>
                    </div>
                    <div class="ps-3">
                      <h6><?= getNbPriClasse($pdo) ?></h6>
                      <span class="text-success small pt-1 fw-bold"> <a href="#">Classes</a> </span>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End prim Card -->

            <!-- Sec Card -->
            <div class="col-xxl-4 col-md-4">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Secondaire <span>| Inscription</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-person-square"></i>
                    </div>
                    <div class="ps-3">
                      <h6><?= getNbSecIns($pdo) ?></h6>
                      <span class="text-success small pt-1 fw-bold"> <a href="#">Gestion des élèves</a> </span>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End sec Card -->

            <!-- sec Card -->
            <div class="col-xxl-4 col-md-4">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Secondaire <span>| Classe</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-person-square"></i>
                    </div>
                    <div class="ps-3">
                      <h6><?= getNbSecClasse($pdo) ?></h6>
                      <span class="text-success small pt-1 fw-bold"> <a href="#">Classes</a> </span>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End prim Card -->

            <div class="col-xxl-8 col-md-8">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Frais Scolaires <span>| Totals</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-3">
                      <h6><?= getPayeValeur($pdo) ?> $ </h6>
                      <span class="text-success small pt-1 fw-bold"> <a href="#">Frais Scolaires</a> </span>

                    </div>
                  </div>
                </div>

              </div>
            </div><!-- End frais scolaires Card -->

            <div class="col-xxl-3 col-md-3">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Total Janvier <span> Totals</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-1">
                      <h6><?php echo getValeurMois("Janvier", $maxAS, $pdo)  ?> $</h6>
                      <span class="text-primary small pt-1 fw-bold">Janvier </span>
                    </div>
                  </div>
                </div>
              </div>
            </div><!-- End frais scolaires Card -->

            <div class="col-xxl-3 col-md-3">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Total Févier <span> Totals</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-1">
                      <h6><?php echo getValeurMois("Fevrier", $maxAS, $pdo)  ?> $</h6>
                      <span class="text-primary small pt-1 fw-bold"> Février </span>
                    </div>
                  </div>
                </div>
              </div>
            </div><!-- End frais scolaires Card -->

            <div class="col-xxl-3 col-md-3">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Total Mars <span> Totals</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-1">
                      <h6><?php echo getValeurMois("Mars", $maxAS, $pdo)  ?> $</h6>
                      <span class="text-primary small pt-1 fw-bold"> Mars </span>
                    </div>
                  </div>
                </div>
              </div>
            </div><!-- End frais scolaires Card -->

            <div class="col-xxl-3 col-md-3">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Total Avril <span> Totals</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-1">
                      <h6><?php echo getValeurMois("Avril", $maxAS, $pdo)  ?> $</h6>
                      <span class="text-primary small pt-1 fw-bold"> Avril </span>
                    </div>
                  </div>
                </div>
              </div>
            </div><!-- End frais scolaires Card -->


            <div class="col-xxl-3 col-md-3">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Total Mai <span> Totals</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-1">
                      <h6><?php echo getValeurMois("Mai", $maxAS, $pdo)  ?> $</h6>
                      <span class="text-primary small pt-1 fw-bold"> Mai </span>
                    </div>
                  </div>
                </div>
              </div>
            </div><!-- End frais scolaires Card -->

            <div class="col-xxl-3 col-md-3">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Total Juin <span> Totals</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-1">
                      <h6><?php echo getValeurMois("Juin", $maxAS, $pdo)  ?> $</h6>
                      <span class="text-primary small pt-1 fw-bold"> Juin </span>
                    </div>
                  </div>
                </div>
              </div>
            </div><!-- End frais scolaires Card -->

            <div class="col-xxl-3 col-md-3">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Total Juillet <span> Totals</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-1">
                      <h6><?php echo getValeurMois("Juillet", $maxAS, $pdo)  ?> $</h6>
                      <span class="text-primary small pt-1 fw-bold"> Juillet </span>
                    </div>
                  </div>
                </div>
              </div>
            </div><!-- End frais scolaires Card -->


            <div class="col-xxl-3 col-md-3">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Total Août <span> Totals</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-1">
                      <h6><?php echo getValeurMois("Aout", $maxAS, $pdo)  ?> $</h6>
                      <span class="text-primary small pt-1 fw-bold"> Août </span>
                    </div>
                  </div>
                </div>
              </div>
            </div><!-- End frais scolaires Card -->

            <div class="col-xxl-3 col-md-3">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Total Septembre <span> Totals</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-1">
                      <h6><?php echo getValeurMois("Septembre", $maxAS, $pdo); ?> $</h6>
                      <span class="text-primary small pt-1 fw-bold"> Septembre </span>
                    </div>
                  </div>
                </div>
              </div>
            </div><!-- End frais scolaires Card -->


            <div class="col-xxl-3 col-md-3">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Total Octobre <span> Totals</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-1">
                      <h6><?php echo getValeurMois("Octobre", $maxAS, $pdo) ?> $</h6>
                      <span class="text-primary small pt-1 fw-bold"> Octobre </span>
                    </div>
                  </div>
                </div>
              </div>
            </div><!-- End frais scolaires Card -->


            <div class="col-xxl-3 col-md-3">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Total Novembre <span> Totals</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-1">
                      <h6><?php echo getValeurMois("Novembre", $maxAS, $pdo) ?> $</h6>
                      <span class="text-primary small pt-1 fw-bold"> Novembre </span>
                    </div>
                  </div>
                </div>
              </div>
            </div><!-- End frais scolaires Card -->


            <div class="col-xxl-3 col-md-3">
              <div class="card info-card sales-card">

                <div class="card-body">
                  <h5 class="card-title">Total Décembre <span> Totals</span></h5>

                  <div class="d-flex align-items-center">
                    <div class="card-icon rounded-circle d-flex align-items-center justify-content-center">
                      <i class="bi bi-currency-exchange"></i>
                    </div>
                    <div class="ps-1">
                      <h6><?php echo getValeurMois("Decembre", $maxAS, $pdo)  ?> $</h6>
                      <span class="text-primary small pt-1 fw-bold"> Décembre </span>
                    </div>
                  </div>
                </div>
              </div>
            </div><!-- End frais scolaires Card -->

            <!-- Recent paie -->
            <div class="col-12">
              <div class="card recent-sales overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Les paiements Journaliers <span>| <?php echo date('d-m-Y', strtotime($DateJour)) ?></span></h5>
                  <table class="table datatable table-borderless">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">User</th>
                        <th scope="col">Elève</th>
                        <th scope="col">Classe</th>
                        <th scope="col">Motif</th>
                        <th scope="col">Montant</th>
                        <th scope="col">Reçu</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php
                      $number = 1;
                      while ($data = $resultat->fetch()) { ?>
                        <tr>
                          <th scope="row"><?php echo $number ?></th>
                          <td><?php echo $data['nomUser'] ?></td>
                          <td><?php echo $data['nom'] ?></td>
                          <td><?php echo $data['design'] . " " . $data['designO'] . " " . $data['ord'] ?></td>
                          <td><?php echo $data['designTF'] ?></td>
                          <td><?php echo $data['montF'] ?> $</td>
                          <td>
                            <a data-bs-toggle="modal" data-bs-target="#modalPrintRecu<?php echo $data['idF'] ?>" class="btn btn-info"><span class="bi bi-printer-fill"></span> </a>
                          </td>
                        </tr>
                      <?php $number++;
                        include('modal_include/ModalmodifierFrais.php');
                      } ?>
                    </tbody>
                  </table>
                  <h5 style="text-align: center; background-color: #003459; color: white; padding : 7px;">TOTAL JOURNALIER ::: <strong><?= number_format($MontantJour, 2, '.', ' ') . ' $' ?></strong></h5>
                </div>

              </div>
            </div><!-- End Ventes messages -->

          </div>
        </div><!-- End Left side columns -->

      </div>
    </section>

  </main><!-- End #main -->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>