<?php
session_start();
require_once('../../include/connexiondb.php');

define('UPLOAD_PATH', '../../uploads/');
define('MAX_PHOTO_SIZE', 10000000);

function redirectWithError($msg) {
    header("Location: ../users.php?erreur=$msg");
    exit();
}

function redirectWithSuccess($msg) {
    header("Location: ../users.php?succes=$msg");
    exit();
}

if (isset($_POST['ModifUserBtn'])) {
    // Modifier les informations de l'utilisateur
    $idUser = $_POST['idUser'];
    $nom = $_POST['nom'];
    $fonction = $_POST['fonction'];
    $log = $_POST['log'];

    $sql = "UPDATE users SET `nomUser`=?, `loginUser`=?, `fonction`=? WHERE `idUser`=?";
    $req = $pdo->prepare($sql);
    $req->execute([$nom, $log, $fonction, $idUser]);

    redirectWithSuccess("Utilisateur modifié avec succès");
} elseif (isset($_POST['photoBtn'])) {
    // Modifier la photo de l'utilisateur
    $idUser = $_POST['idUser'];
    $photo = $_FILES['photo'];
    $photo_name = $photo['name'];
    $photo_size = $photo['size'];
    $tmp_name = $photo['tmp_name'];
    $error = $photo['error'];

    if ($error === 0) {
        if ($photo_size > MAX_PHOTO_SIZE) {
            redirectWithError("Une image ne doit pas dépasser 10 Méga");
        } else {
            $img_ex = pathinfo($photo_name, PATHINFO_EXTENSION);
            $img_ex_lc = strtolower($img_ex);
            $allowed_exs = array("jpeg", "jpg", "png");

            if (in_array($img_ex_lc, $allowed_exs)) {
                $new_name_photo = uniqid("USER-", true) . '.' . $img_ex_lc;
                $image_Path_upload = UPLOAD_PATH . $new_name_photo;
                move_uploaded_file($tmp_name, $image_Path_upload);

                $sql = "UPDATE users SET `imageUser`=? WHERE `idUser`=?";
                $req = $pdo->prepare($sql);
                $req->execute([$new_name_photo, $idUser]);

                redirectWithSuccess("Utilisateur modifié avec succès");
            } else {
                redirectWithError("Erreur d'extension (Seulement JPEG, JPG, PNG)");
            }
        }
    }
} elseif (isset($_POST['PwBtn'])) {
    // Modifier le mot de passe de l'utilisateur
    $idUser = $_POST['idUser'];
    $pw = $_POST['pw'];
    $hash = password_hash($pw, PASSWORD_DEFAULT);

    $sql = "UPDATE users SET `pw`=? WHERE `idUser`=?";
    $req = $pdo->prepare($sql);
    $req->execute([$hash, $idUser]);

    redirectWithSuccess("Mot de passe modifié avec succès");
} else {
    redirectWithError("Une erreur dans les issets");
}
?>
