<?php
session_start();
require_once('../../include/connexiondb.php');

if ($_SERVER["REQUEST_METHOD"] == "POST") {
    // Récupérez les données du formulaire
    $idC = $_POST['idC'];
    $idJ = $_POST['idJ'];

    // Vérifiez si l'idC a déjà un idJ
    $checkIdCQuery = "SELECT idAJ FROM t_aff_jury WHERE idC = :idC LIMIT 1";
    $checkIdCStatement = $pdo->prepare($checkIdCQuery);
    $checkIdCStatement->bindParam(":idC", $idC, PDO::PARAM_INT);
    $checkIdCStatement->execute();
    $existingRow = $checkIdCStatement->fetch(PDO::FETCH_ASSOC);

    if ($existingRow) {
        // Insérer les données dans la table t_aff_jury
        $insertQuery = "UPDATE t_aff_jury SET idJ = :idJ WHERE idC = :idC";
        $insertStatement = $pdo->prepare($insertQuery);
        $insertStatement->bindParam(":idJ", $idJ, PDO::PARAM_INT);
        $insertStatement->bindParam(":idC", $idC, PDO::PARAM_INT);
        
        if ($insertStatement->execute()) {
            $msg_erreur = "Affectation modifiée avec succès !";
            header("Location:../classe.php?succes=$msg_erreur");
            exit();
        } else {
            $msg_erreur = "Une erreur est survenue lors de la modification de l'affectation.";
            header("Location:../classe.php?erreur=$msg_erreur");
            exit();
        }
    } else {
        // Insérer les données dans la table t_aff_jury
        $insertQuery = "INSERT INTO t_aff_jury (idJ, idC) VALUES (:idJ, :idC)";
        $insertStatement = $pdo->prepare($insertQuery);
        $insertStatement->bindParam(":idJ", $idJ, PDO::PARAM_INT);
        $insertStatement->bindParam(":idC", $idC, PDO::PARAM_INT);
        
        if ($insertStatement->execute()) {
            echo "Affectation réussie !";
            $msg_erreur = "Affectation réussie !";
            header("Location:../classe.php?succes=$msg_erreur");
            exit();
        } else {
            $msg_erreur = "Une erreur est survenue lors de l'affectation.";
            header("Location:../classe.php?erreur=$msg_erreur");
            exit();
        }
    }
}
?>
