<?php
session_start();
require_once('../../include/connexiondb.php');

// Vérifiez si le formulaire a été soumis
if ($_SERVER["REQUEST_METHOD"] == "POST") {
    try {
        // Récupérez les données du formulaire
        $idCat = $_POST["idCat"];
        $designSousCat = $_POST["designSousCat"];
        $niveauSousCat = $_POST["niveauSousCat"];

        // Préparez la requête d'insertion
        $sql = "INSERT INTO t_sous_categ (idCat, designSousCat, niveauSousCat) 
        VALUES (:idCat, :designSousCat, :niveauSousCat)";
        $stmt = $pdo->prepare($sql);

        // Liez les paramètres
        $stmt->bindParam(":idCat", $idCat, PDO::PARAM_INT);
        $stmt->bindParam(":designSousCat", $designSousCat, PDO::PARAM_STR);
        $stmt->bindParam(":niveauSousCat", $niveauSousCat, PDO::PARAM_STR);

        // Exécutez la requête
        $stmt->execute();

        // Affichez un message de succès
        $msg_erreur = "Catégorie ajoutée avec succès";
        header("Location:../scat.php?succes=$msg_erreur");
        exit();

    } catch (PDOException $e) {
        // Gérez les erreurs PDO ici
        $msg_erreur = "Echec d'enregistrement";
        header("Location:../scat.php?erreur=$msg_erreur");
        exit();
    }
}

?>
