<?php
session_start();
if (!isset($_SESSION["login"]) && !isset($_SESSION['etat'])) {
  header('Location:../index.php');
}

require_once('../include/connexiondb.php');

$idUser = $_SESSION['id'];
$des = isset($_GET['des']) ? $_GET['des'] : "";
$page_no = isset($_GET['page_no']) ? $_GET['page_no'] : 1;
$total_records_per_page = 15;
$offset = ($page_no - 1) * $total_records_per_page;
$previous_page = $page_no - 1;
$next_page = $page_no + 1;
$adjacents = "2";

$requeteRecord = "SELECT count(*) AS total_records 
FROM t_ens WHERE nivEns='Maternelle' AND  nomEns LIKE '%$des%'";
$total_records = $pdo->query($requeteRecord)->fetch();
$total_records = $total_records['total_records'];
$total_no_of_pages = ceil($total_records / $total_records_per_page);
$second_last = $total_no_of_pages - 1;
$requete = "SELECT * FROM t_ens WHERE nivEns='Maternelle' AND nomEns LIKE '%$des%' ORDER BY
nomEns ASC LIMIT $offset, $total_records_per_page";
$resultat = $pdo->query($requete);

?>
<!DOCTYPE html>
<html lang="fr">

<!-- Head and importation des packages -->
<?php include("../include/head.php"); ?>

<body>

  <!-- ======= Header ======= -->
  <?php include("../include/header_admin.php"); ?>

  <!-- Menu principal -->
  <!-- ======= Sidebar ======= -->
  <aside id="sidebar" class="sidebar">
    <ul class="sidebar-nav" id="sidebar-nav">

      <li class="nav-item">
        <a class="nav-link collapsed" href="acceuil.php">
          <i class="bi bi-grid"></i>
          <span>Tableau de bord</span>
        </a>
      </li><!-- End Dashboard Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="classe.php">
          <i class="bi bi-slack"></i>
          <span>Classe</span>
        </a>
      </li><!-- End Classe Page Nav -->

      <li class="nav-item">
        <a class="nav-link" data-bs-target="#mat-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Maternelle</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="mat-nav" class="nav-content collapse show" data-bs-parent="#sidebar-nav">
          <li>
            <a href="insmat.php">
              <i class="bi bi-circle"></i><span>Inscription</span>
            </a>
          </li>
          <li>
            <a href="presmat.php">
              <i class="bi bi-circle"></i><span>Présence</span>
            </a>
          </li>
          <li>
            <a href="ensmat.php" class="active">
              <i class="bi bi-circle"></i><span>Enseignants</span>
            </a>
          </li>
          <li>
            <a href="coursmat.php">
              <i class="bi bi-circle"></i><span>Cours</span>
            </a>
          </li>
          <li>
            <a href="pfmat.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
          <li>
            <a href="fraismat.php">
              <i class="bi bi-circle"></i><span>Type des Frais</span>
            </a>
          </li>
          <li>
            <a href="jurymat.php">
              <i class="bi bi-circle"></i><span>Jury</span>
            </a>
          </li>
        </ul>
      </li><!-- End Maternelle Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#prim-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Primaire</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="prim-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="inspri.php">
              <i class="bi bi-circle"></i><span>Inscription</span>
            </a>
          </li>
          <li>
            <a href="prespri.php">
              <i class="bi bi-circle"></i><span>Présence</span>
            </a>
          </li>
          <li>
            <a href="enspri.php">
              <i class="bi bi-circle"></i><span>Enseignants</span>
            </a>
          </li>
          <li>
            <a href="courspri.php">
              <i class="bi bi-circle"></i><span>Cours</span>
            </a>
          </li>
          <li>
            <a href="pfpri.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
          <li>
            <a href="fraispri.php">
              <i class="bi bi-circle"></i><span>Type des Frais</span>
            </a>
          </li>
          <li>
            <a href="jurypri.php">
              <i class="bi bi-circle"></i><span>Jury</span>
            </a>
          </li>
        </ul>
      </li><!-- End Primaire Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#sec-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-globe"></i><span>Secondaire</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="sec-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="inssec.php">
              <i class="bi bi-circle"></i><span>Inscription</span>
            </a>
          </li>
          <li>
            <a href="presec.php">
              <i class="bi bi-circle"></i><span>Présence</span>
            </a>
          </li>
          <li>
            <a href="enssec.php">
              <i class="bi bi-circle"></i><span>Enseignants</span>
            </a>
          </li>
          <li>
            <a href="courssec.php">
              <i class="bi bi-circle"></i><span>Cours</span>
            </a>
          </li>
          <li>
            <a href="pfsec.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
          <li>
            <a href="fraissec.php">
              <i class="bi bi-circle"></i><span>Type des Frais</span>
            </a>
          </li>
          <li>
            <a href="jurysec.php">
              <i class="bi bi-circle"></i><span>Jury</span>
            </a>
          </li>
        </ul>
      </li><!-- End Secondaire Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="dep.php">
          <i class="bi bi-plus-slash-minus"></i>
          <span>Dépenses</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" href="com.php">
          <i class="bi bi-megaphone-fill"></i>
          <span>E-Communication</span>
        </a>
      </li><!-- End Depenses Page Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#grh-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-person-rolodex"></i><span>Ressources Humaines</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="grh-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="agent.php">
              <i class="bi bi-circle"></i><span>Employés</span>
            </a>
          </li>
          <li>
            <a href="conge.php">
              <i class="bi bi-circle"></i><span>Congés</span>
            </a>
          </li>
          <li>
            <a href="pres.php">
              <i class="bi bi-circle"></i><span>Présences</span>
            </a>
          </li>
          <li>
            <a href="avance.php">
              <i class="bi bi-circle"></i><span>Avances</span>
            </a>
          </li>
          <li>
            <a href="salaire.php">
              <i class="bi bi-circle"></i><span>Paiements</span>
            </a>
          </li>
        </ul>
      </li><!-- End Ressources humaines Nav -->

      <li class="nav-item">
        <a class="nav-link collapsed" data-bs-target="#par-nav" data-bs-toggle="collapse" href="#">
          <i class="bi bi-gear"></i><span>Paramètres</span><i class="bi bi-chevron-down ms-auto"></i>
        </a>
        <ul id="par-nav" class="nav-content collapse " data-bs-parent="#sidebar-nav">
          <li>
            <a href="an.php">
              <i class="bi bi-circle"></i><span>Années Scolaires</span>
            </a>
          </li>
          <li>
            <a href="option.php">
              <i class="bi bi-circle"></i><span>Option</span>
            </a>
          </li>
          <li>
            <a href="cat.php">
              <i class="bi bi-circle"></i><span>Catégorie</span>
            </a>
          </li>
          <li>
            <a href="scat.php">
              <i class="bi bi-circle"></i><span>Sous-catégories</span>
            </a>
          </li>
          <li>
            <a href="ld.php">
              <i class="bi bi-circle"></i><span>Lignes de dépenses</span>
            </a>
          </li>
          <li>
            <a href="users.php">
              <i class="bi bi-circle"></i><span>Utilisateurs</span>
            </a>
          </li>
        </ul>
      </li><!-- End PArametre Nav -->

    </ul>

  </aside><!-- End Sidebar -->

  <!-- Espace de travail -->
  <main id="main" class="main">

    <div class="pagetitle">
      <h1>Enseignants</h1>
      <nav>
        <ol class="breadcrumb">
          <li class="breadcrumb-item"><a href="acceuil.php">Tableau de bord</a></li>
          <li class="breadcrumb-item active">Enseignants</li>
        </ol>
      </nav>
      <!-- Message d'erreur -->
      <center>
        <?php if (isset($_GET['erreur'])) { ?>
          <div class="alert alert-warning" role="alert">
            <?php echo htmlspecialchars($_GET['erreur']); ?>
          </div>
        <?php } ?>
        <?php if (isset($_GET['succes'])) { ?>
          <div class="alert alert-success" role="alert">
            <?php echo htmlspecialchars($_GET['succes']); ?>
          </div>
        <?php } ?>
      </center>
    </div><!-- End Page Title -->

    <!-- Section Dashbord -->
    <section class="section dashboard">
      <div class="row">
        <!-- TAbele data -->
        <div class="col-lg-12">
          <div class="row">
            <!-- Table service -->
            <div class="col-12">
              <div class="card overflow-auto">

                <div class="card-body">
                  <h5 class="card-title">Liste des enseignants <span>| Tous </span></h5>

                  <form method="get" action="ensmat.php" class="searchform js__toggle">
                    <div class="input-group has-validation">
                      <span class="input-group-text" id="inputGroupPrepend"><i>&#9764;</i></span>
                      <input type="text" name="des" placeholder="Search..." class="form-control">
                      <button class="bi bi-search btn btn-info" type="submit"></button>
                    </div>
                  </form>

                  <table class="table">
                    <thead>
                      <tr>
                        <th scope="col">#</th>
                        <th scope="col">Nom</th>
                        <th scope="col">Login</th>
                        <th scope="col">Actions</th>
                      </tr>
                    </thead>
                    <tbody>
                      <?php $number = 1;
                      while ($data = $resultat->fetch()) { ?>
                        <tr>
                          <th scope="row"> <?=$number?> </th>
                          <td><a class="btn" data-bs-toggle="modal" data-bs-target="#ModalViewPhoto<?php echo $data['idEns'] ?>"><img src="../uploads/<?php echo $data['imageEns'] ?>" width="30" height="30" class="img-fluid rounded-4" alt=""></a> <?php echo $data['nomEns'] ?></td>
                          <td><?php echo $data['loginEns'] ?></td>
                          <td>
                            <a data-bs-toggle="modal" data-bs-target="#modalUpdateEns<?php echo $data['idEns'] ?>" class="btn btn-primary"><span class="bi bi-pencil-square"></span> <strong> Modifier </strong> </a>
                            &nbsp; &nbsp;
                            <a href="php_cote/etatEns.php?idEns=<?php echo $data['idEns'] ?>&etat=<?php echo $data['etatEns'] ?>&niv=<?php echo $data['nivEns'] ?>">
                              <?php
                              if ($data['etatEns'] == 'Inactif')
                                echo "<span class='btn btn-danger'> <i class='bi bi-x-circle-fill'></i> <strong> Inactif </strong> </span>";
                              else
                                echo "<span class='btn btn-success'> <i class='bi bi-check-circle-fill'></i> <strong> Actif </strong> </span>";
                              ?>
                            </a>
                          </td>
                        </tr>
                      <?php $number++;
                        include('modal_include/ModalmodifierCote.php');
                      } ?>
                    </tbody>
                  </table>
                  <!-- PAGINATION -->
                  <ul class="pagination">
                    <?php // if($page_no > 1){ echo "<li><a href='?page_no=1'>First Page</a></li>"; } 
                    ?>

                    <li <?php if ($page_no <= 1) {
                          echo "class=' page-item disabled'";
                        } ?>>
                      <a class='page-link prevnext' <?php if ($page_no > 1) {
                                                      echo "href='ensmat.php?page_no=$previous_page&des=$des'";
                                                    } ?>>Previous</a>
                    </li>

                    <?php
                    if ($total_no_of_pages <= 10) {
                      for ($counter = 1; $counter <= $total_no_of_pages; $counter++) {
                        if ($counter == $page_no) {
                          echo "<li class='active class='page-item''><a class='page-link'>$counter</a></li>";
                        } else {
                          echo "<li class='page-item'><a class='page-link' href='ensmat.php?page_no=$counter&des=$des'>$counter</a></li>";
                        }
                      }
                    } elseif ($total_no_of_pages > 10) {

                      if ($page_no <= 4) {
                        for ($counter = 1; $counter < 8; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='ensmat.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='ensmat.php?page_no=$second_last&des=$des'>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='ensmat.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } elseif ($page_no > 4 && $page_no < $total_no_of_pages - 4) {
                        echo "<li class='page-item'><a class='page-link' href='ensmat.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='ensmat.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        for ($counter = $page_no - $adjacents; $counter <= $page_no + $adjacents; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li class='page-item'><a class='page-link' href='ensmat.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='ensmat.php?page_no=$second_last'&des=$des>$second_last</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='ensmat.php?page_no=$total_no_of_pages&des=$des'>$total_no_of_pages</a></li>";
                      } else {
                        echo "<li class='page-item'><a class='page-link' href='ensmat.php?page_no=1&des=$des'>1</a></li>";
                        echo "<li class='page-item'><a class='page-link' href='ensmat.php?page_no=2&des=$des'>2</a></li>";
                        echo "<li class='page-item'><a class='page-link'>...</a></li>";

                        for ($counter = $total_no_of_pages - 6; $counter <= $total_no_of_pages; $counter++) {
                          if ($counter == $page_no) {
                            echo "<li class='page-item active'><a class='page-link'>$counter</a></li>";
                          } else {
                            echo "<li  class='page-item'><a class='page-link' href='ensmat.php?page_no=$counter&des=$des'>$counter</a></li>";
                          }
                        }
                      }
                    }
                    ?>

                    <li <?php if ($page_no >= $total_no_of_pages) {
                          echo "class='disabled page-item'";
                        } ?>>
                      <a class='page-link prevnext' <?php if ($page_no < $total_no_of_pages) {
                                                      echo "href='ensmat.php?page_no=$next_page'";
                                                    } ?>>Next</a>
                    </li>
                    <?php if ($page_no < $total_no_of_pages) {
                      echo "<li class='page-item'><a class='page-link prevnext' href='ensmat.php?page_no=$total_no_of_pages'>Last &rsaquo;&rsaquo;</a></li>";
                    }
                    ?>
                  </ul>

                </div>

              </div>
            </div><!-- End Recent messages -->

          </div>
        </div><!-- End table data -->
      </div>
    </section>

  </main><!-- End #main -->

  <!-- Footer et importation JavaScript -->
  <?php include("../include/footer.php"); ?>

</body>

</html>